/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.VisibilityConfigCreator;
import android.app.appsearch.VisibilityPermissionConfig;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.PackageIdentifierParcel;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
@SafeParcelable.Class(creator="VisibilityConfigCreator")
public class SchemaVisibilityConfig
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<SchemaVisibilityConfig> CREATOR = new VisibilityConfigCreator();
    @SafeParcelable.Field(id=1)
    @NonNull
    final List<PackageIdentifierParcel> mAllowedPackages;
    @SafeParcelable.Field(id=2)
    @NonNull
    final List<VisibilityPermissionConfig> mRequiredPermissions;
    @SafeParcelable.Field(id=3)
    @Nullable
    final PackageIdentifierParcel mPubliclyVisibleTargetPackage;
    @Nullable
    private Integer mHashCode;
    @Nullable
    private List<PackageIdentifier> mAllowedPackagesCached;
    @Nullable
    private Set<Set<Integer>> mRequiredPermissionsCached;

    @SafeParcelable.Constructor
    SchemaVisibilityConfig(@SafeParcelable.Param(id=1) @NonNull List<PackageIdentifierParcel> allowedPackages, @SafeParcelable.Param(id=2) @NonNull List<VisibilityPermissionConfig> requiredPermissions, @SafeParcelable.Param(id=3) @Nullable PackageIdentifierParcel publiclyVisibleTargetPackage) {
        this.mAllowedPackages = Objects.requireNonNull(allowedPackages);
        this.mRequiredPermissions = Objects.requireNonNull(requiredPermissions);
        this.mPubliclyVisibleTargetPackage = publiclyVisibleTargetPackage;
    }

    @NonNull
    public List<PackageIdentifier> getAllowedPackages() {
        if (this.mAllowedPackagesCached == null) {
            this.mAllowedPackagesCached = new ArrayList<PackageIdentifier>(this.mAllowedPackages.size());
            for (int i = 0; i < this.mAllowedPackages.size(); ++i) {
                this.mAllowedPackagesCached.add(new PackageIdentifier(this.mAllowedPackages.get(i)));
            }
        }
        return this.mAllowedPackagesCached;
    }

    @NonNull
    public Set<Set<Integer>> getRequiredPermissions() {
        if (this.mRequiredPermissionsCached == null) {
            this.mRequiredPermissionsCached = new ArraySet<Set<Integer>>(this.mRequiredPermissions.size());
            for (int i = 0; i < this.mRequiredPermissions.size(); ++i) {
                VisibilityPermissionConfig permissionConfig = this.mRequiredPermissions.get(i);
                Set<Integer> requiredPermissions = permissionConfig.getAllRequiredPermissions();
                if (this.mRequiredPermissionsCached == null || requiredPermissions == null) continue;
                this.mRequiredPermissionsCached.add(requiredPermissions);
            }
        }
        return Objects.requireNonNull(this.mRequiredPermissionsCached);
    }

    @Nullable
    public PackageIdentifier getPubliclyVisibleTargetPackage() {
        if (this.mPubliclyVisibleTargetPackage == null) {
            return null;
        }
        return new PackageIdentifier(this.mPubliclyVisibleTargetPackage);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        VisibilityConfigCreator.writeToParcel(this, dest, flags);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof SchemaVisibilityConfig)) {
            return false;
        }
        SchemaVisibilityConfig that = (SchemaVisibilityConfig)o;
        return Objects.equals(this.mAllowedPackages, that.mAllowedPackages) && Objects.equals(this.mRequiredPermissions, that.mRequiredPermissions) && Objects.equals(this.mPubliclyVisibleTargetPackage, that.mPubliclyVisibleTargetPackage);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = Objects.hash(this.mAllowedPackages, this.mRequiredPermissions, this.mPubliclyVisibleTargetPackage);
        }
        return this.mHashCode;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
    public static class Builder {
        private List<PackageIdentifierParcel> mAllowedPackages = new ArrayList<PackageIdentifierParcel>();
        private List<VisibilityPermissionConfig> mRequiredPermissions = new ArrayList<VisibilityPermissionConfig>();
        @Nullable
        private PackageIdentifierParcel mPubliclyVisibleTargetPackage;
        private boolean mBuilt;

        public Builder() {
        }

        public Builder(@NonNull SchemaVisibilityConfig schemaVisibilityConfig) {
            Objects.requireNonNull(schemaVisibilityConfig);
            this.mAllowedPackages = new ArrayList<PackageIdentifierParcel>(schemaVisibilityConfig.mAllowedPackages);
            this.mRequiredPermissions = new ArrayList<VisibilityPermissionConfig>(schemaVisibilityConfig.mRequiredPermissions);
            this.mPubliclyVisibleTargetPackage = schemaVisibilityConfig.mPubliclyVisibleTargetPackage;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addAllowedPackage(@NonNull PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(packageIdentifier);
            this.resetIfBuilt();
            this.mAllowedPackages.add(packageIdentifier.getPackageIdentifierParcel());
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder clearAllowedPackages() {
            this.resetIfBuilt();
            this.mAllowedPackages.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addRequiredPermissions(@NonNull Set<Integer> visibleToPermissions) {
            Objects.requireNonNull(visibleToPermissions);
            this.resetIfBuilt();
            this.mRequiredPermissions.add(new VisibilityPermissionConfig(visibleToPermissions));
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder clearRequiredPermissions() {
            this.resetIfBuilt();
            this.mRequiredPermissions.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setPubliclyVisibleTargetPackage(@Nullable PackageIdentifier packageIdentifier) {
            this.resetIfBuilt();
            this.mPubliclyVisibleTargetPackage = packageIdentifier == null ? null : packageIdentifier.getPackageIdentifierParcel();
            return this;
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mAllowedPackages = new ArrayList<PackageIdentifierParcel>(this.mAllowedPackages);
                this.mRequiredPermissions = new ArrayList<VisibilityPermissionConfig>(this.mRequiredPermissions);
                this.mBuilt = false;
            }
        }

        @NonNull
        public SchemaVisibilityConfig build() {
            this.mBuilt = true;
            return new SchemaVisibilityConfig(this.mAllowedPackages, this.mRequiredPermissions, this.mPubliclyVisibleTargetPackage);
        }
    }
}

