/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.observer;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SchemaChangeInfo {
    private final String mPackageName;
    private final String mDatabaseName;
    private final Set<String> mChangedSchemaNames;

    public SchemaChangeInfo(@NonNull String packageName, @NonNull String databaseName, @NonNull Set<String> changedSchemaNames) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabaseName = Objects.requireNonNull(databaseName);
        this.mChangedSchemaNames = Collections.unmodifiableSet(Objects.requireNonNull(changedSchemaNames));
    }

    public @NonNull String getPackageName() {
        return this.mPackageName;
    }

    public @NonNull String getDatabaseName() {
        return this.mDatabaseName;
    }

    public @NonNull Set<String> getChangedSchemaNames() {
        return this.mChangedSchemaNames;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaChangeInfo)) {
            return false;
        }
        SchemaChangeInfo that = (SchemaChangeInfo)o;
        return this.mPackageName.equals(that.mPackageName) && this.mDatabaseName.equals(that.mDatabaseName) && this.mChangedSchemaNames.equals(that.mChangedSchemaNames);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, this.mDatabaseName, this.mChangedSchemaNames);
    }

    public @NonNull String toString() {
        return "SchemaChangeInfo{packageName='" + this.mPackageName + '\'' + ", databaseName='" + this.mDatabaseName + '\'' + ", changedSchemaNames='" + this.mChangedSchemaNames + '\'' + '}';
    }
}

