/*
 * Decompiled with CFR 0.152.
 */
package android.app.blob;

import android.app.blob.IBlobCommitCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;

public interface IBlobStoreSession
extends IInterface {
    public static final String DESCRIPTOR = "android.app.blob.IBlobStoreSession";

    public ParcelFileDescriptor openWrite(long var1, long var3) throws RemoteException;

    public ParcelFileDescriptor openRead() throws RemoteException;

    public void allowPackageAccess(String var1, byte[] var2) throws RemoteException;

    public void allowSameSignatureAccess() throws RemoteException;

    public void allowPublicAccess() throws RemoteException;

    public boolean isPackageAccessAllowed(String var1, byte[] var2) throws RemoteException;

    public boolean isSameSignatureAccessAllowed() throws RemoteException;

    public boolean isPublicAccessAllowed() throws RemoteException;

    public long getSize() throws RemoteException;

    public void close() throws RemoteException;

    public void abandon() throws RemoteException;

    public void commit(IBlobCommitCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBlobStoreSession {
        static final int TRANSACTION_openWrite = 1;
        static final int TRANSACTION_openRead = 2;
        static final int TRANSACTION_allowPackageAccess = 3;
        static final int TRANSACTION_allowSameSignatureAccess = 4;
        static final int TRANSACTION_allowPublicAccess = 5;
        static final int TRANSACTION_isPackageAccessAllowed = 6;
        static final int TRANSACTION_isSameSignatureAccessAllowed = 7;
        static final int TRANSACTION_isPublicAccessAllowed = 8;
        static final int TRANSACTION_getSize = 9;
        static final int TRANSACTION_close = 10;
        static final int TRANSACTION_abandon = 11;
        static final int TRANSACTION_commit = 12;

        public Stub() {
            this.attachInterface(this, IBlobStoreSession.DESCRIPTOR);
        }

        public static IBlobStoreSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBlobStoreSession.DESCRIPTOR);
            if (iin != null && iin instanceof IBlobStoreSession) {
                return (IBlobStoreSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openWrite";
                }
                case 2: {
                    return "openRead";
                }
                case 3: {
                    return "allowPackageAccess";
                }
                case 4: {
                    return "allowSameSignatureAccess";
                }
                case 5: {
                    return "allowPublicAccess";
                }
                case 6: {
                    return "isPackageAccessAllowed";
                }
                case 7: {
                    return "isSameSignatureAccessAllowed";
                }
                case 8: {
                    return "isPublicAccessAllowed";
                }
                case 9: {
                    return "getSize";
                }
                case 10: {
                    return "close";
                }
                case 11: {
                    return "abandon";
                }
                case 12: {
                    return "commit";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBlobStoreSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.openWrite(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    ParcelFileDescriptor _result = this.openRead();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.allowPackageAccess(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    this.allowSameSignatureAccess();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    this.allowPublicAccess();
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    boolean _result = this.isPackageAccessAllowed(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    boolean _result = this.isSameSignatureAccessAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    boolean _result = this.isPublicAccessAllowed();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 9: {
                    long _result = this.getSize();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 10: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.abandon();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IBlobCommitCallback _arg0 = IBlobCommitCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.commit(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IBlobStoreSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBlobStoreSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openWrite(long offsetBytes, long lengthBytes) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    _data.writeLong(offsetBytes);
                    _data.writeLong(lengthBytes);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor openRead() throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowPackageAccess(String packageName, byte[] certificate) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeByteArray(certificate);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowSameSignatureAccess() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowPublicAccess() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPackageAccessAllowed(String packageName, byte[] certificate) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeByteArray(certificate);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSameSignatureAccessAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isPublicAccessAllowed() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSize() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abandon() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void commit(IBlobCommitCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBlobStoreSession.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBlobStoreSession {
        @Override
        public ParcelFileDescriptor openWrite(long offsetBytes, long lengthBytes) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor openRead() throws RemoteException {
            return null;
        }

        @Override
        public void allowPackageAccess(String packageName, byte[] certificate) throws RemoteException {
        }

        @Override
        public void allowSameSignatureAccess() throws RemoteException {
        }

        @Override
        public void allowPublicAccess() throws RemoteException {
        }

        @Override
        public boolean isPackageAccessAllowed(String packageName, byte[] certificate) throws RemoteException {
            return false;
        }

        @Override
        public boolean isSameSignatureAccessAllowed() throws RemoteException {
            return false;
        }

        @Override
        public boolean isPublicAccessAllowed() throws RemoteException {
            return false;
        }

        @Override
        public long getSize() throws RemoteException {
            return 0L;
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void abandon() throws RemoteException {
        }

        @Override
        public void commit(IBlobCommitCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

