/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.compat.ChangeIdStateCache;
import android.app.compat.ChangeIdStateQuery;
import android.app.compat.PackageOverride;
import android.compat.Compatibility;
import android.os.RemoteException;
import android.os.UserHandle;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArrayMap;
import com.android.internal.compat.CompatibilityOverrideConfig;
import com.android.internal.compat.CompatibilityOverridesByPackageConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveByPackageConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveConfig;
import java.util.Map;
import java.util.Set;

@SystemApi
@RavenwoodKeepWholeClass
public class CompatChanges {
    private static final ChangeIdStateCache QUERY_CACHE = new ChangeIdStateCache();

    private CompatChanges() {
    }

    public static boolean isChangeEnabled(long changeId) {
        return Compatibility.isChangeEnabled(changeId);
    }

    @RequiresPermission(allOf={"android.permission.READ_COMPAT_CHANGE_CONFIG", "android.permission.LOG_COMPAT_CHANGE"})
    public static boolean isChangeEnabled(long changeId, @NonNull String packageName, @NonNull UserHandle user) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byPackageName(changeId, packageName, user.getIdentifier()));
    }

    @RequiresPermission(allOf={"android.permission.READ_COMPAT_CHANGE_CONFIG", "android.permission.LOG_COMPAT_CHANGE"})
    public static boolean isChangeEnabled(long changeId, int uid) {
        return (Boolean)QUERY_CACHE.query(ChangeIdStateQuery.byUid(changeId, uid));
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void putAllPackageOverrides(@NonNull Map<String, Map<Long, PackageOverride>> packageNameToOverrides) {
        ArrayMap<String, CompatibilityOverrideConfig> packageNameToConfig = new ArrayMap<String, CompatibilityOverrideConfig>();
        for (String packageName : packageNameToOverrides.keySet()) {
            packageNameToConfig.put(packageName, new CompatibilityOverrideConfig(packageNameToOverrides.get(packageName)));
        }
        CompatibilityOverridesByPackageConfig config = new CompatibilityOverridesByPackageConfig(packageNameToConfig);
        try {
            QUERY_CACHE.getPlatformCompatService().putAllOverridesOnReleaseBuilds(config);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void putPackageOverrides(@NonNull String packageName, @NonNull Map<Long, PackageOverride> overrides) {
        CompatibilityOverrideConfig config = new CompatibilityOverrideConfig(overrides);
        try {
            QUERY_CACHE.getPlatformCompatService().putOverridesOnReleaseBuilds(config, packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void removeAllPackageOverrides(@NonNull Map<String, Set<Long>> packageNameToOverridesToRemove) {
        ArrayMap<String, CompatibilityOverridesToRemoveConfig> packageNameToConfig = new ArrayMap<String, CompatibilityOverridesToRemoveConfig>();
        for (String packageName : packageNameToOverridesToRemove.keySet()) {
            packageNameToConfig.put(packageName, new CompatibilityOverridesToRemoveConfig(packageNameToOverridesToRemove.get(packageName)));
        }
        CompatibilityOverridesToRemoveByPackageConfig config = new CompatibilityOverridesToRemoveByPackageConfig(packageNameToConfig);
        try {
            QUERY_CACHE.getPlatformCompatService().removeAllOverridesOnReleaseBuilds(config);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public static void removePackageOverrides(@NonNull String packageName, @NonNull Set<Long> overridesToRemove) {
        CompatibilityOverridesToRemoveConfig config = new CompatibilityOverridesToRemoveConfig(overridesToRemove);
        try {
            QUERY_CACHE.getPlatformCompatService().removeOverridesOnReleaseBuilds(config, packageName);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }
}

