/*
 * Decompiled with CFR 0.152.
 */
package android.app.contentsuggestions;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class SelectionsRequest
implements Parcelable {
    private final int mTaskId;
    @Nullable
    private final Point mInterestPoint;
    @Nullable
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<SelectionsRequest> CREATOR = new Parcelable.Creator<SelectionsRequest>(){

        @Override
        public SelectionsRequest createFromParcel(Parcel source) {
            return new SelectionsRequest(source.readInt(), source.readTypedObject(Point.CREATOR), source.readBundle());
        }

        public SelectionsRequest[] newArray(int size) {
            return new SelectionsRequest[size];
        }
    };

    private SelectionsRequest(int taskId, @Nullable Point interestPoint, @Nullable Bundle extras) {
        this.mTaskId = taskId;
        this.mInterestPoint = interestPoint;
        this.mExtras = extras;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    @Nullable
    public Point getInterestPoint() {
        return this.mInterestPoint;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras == null ? new Bundle() : this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTaskId);
        dest.writeTypedObject(this.mInterestPoint, flags);
        dest.writeBundle(this.mExtras);
    }

    @SystemApi
    public static class Builder {
        private final int mTaskId;
        private Point mInterestPoint;
        private Bundle mExtras;

        public Builder(int taskId) {
            this.mTaskId = taskId;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public Builder setInterestPoint(@NonNull Point interestPoint) {
            this.mInterestPoint = interestPoint;
            return this;
        }

        @NonNull
        public SelectionsRequest build() {
            return new SelectionsRequest(this.mTaskId, this.mInterestPoint, this.mExtras);
        }
    }
}

