/*
 * Decompiled with CFR 0.152.
 */
package android.app.contextualsearch;

import android.app.contextualsearch.ContextualSearchState;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelableException;
import android.os.RemoteException;

public interface IContextualSearchCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.contextualsearch.IContextualSearchCallback";

    public void onResult(ContextualSearchState var1) throws RemoteException;

    public void onError(ParcelableException var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextualSearchCallback {
        static final int TRANSACTION_onResult = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IContextualSearchCallback.DESCRIPTOR);
        }

        public static IContextualSearchCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContextualSearchCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IContextualSearchCallback) {
                return (IContextualSearchCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onResult";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContextualSearchCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ContextualSearchState _arg0 = data.readTypedObject(ContextualSearchState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onResult(_arg0);
                    break;
                }
                case 2: {
                    ParcelableException _arg0 = data.readTypedObject(ParcelableException.CREATOR);
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IContextualSearchCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContextualSearchCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(ContextualSearchState state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextualSearchCallback.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(ParcelableException error) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextualSearchCallback.DESCRIPTOR);
                    _data.writeTypedObject(error, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextualSearchCallback {
        @Override
        public void onResult(ContextualSearchState state) throws RemoteException {
        }

        @Override
        public void onError(ParcelableException error) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

