/*
 * Decompiled with CFR 0.152.
 */
package android.app.contextualsearch;

import android.app.contextualsearch.IContextualSearchCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IContextualSearchManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.contextualsearch.IContextualSearchManager";

    public void startContextualSearchForForegroundApp() throws RemoteException;

    public void startContextualSearch(int var1) throws RemoteException;

    public void getContextualSearchState(IBinder var1, IContextualSearchCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContextualSearchManager {
        static final int TRANSACTION_startContextualSearchForForegroundApp = 1;
        static final int TRANSACTION_startContextualSearch = 2;
        static final int TRANSACTION_getContextualSearchState = 3;

        public Stub() {
            this.attachInterface(this, IContextualSearchManager.DESCRIPTOR);
        }

        public static IContextualSearchManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContextualSearchManager.DESCRIPTOR);
            if (iin != null && iin instanceof IContextualSearchManager) {
                return (IContextualSearchManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startContextualSearchForForegroundApp";
                }
                case 2: {
                    return "startContextualSearch";
                }
                case 3: {
                    return "getContextualSearchState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContextualSearchManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    this.startContextualSearchForForegroundApp();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startContextualSearch(_arg0);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    IContextualSearchCallback _arg1 = IContextualSearchCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getContextualSearchState(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IContextualSearchManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContextualSearchManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startContextualSearchForForegroundApp() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IContextualSearchManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startContextualSearch(int entrypoint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextualSearchManager.DESCRIPTOR);
                    _data.writeInt(entrypoint);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getContextualSearchState(IBinder token, IContextualSearchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContextualSearchManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContextualSearchManager {
        @Override
        public void startContextualSearchForForegroundApp() throws RemoteException {
        }

        @Override
        public void startContextualSearch(int entrypoint) throws RemoteException {
        }

        @Override
        public void getContextualSearchState(IBinder token, IContextualSearchCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

