/*
 * Decompiled with CFR 0.152.
 */
package android.app.jank;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.util.Pools;
import android.view.Choreographer;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
public class StateTracker {
    private final Object mLock = new Object();
    private Choreographer mChoreographer;
    private static final int MAX_POOL_SIZE = 500;
    protected static final int MAX_CONCURRENT_STATE_COUNT = 25;
    protected static final int MAX_PREVIOUSLY_ACTIVE_STATE_COUNT = 1000;
    private final Pools.SimplePool<StateData> mStateDataObjectPool = new Pools.SimplePool(500);
    private ArrayList<StateData> mPreviousStates = new ArrayList();
    private ConcurrentHashMap<String, StateData> mActiveStates = new ConcurrentHashMap();

    public StateTracker(@NonNull Choreographer choreographer) {
        this.mChoreographer = choreographer;
    }

    public void updateState(@NonNull String widgetCategory, @NonNull String widgetId, @NonNull String currentState, @NonNull String nextState) {
        this.removeState(widgetCategory, widgetId, currentState);
        this.putState(widgetCategory, widgetId, nextState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeState(@NonNull String widgetCategory, @NonNull String widgetId, @NonNull String widgetState) {
        String stateKey = this.getStateKey(widgetCategory, widgetId, widgetState);
        StateData stateData = this.mActiveStates.remove(stateKey);
        if (stateData == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            stateData.mVsyncIdEnd = this.mChoreographer.getVsyncId();
            if (this.mPreviousStates.size() < 1000) {
                this.mPreviousStates.add(stateData);
            }
        }
    }

    public void putState(@NonNull String widgetCategory, @NonNull String widgetId, @NonNull String widgetState) {
        if (this.mActiveStates.size() >= 25) {
            return;
        }
        String stateKey = this.getStateKey(widgetCategory, widgetId, widgetState);
        if (this.mActiveStates.containsKey(stateKey)) {
            return;
        }
        StateData stateData = this.mStateDataObjectPool.acquire();
        if (stateData == null) {
            stateData = new StateData();
        }
        stateData.mVsyncIdStart = this.mChoreographer.getVsyncId();
        stateData.mStateDataKey = stateKey;
        stateData.mWidgetState = widgetState;
        stateData.mWidgetCategory = widgetCategory;
        stateData.mWidgetId = widgetId;
        stateData.mVsyncIdEnd = Long.MAX_VALUE;
        this.mActiveStates.put(stateKey, stateData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveAllStates(ArrayList<StateData> allStates) {
        Object object = this.mLock;
        synchronized (object) {
            allStates.addAll(this.mPreviousStates);
            allStates.addAll(this.mActiveStates.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateProcessingComplete() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mPreviousStates.size() - 1; i >= 0; --i) {
                StateData stateData = this.mPreviousStates.get(i);
                if (!stateData.mProcessed) continue;
                this.mPreviousStates.remove(stateData);
                this.mStateDataObjectPool.release(stateData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addPendingStateData(List<StateData> stateData) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPreviousStates.addAll(stateData);
        }
    }

    public String getStateKey(String widgetCategory, String widgetId, String widgetState) {
        return widgetCategory + widgetId + widgetState;
    }

    public static class StateData {
        public String mStateDataKey;
        public String mWidgetCategory;
        public String mWidgetState;
        public String mWidgetId;
        public long mVsyncIdStart;
        public long mVsyncIdEnd;
        public boolean mProcessed;
    }
}

