/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.app.role.IOnRoleHoldersChangedListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IRoleManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.role.IRoleManager";

    public boolean isRoleAvailableAsUser(String var1, int var2) throws RemoteException;

    public boolean isRoleHeldAsUser(String var1, String var2, int var3) throws RemoteException;

    public List<String> getRoleHoldersAsUser(String var1, int var2) throws RemoteException;

    public void addRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void removeRoleHolderAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public void clearRoleHoldersAsUser(String var1, int var2, int var3, RemoteCallback var4) throws RemoteException;

    public String getDefaultApplicationAsUser(String var1, int var2) throws RemoteException;

    public void setDefaultApplicationAsUser(String var1, String var2, int var3, int var4, RemoteCallback var5) throws RemoteException;

    public int getActiveUserForRoleAsUser(String var1, int var2) throws RemoteException;

    public void setActiveUserForRoleAsUser(String var1, int var2, int var3, int var4) throws RemoteException;

    public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener var1, int var2) throws RemoteException;

    public boolean isBypassingRoleQualification() throws RemoteException;

    public void setBypassingRoleQualification(boolean var1) throws RemoteException;

    public boolean isRoleFallbackEnabledAsUser(String var1, int var2) throws RemoteException;

    public void setRoleFallbackEnabledAsUser(String var1, boolean var2, int var3) throws RemoteException;

    public void setRoleNamesFromControllerAsUser(List<String> var1, int var2) throws RemoteException;

    public boolean addRoleHolderFromControllerAsUser(String var1, String var2, int var3) throws RemoteException;

    public boolean removeRoleHolderFromControllerAsUser(String var1, String var2, int var3) throws RemoteException;

    public List<String> getHeldRolesFromControllerAsUser(String var1, int var2) throws RemoteException;

    public String getBrowserRoleHolder(int var1) throws RemoteException;

    public boolean setBrowserRoleHolder(String var1, int var2) throws RemoteException;

    public String getSmsRoleHolder(int var1) throws RemoteException;

    public String getEmergencyRoleHolder(int var1) throws RemoteException;

    public boolean isRoleVisibleAsUser(String var1, int var2) throws RemoteException;

    public boolean isApplicationVisibleForRoleAsUser(String var1, String var2, int var3) throws RemoteException;

    public List<String> getDefaultHoldersForTestAsUser(String var1, int var2) throws RemoteException;

    public void setDefaultHoldersForTestAsUser(String var1, List<String> var2, int var3) throws RemoteException;

    public boolean isRoleVisibleForTestAsUser(String var1, int var2) throws RemoteException;

    public void setRoleVisibleForTestAsUser(String var1, boolean var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRoleManager {
        static final int TRANSACTION_isRoleAvailableAsUser = 1;
        static final int TRANSACTION_isRoleHeldAsUser = 2;
        static final int TRANSACTION_getRoleHoldersAsUser = 3;
        static final int TRANSACTION_addRoleHolderAsUser = 4;
        static final int TRANSACTION_removeRoleHolderAsUser = 5;
        static final int TRANSACTION_clearRoleHoldersAsUser = 6;
        static final int TRANSACTION_getDefaultApplicationAsUser = 7;
        static final int TRANSACTION_setDefaultApplicationAsUser = 8;
        static final int TRANSACTION_getActiveUserForRoleAsUser = 9;
        static final int TRANSACTION_setActiveUserForRoleAsUser = 10;
        static final int TRANSACTION_addOnRoleHoldersChangedListenerAsUser = 11;
        static final int TRANSACTION_removeOnRoleHoldersChangedListenerAsUser = 12;
        static final int TRANSACTION_isBypassingRoleQualification = 13;
        static final int TRANSACTION_setBypassingRoleQualification = 14;
        static final int TRANSACTION_isRoleFallbackEnabledAsUser = 15;
        static final int TRANSACTION_setRoleFallbackEnabledAsUser = 16;
        static final int TRANSACTION_setRoleNamesFromControllerAsUser = 17;
        static final int TRANSACTION_addRoleHolderFromControllerAsUser = 18;
        static final int TRANSACTION_removeRoleHolderFromControllerAsUser = 19;
        static final int TRANSACTION_getHeldRolesFromControllerAsUser = 20;
        static final int TRANSACTION_getBrowserRoleHolder = 21;
        static final int TRANSACTION_setBrowserRoleHolder = 22;
        static final int TRANSACTION_getSmsRoleHolder = 23;
        static final int TRANSACTION_getEmergencyRoleHolder = 24;
        static final int TRANSACTION_isRoleVisibleAsUser = 25;
        static final int TRANSACTION_isApplicationVisibleForRoleAsUser = 26;
        static final int TRANSACTION_getDefaultHoldersForTestAsUser = 27;
        static final int TRANSACTION_setDefaultHoldersForTestAsUser = 28;
        static final int TRANSACTION_isRoleVisibleForTestAsUser = 29;
        static final int TRANSACTION_setRoleVisibleForTestAsUser = 30;

        public Stub() {
            this.attachInterface(this, IRoleManager.DESCRIPTOR);
        }

        public static IRoleManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRoleManager.DESCRIPTOR);
            if (iin != null && iin instanceof IRoleManager) {
                return (IRoleManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isRoleAvailableAsUser";
                }
                case 2: {
                    return "isRoleHeldAsUser";
                }
                case 3: {
                    return "getRoleHoldersAsUser";
                }
                case 4: {
                    return "addRoleHolderAsUser";
                }
                case 5: {
                    return "removeRoleHolderAsUser";
                }
                case 6: {
                    return "clearRoleHoldersAsUser";
                }
                case 7: {
                    return "getDefaultApplicationAsUser";
                }
                case 8: {
                    return "setDefaultApplicationAsUser";
                }
                case 9: {
                    return "getActiveUserForRoleAsUser";
                }
                case 10: {
                    return "setActiveUserForRoleAsUser";
                }
                case 11: {
                    return "addOnRoleHoldersChangedListenerAsUser";
                }
                case 12: {
                    return "removeOnRoleHoldersChangedListenerAsUser";
                }
                case 13: {
                    return "isBypassingRoleQualification";
                }
                case 14: {
                    return "setBypassingRoleQualification";
                }
                case 15: {
                    return "isRoleFallbackEnabledAsUser";
                }
                case 16: {
                    return "setRoleFallbackEnabledAsUser";
                }
                case 17: {
                    return "setRoleNamesFromControllerAsUser";
                }
                case 18: {
                    return "addRoleHolderFromControllerAsUser";
                }
                case 19: {
                    return "removeRoleHolderFromControllerAsUser";
                }
                case 20: {
                    return "getHeldRolesFromControllerAsUser";
                }
                case 21: {
                    return "getBrowserRoleHolder";
                }
                case 22: {
                    return "setBrowserRoleHolder";
                }
                case 23: {
                    return "getSmsRoleHolder";
                }
                case 24: {
                    return "getEmergencyRoleHolder";
                }
                case 25: {
                    return "isRoleVisibleAsUser";
                }
                case 26: {
                    return "isApplicationVisibleForRoleAsUser";
                }
                case 27: {
                    return "getDefaultHoldersForTestAsUser";
                }
                case 28: {
                    return "setDefaultHoldersForTestAsUser";
                }
                case 29: {
                    return "isRoleVisibleForTestAsUser";
                }
                case 30: {
                    return "setRoleVisibleForTestAsUser";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRoleManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isRoleAvailableAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.isRoleHeldAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List<String> _result = this.getRoleHoldersAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.addRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.removeRoleHolderAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.clearRoleHoldersAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _result = this.getDefaultApplicationAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    RemoteCallback _arg4 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.setDefaultApplicationAsUser(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _result = this.getActiveUserForRoleAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 10: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.setActiveUserForRoleAsUser(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.addOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    IOnRoleHoldersChangedListener _arg0 = IOnRoleHoldersChangedListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.removeOnRoleHoldersChangedListenerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    boolean _result = this.isBypassingRoleQualification();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    boolean _arg0 = data.readBoolean();
                    this.setBypassingRoleQualification(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isRoleFallbackEnabledAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    this.setRoleFallbackEnabledAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    int _arg1 = data.readInt();
                    this.setRoleNamesFromControllerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.addRoleHolderFromControllerAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.removeRoleHolderFromControllerAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List<String> _result = this.getHeldRolesFromControllerAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    String _result = this.getBrowserRoleHolder(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.setBrowserRoleHolder(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    String _result = this.getSmsRoleHolder(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    String _result = this.getEmergencyRoleHolder(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isRoleVisibleAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 26: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _result = this.isApplicationVisibleForRoleAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 27: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    List<String> _result = this.getDefaultHoldersForTestAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 28: {
                    String _arg0 = data.readString();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int _arg2 = data.readInt();
                    this.setDefaultHoldersForTestAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isRoleVisibleForTestAsUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 30: {
                    String _arg0 = data.readString();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    this.setRoleVisibleForTestAsUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 29;
        }

        private static class Proxy
        implements IRoleManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRoleManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleAvailableAsUser(String roleName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleHeldAsUser(String roleName, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getDefaultApplicationAsUser(String roleName, int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultApplicationAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    _data.writeTypedObject(callback, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActiveUserForRoleAsUser(String roleName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveUserForRoleAsUser(String roleName, int activeUserId, int flags, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(activeUserId);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBypassingRoleQualification() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBypassingRoleQualification(boolean bypassRoleQualification) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeBoolean(bypassRoleQualification);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleFallbackEnabledAsUser(String roleName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRoleFallbackEnabledAsUser(String roleName, boolean fallbackEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeBoolean(fallbackEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRoleNamesFromControllerAsUser(List<String> roleNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeStringList(roleNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addRoleHolderFromControllerAsUser(String roleName, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeRoleHolderFromControllerAsUser(String roleName, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getHeldRolesFromControllerAsUser(String packageName, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getBrowserRoleHolder(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setBrowserRoleHolder(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getSmsRoleHolder(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getEmergencyRoleHolder(int userId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleVisibleAsUser(String roleName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isApplicationVisibleForRoleAsUser(String roleName, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getDefaultHoldersForTestAsUser(String roleName, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultHoldersForTestAsUser(String roleName, List<String> packageNames, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeStringList(packageNames);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRoleVisibleForTestAsUser(String roleName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRoleVisibleForTestAsUser(String roleName, boolean visible, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleManager.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeBoolean(visible);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRoleManager {
        @Override
        public boolean isRoleAvailableAsUser(String roleName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRoleHeldAsUser(String roleName, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getRoleHoldersAsUser(String roleName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void addRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void removeRoleHolderAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void clearRoleHoldersAsUser(String roleName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public String getDefaultApplicationAsUser(String roleName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setDefaultApplicationAsUser(String roleName, String packageName, int flags, int userId, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public int getActiveUserForRoleAsUser(String roleName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setActiveUserForRoleAsUser(String roleName, int activeUserId, int flags, int userId) throws RemoteException {
        }

        @Override
        public void addOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public void removeOnRoleHoldersChangedListenerAsUser(IOnRoleHoldersChangedListener listener, int userId) throws RemoteException {
        }

        @Override
        public boolean isBypassingRoleQualification() throws RemoteException {
            return false;
        }

        @Override
        public void setBypassingRoleQualification(boolean bypassRoleQualification) throws RemoteException {
        }

        @Override
        public boolean isRoleFallbackEnabledAsUser(String roleName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setRoleFallbackEnabledAsUser(String roleName, boolean fallbackEnabled, int userId) throws RemoteException {
        }

        @Override
        public void setRoleNamesFromControllerAsUser(List<String> roleNames, int userId) throws RemoteException {
        }

        @Override
        public boolean addRoleHolderFromControllerAsUser(String roleName, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeRoleHolderFromControllerAsUser(String roleName, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getHeldRolesFromControllerAsUser(String packageName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getBrowserRoleHolder(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setBrowserRoleHolder(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public String getSmsRoleHolder(int userId) throws RemoteException {
            return null;
        }

        @Override
        public String getEmergencyRoleHolder(int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isRoleVisibleAsUser(String roleName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isApplicationVisibleForRoleAsUser(String roleName, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getDefaultHoldersForTestAsUser(String roleName, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void setDefaultHoldersForTestAsUser(String roleName, List<String> packageNames, int userId) throws RemoteException {
        }

        @Override
        public boolean isRoleVisibleForTestAsUser(String roleName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setRoleVisibleForTestAsUser(String roleName, boolean visible, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

