/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox.sdkprovider;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.sdksandbox.SandboxedSdkContext;
import android.app.sdksandbox.SdkSandboxLocalSingleton;
import android.app.sdksandbox.sandboxactivity.ActivityContextInfo;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.Iterator;
import java.util.Map;

public class SdkSandboxActivityRegistry {
    private static final String TAG = "SdkSandboxActivityRegistry";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static SdkSandboxActivityRegistry sInstance;
    private final Object mMapsLock = new Object();
    private Injector mInjector;
    @GuardedBy(value={"mMapsLock"})
    private final Map<SdkSandboxActivityHandler, HandlerInfo> mHandlerToHandlerInfoMap = new ArrayMap<SdkSandboxActivityHandler, HandlerInfo>();
    @GuardedBy(value={"mMapsLock"})
    private final Map<IBinder, HandlerInfo> mTokenToHandlerInfoMap = new ArrayMap<IBinder, HandlerInfo>();

    private SdkSandboxActivityRegistry(Injector injector) {
        this.setInjector(injector);
    }

    public static SdkSandboxActivityRegistry getInstance() {
        return SdkSandboxActivityRegistry.getInstance(new Injector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static SdkSandboxActivityRegistry getInstance(@NonNull Injector injector) {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new SdkSandboxActivityRegistry(injector);
            } else {
                sInstance.setInjector(injector);
            }
            return sInstance;
        }
    }

    private void setInjector(@NonNull Injector injector) {
        this.mInjector = injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    @NonNull
    public IBinder register(@NonNull SandboxedSdkContext sdkContext, @NonNull SdkSandboxActivityHandler handler) {
        Object object = this.mMapsLock;
        synchronized (object) {
            long timeEventStarted = this.mInjector.elapsedRealtime();
            if (this.mHandlerToHandlerInfoMap.containsKey(handler)) {
                HandlerInfo handlerInfo = this.mHandlerToHandlerInfoMap.get(handler);
                return handlerInfo.getToken();
            }
            Binder token = new Binder();
            HandlerInfo handlerInfo = new HandlerInfo(sdkContext, handler, token);
            this.mHandlerToHandlerInfoMap.put(handlerInfo.getHandler(), handlerInfo);
            this.mTokenToHandlerInfoMap.put(handlerInfo.getToken(), handlerInfo);
            this.logSandboxActivityApiLatency(3, 1, timeEventStarted);
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public void unregister(@NonNull SdkSandboxActivityHandler handler) {
        Object object = this.mMapsLock;
        synchronized (object) {
            long timeEventStarted = this.mInjector.elapsedRealtime();
            HandlerInfo handlerInfo = this.mHandlerToHandlerInfoMap.get(handler);
            if (handlerInfo == null) {
                return;
            }
            this.mHandlerToHandlerInfoMap.remove(handlerInfo.getHandler());
            this.mTokenToHandlerInfoMap.remove(handlerInfo.getToken());
            this.logSandboxActivityApiLatency(4, 1, timeEventStarted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public void notifyOnActivityCreation(@NonNull Intent intent, @NonNull Activity activity) {
        long sandboxActivityInitiationTime = this.extractActivityInitiationTime(intent);
        if (sandboxActivityInitiationTime != 0L) {
            intent.removeExtra("android.app.sdksandbox.extra.EXTRA_SANDBOXED_ACTIVITY_INITIATION_TIME");
        }
        Object object = this.mMapsLock;
        synchronized (object) {
            long timeEventStarted = this.mInjector.elapsedRealtime();
            IBinder handlerToken = this.extractHandlerToken(intent);
            if (handlerToken == null) {
                this.logSandboxActivityApiLatency(9, 2, timeEventStarted);
                throw new IllegalArgumentException("Extra params of the intent are missing the IBinder value for the key (android.app.sdksandbox.extra.SANDBOXED_ACTIVITY_HANDLER)");
            }
            HandlerInfo handlerInfo = this.mTokenToHandlerInfoMap.get(handlerToken);
            if (handlerInfo == null) {
                this.logSandboxActivityApiLatency(9, 2, timeEventStarted);
                throw new IllegalArgumentException("There is no registered SdkSandboxActivityHandler to notify");
            }
            this.logSandboxActivityApiLatency(9, 1, timeEventStarted);
            handlerInfo.getHandler().onActivityCreated(activity);
        }
        if (sandboxActivityInitiationTime != 0L) {
            this.logSandboxActivityApiLatency(10, 1, sandboxActivityInitiationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RequiresApi(value=34)
    public ActivityContextInfo getContextInfo(@NonNull Intent intent) {
        Object object = this.mMapsLock;
        synchronized (object) {
            IBinder handlerToken = this.extractHandlerToken(intent);
            if (handlerToken == null) {
                return null;
            }
            HandlerInfo handlerInfo = this.mTokenToHandlerInfoMap.get(handlerToken);
            if (handlerInfo == null) {
                return null;
            }
            return handlerInfo.getContextInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RequiresApi(value=34)
    public SandboxedSdkContext getSdkContext(@NonNull Intent intent) {
        Object object = this.mMapsLock;
        synchronized (object) {
            IBinder handlerToken = this.extractHandlerToken(intent);
            if (handlerToken == null) {
                return null;
            }
            HandlerInfo handlerInfo = this.mTokenToHandlerInfoMap.get(handlerToken);
            if (handlerInfo == null) {
                return null;
            }
            return handlerInfo.getSdkContext();
        }
    }

    @Nullable
    private IBinder extractHandlerToken(Intent intent) {
        if (intent == null || intent.getExtras() == null) {
            return null;
        }
        return intent.getExtras().getBinder("android.app.sdksandbox.extra.SANDBOXED_ACTIVITY_HANDLER");
    }

    private long extractActivityInitiationTime(Intent intent) {
        if (intent == null || intent.getExtras() == null) {
            return 0L;
        }
        return intent.getExtras().getLong("android.app.sdksandbox.extra.EXTRA_SANDBOXED_ACTIVITY_INITIATION_TIME");
    }

    private void logSandboxActivityApiLatency(int method, int callResult, long timeEventStarted) {
        try {
            this.mInjector.getSdkSandboxLocalSingleton().getSdkToServiceCallback().logSandboxActivityApiLatencyFromSandbox(method, callResult, (int)(this.mInjector.elapsedRealtime() - timeEventStarted));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=34)
    public void unregisterAllActivityHandlersForSdk(@NonNull String sdkName) {
        Object object = this.mMapsLock;
        synchronized (object) {
            Iterator<Map.Entry<SdkSandboxActivityHandler, HandlerInfo>> iter = this.mHandlerToHandlerInfoMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<SdkSandboxActivityHandler, HandlerInfo> handlerEntry = iter.next();
                HandlerInfo handlerInfo = handlerEntry.getValue();
                if (!handlerInfo.getSdkContext().getSdkName().equals(sdkName)) continue;
                IBinder handlerToken = handlerInfo.getToken();
                iter.remove();
                this.mTokenToHandlerInfoMap.remove(handlerToken);
            }
        }
    }

    @VisibleForTesting
    public static class Injector {
        public SdkSandboxLocalSingleton getSdkSandboxLocalSingleton() {
            return SdkSandboxLocalSingleton.getExistingInstance();
        }

        public long elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }
    }

    private static class HandlerInfo {
        private final SandboxedSdkContext mSdkContext;
        private final SdkSandboxActivityHandler mHandler;
        private final IBinder mToken;
        private final ActivityContextInfo mContextInfo;

        HandlerInfo(SandboxedSdkContext sdkContext, SdkSandboxActivityHandler handler, IBinder token) {
            this.mSdkContext = sdkContext;
            this.mHandler = handler;
            this.mToken = token;
            this.mContextInfo = this.mSdkContext::getApplicationInfo;
        }

        @NonNull
        public SandboxedSdkContext getSdkContext() {
            return this.mSdkContext;
        }

        @NonNull
        public SdkSandboxActivityHandler getHandler() {
            return this.mHandler;
        }

        @NonNull
        public IBinder getToken() {
            return this.mToken;
        }

        @NonNull
        public ActivityContextInfo getContextInfo() {
            return this.mContextInfo;
        }
    }
}

