/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox.sdkprovider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.sdksandbox.AppOwnedSdkSandboxInterface;
import android.app.sdksandbox.ILoadSdkCallback;
import android.app.sdksandbox.LoadSdkException;
import android.app.sdksandbox.SandboxLatencyInfo;
import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SandboxedSdkContext;
import android.app.sdksandbox.SdkLevel;
import android.app.sdksandbox.SdkSandboxLocalSingleton;
import android.app.sdksandbox.SdkSandboxManager;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityHandler;
import android.app.sdksandbox.sdkprovider.SdkSandboxActivityRegistry;
import android.app.sdksandbox.sdkprovider.SdkSandboxClientImportanceListener;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

public class SdkSandboxController {
    public static final String SDK_SANDBOX_CONTROLLER_SERVICE = "sdk_sandbox_controller_service";
    public static final String CLIENT_SHARED_PREFERENCES_NAME = "com.android.sdksandbox.client_sharedpreferences";
    private static final String TAG = "SdkSandboxController";
    private SdkSandboxLocalSingleton mSdkSandboxLocalSingleton;
    private SdkSandboxActivityRegistry mSdkSandboxActivityRegistry;
    private Context mContext;

    public SdkSandboxController(@NonNull Context context) {
        this.initialize(context);
    }

    public SdkSandboxController initialize(@NonNull Context context) {
        this.mContext = context;
        this.mSdkSandboxLocalSingleton = SdkSandboxLocalSingleton.getExistingInstance();
        this.mSdkSandboxActivityRegistry = SdkSandboxActivityRegistry.getInstance();
        return this;
    }

    @NonNull
    public List<AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces() {
        this.enforceSandboxedSdkContextInitialization();
        try {
            return this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().getAppOwnedSdkSandboxInterfaces(((SandboxedSdkContext)this.mContext).getClientPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<SandboxedSdk> getSandboxedSdks() {
        this.enforceSandboxedSdkContextInitialization();
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(10);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(SystemClock.elapsedRealtime());
        try {
            return this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().getSandboxedSdks(((SandboxedSdkContext)this.mContext).getClientPackageName(), sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void loadSdk(@NonNull String sdkName, @NonNull Bundle params, @NonNull Executor executor, @NonNull OutcomeReceiver<SandboxedSdk, LoadSdkException> receiver) {
        this.enforceSandboxedSdkContextInitialization();
        LoadSdkReceiverProxy callbackProxy = new LoadSdkReceiverProxy(executor, receiver);
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(14);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(SystemClock.elapsedRealtime());
        try {
            this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().loadSdk(((SandboxedSdkContext)this.mContext).getClientPackageName(), sdkName, sandboxLatencyInfo, params, callbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public SharedPreferences getClientSharedPreferences() {
        this.enforceSandboxedSdkContextInitialization();
        return this.mContext.getApplicationContext().getSharedPreferences(CLIENT_SHARED_PREFERENCES_NAME, 0);
    }

    @RequiresApi(value=34)
    @NonNull
    public IBinder registerSdkSandboxActivityHandler(@NonNull SdkSandboxActivityHandler sdkSandboxActivityHandler) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        long timeEventStarted = SystemClock.elapsedRealtime();
        this.enforceSandboxedSdkContextInitialization();
        IBinder token = this.mSdkSandboxActivityRegistry.register((SandboxedSdkContext)this.mContext, sdkSandboxActivityHandler);
        this.logSandboxActivityApiLatency(1, 1, timeEventStarted);
        return token;
    }

    @RequiresApi(value=34)
    @NonNull
    public void unregisterSdkSandboxActivityHandler(@NonNull SdkSandboxActivityHandler sdkSandboxActivityHandler) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        long timeEventStarted = SystemClock.elapsedRealtime();
        this.enforceSandboxedSdkContextInitialization();
        this.mSdkSandboxActivityRegistry.unregister(sdkSandboxActivityHandler);
        this.logSandboxActivityApiLatency(2, 1, timeEventStarted);
    }

    @NonNull
    public String getClientPackageName() {
        this.enforceSandboxedSdkContextInitialization();
        return ((SandboxedSdkContext)this.mContext).getClientPackageName();
    }

    @FlaggedApi(value="android.app.sdksandbox.flags.sandbox_client_importance_listener")
    public void registerSdkSandboxClientImportanceListener(@NonNull Executor executor, @NonNull SdkSandboxClientImportanceListener listener) {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        this.enforceSandboxedSdkContextInitialization();
        SdkSandboxLocalSingleton.getExistingInstance().registerSdkSandboxClientImportanceListener(new SdkSandboxClientImportanceListenerProxy(executor, listener));
    }

    @FlaggedApi(value="android.app.sdksandbox.flags.sandbox_client_importance_listener")
    public void unregisterSdkSandboxClientImportanceListener(@NonNull SdkSandboxClientImportanceListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        this.enforceSandboxedSdkContextInitialization();
        SdkSandboxLocalSingleton.getExistingInstance().unregisterSdkSandboxClientImportanceListener(listener);
    }

    private void enforceSandboxedSdkContextInitialization() {
        if (!(this.mContext instanceof SandboxedSdkContext)) {
            throw new UnsupportedOperationException("Only available from the context obtained by calling android.app.sdksandbox.SandboxedSdkProvider#getContext()");
        }
    }

    private void logLatenciesFromSandbox(SandboxLatencyInfo sandboxLatencyInfo) {
        sandboxLatencyInfo.setTimeAppReceivedCallFromSystemServer(SystemClock.elapsedRealtime());
        try {
            this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().logLatenciesFromSandbox(sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Logging metrics for method " + sandboxLatencyInfo.getMethod() + " failed with exception " + e.getMessage());
        }
    }

    private void logSandboxActivityApiLatency(int method, int callResult, long timeEventStarted) {
        try {
            this.mSdkSandboxLocalSingleton.getSdkToServiceCallback().logSandboxActivityApiLatencyFromSandbox(method, callResult, (int)(SystemClock.elapsedRealtime() - timeEventStarted));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private class LoadSdkReceiverProxy
    extends ILoadSdkCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<SandboxedSdk, LoadSdkException> mCallback;

        LoadSdkReceiverProxy(Executor executor, OutcomeReceiver<SandboxedSdk, LoadSdkException> callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        @Override
        public void onLoadSdkSuccess(SandboxedSdk sandboxedSdk, SandboxLatencyInfo sandboxLatencyInfo) {
            SdkSandboxController.this.logLatenciesFromSandbox(sandboxLatencyInfo);
            this.mExecutor.execute(() -> this.mCallback.onResult(sandboxedSdk));
        }

        @Override
        public void onLoadSdkFailure(LoadSdkException exception, SandboxLatencyInfo sandboxLatencyInfo) {
            sandboxLatencyInfo.setResultCode(SdkSandboxManager.getResultCodeForLoadSdkException(exception));
            SdkSandboxController.this.logLatenciesFromSandbox(sandboxLatencyInfo);
            this.mExecutor.execute(() -> this.mCallback.onError(exception));
        }
    }

    public static class SdkSandboxClientImportanceListenerProxy {
        private final Executor mExecutor;
        public final SdkSandboxClientImportanceListener listener;

        SdkSandboxClientImportanceListenerProxy(Executor executor, SdkSandboxClientImportanceListener listener) {
            this.mExecutor = executor;
            this.listener = listener;
        }

        public void onForegroundImportanceChanged(boolean isForeground) {
            this.mExecutor.execute(() -> this.listener.onForegroundImportanceChanged(isForeground));
        }
    }
}

