/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;

public class DestroyActivityItem
extends ActivityLifecycleItem {
    private final boolean mFinished;
    @NonNull
    public static final Parcelable.Creator<DestroyActivityItem> CREATOR = new Parcelable.Creator<DestroyActivityItem>(){

        @Override
        public DestroyActivityItem createFromParcel(@NonNull Parcel in) {
            return new DestroyActivityItem(in);
        }

        public DestroyActivityItem[] newArray(int size) {
            return new DestroyActivityItem[size];
        }
    };

    public DestroyActivityItem(@NonNull IBinder activityToken, boolean finished) {
        super(activityToken);
        this.mFinished = finished;
    }

    @Override
    public void preExecute(@NonNull ClientTransactionHandler client) {
        client.getActivitiesToBeDestroyed().put(this.getActivityToken(), this);
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull ActivityThread.ActivityClientRecord r, @NonNull PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityDestroy");
        client.handleDestroyActivity(r, this.mFinished, false, "DestroyActivityItem");
        Trace.traceEnd(64L);
    }

    @Override
    public void postExecute(@NonNull ClientTransactionHandler client, @NonNull PendingTransactionActions pendingActions) {
        client.getActivitiesToBeDestroyed().remove(this.getActivityToken());
    }

    @Override
    public int getTargetState() {
        return 6;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeBoolean(this.mFinished);
    }

    private DestroyActivityItem(@NonNull Parcel in) {
        super(in);
        this.mFinished = in.readBoolean();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        DestroyActivityItem other = (DestroyActivityItem)o;
        return this.mFinished == other.mFinished;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.mFinished ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "DestroyActivityItem{" + super.toString() + ",finished=" + this.mFinished + "}";
    }
}

