/*
 * Decompiled with CFR 0.152.
 */
package android.app.slice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.slice.ISliceManager;
import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Deprecated
public class SliceManager {
    private static final String TAG = "SliceManager";
    public static final String ACTION_REQUEST_SLICE_PERMISSION = "com.android.intent.action.REQUEST_SLICE_PERMISSION";
    public static final String CATEGORY_SLICE = "android.app.slice.category.SLICE";
    public static final String SLICE_METADATA_KEY = "android.metadata.SLICE_URI";
    private final ISliceManager mService;
    private final Context mContext;
    private final IBinder mToken = new Binder();

    public SliceManager(Context context, Handler handler) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = ISliceManager.Stub.asInterface(ServiceManager.getServiceOrThrow("slice"));
    }

    public void pinSlice(@NonNull Uri uri, @NonNull Set<SliceSpec> specs) {
        try {
            this.mService.pinSlice(this.mContext.getPackageName(), uri, specs.toArray(new SliceSpec[specs.size()]), this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unpinSlice(@NonNull Uri uri) {
        try {
            this.mService.unpinSlice(this.mContext.getPackageName(), uri, this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasSliceAccess() {
        try {
            return this.mService.hasSliceAccess(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Set<SliceSpec> getPinnedSpecs(Uri uri) {
        try {
            return new ArraySet<SliceSpec>(Arrays.asList(this.mService.getPinnedSpecs(uri, this.mContext.getPackageName())));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<Uri> getPinnedSlices() {
        try {
            return Arrays.asList(this.mService.getPinnedSlices(this.mContext.getPackageName()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public Collection<Uri> getSliceDescendants(@NonNull Uri uri) {
        ContentResolver resolver = this.mContext.getContentResolver();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, TextUtils.formatSimple("Unknown URI: %s", uri));
                return Collections.emptyList();
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", uri);
            Bundle res = provider.call("get_descendants", null, extras);
            ArrayList<Uri> arrayList = res.getParcelableArrayList("slice_descendants", Uri.class);
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Unable to get slice descendants", e);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Slice bindSlice(@NonNull Uri uri, @NonNull Set<SliceSpec> supportedSpecs) {
        Objects.requireNonNull(uri, "uri");
        ContentResolver resolver = this.mContext.getContentResolver();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_uri", uri);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("bind_slice", null, extras);
            Bundle.setDefusable(res, true);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = res.getParcelable("slice", Slice.class);
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Uri mapIntentToUri(@NonNull Intent intent) {
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return staticUri;
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Uri uri2 = null;
                return uri2;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            Bundle res = provider.call("map_only", null, extras);
            if (res == null) {
                Uri uri3 = null;
                return uri3;
            }
            Uri uri4 = res.getParcelable("slice", Uri.class);
            return uri4;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private String getAuthority(Intent intent) {
        List<ResolveInfo> providers;
        Intent queryIntent = new Intent(intent);
        if (!queryIntent.hasCategory(CATEGORY_SLICE)) {
            queryIntent.addCategory(CATEGORY_SLICE);
        }
        return (providers = this.mContext.getPackageManager().queryIntentContentProviders(queryIntent, 0)) != null && !providers.isEmpty() ? providers.get((int)0).providerInfo.authority : null;
    }

    private Uri resolveStatic(@NonNull Intent intent, ContentResolver resolver) {
        Objects.requireNonNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return intentData;
        }
        ResolveInfo resolve = this.mContext.getPackageManager().resolveActivity(intent, 128);
        if (resolve != null && resolve.activityInfo != null && resolve.activityInfo.metaData != null && resolve.activityInfo.metaData.containsKey(SLICE_METADATA_KEY)) {
            return Uri.parse(resolve.activityInfo.metaData.getString(SLICE_METADATA_KEY));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Slice bindSlice(@NonNull Intent intent, @NonNull Set<SliceSpec> supportedSpecs) {
        Objects.requireNonNull(intent, "intent");
        Preconditions.checkArgument(intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null, "Slice intent must be explicit %s", intent);
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri staticUri = this.resolveStatic(intent, resolver);
        if (staticUri != null) {
            return this.bindSlice(staticUri, supportedSpecs);
        }
        String authority = this.getAuthority(intent);
        if (authority == null) {
            return null;
        }
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        try (ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);){
            if (provider == null) {
                Log.w(TAG, String.format("Unknown URI: %s", uri));
                Slice slice = null;
                return slice;
            }
            Bundle extras = new Bundle();
            extras.putParcelable("slice_intent", intent);
            extras.putParcelableArrayList("supported_specs", new ArrayList<SliceSpec>(supportedSpecs));
            Bundle res = provider.call("map_slice", null, extras);
            if (res == null) {
                Slice slice = null;
                return slice;
            }
            Slice slice = res.getParcelable("slice", Slice.class);
            return slice;
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int checkSlicePermission(@NonNull Uri uri, int pid, int uid) {
        try {
            return this.mService.checkSlicePermission(uri, this.mContext.getPackageName(), pid, uid, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantSlicePermission(@NonNull String toPackage, @NonNull Uri uri) {
        try {
            this.mService.grantSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void revokeSlicePermission(@NonNull String toPackage, @NonNull Uri uri) {
        try {
            this.mService.revokeSlicePermission(this.mContext.getPackageName(), toPackage, uri);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void enforceSlicePermission(Uri uri, int pid, int uid, String[] autoGrantPermissions) {
        try {
            if (UserHandle.isSameApp(uid, Process.myUid())) {
                return;
            }
            int result = this.mService.checkSlicePermission(uri, this.mContext.getPackageName(), pid, uid, autoGrantPermissions);
            if (result == -1) {
                throw new SecurityException("User " + uid + " does not have slice permission for " + uri + ".");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void grantPermissionFromUser(Uri uri, String pkg, boolean allSlices) {
        try {
            this.mService.grantPermissionFromUser(uri, pkg, this.mContext.getPackageName(), allSlices);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

