/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.smartspace.SmartspaceTarget;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class SmartspaceTargetEvent
implements Parcelable {
    public static final int EVENT_TARGET_INTERACTION = 1;
    public static final int EVENT_TARGET_SHOWN = 2;
    public static final int EVENT_TARGET_HIDDEN = 3;
    public static final int EVENT_TARGET_DISMISS = 4;
    public static final int EVENT_TARGET_BLOCK = 5;
    public static final int EVENT_UI_SURFACE_SHOWN = 6;
    public static final int EVENT_UI_SURFACE_HIDDEN = 7;
    @NonNull
    public static final Parcelable.Creator<SmartspaceTargetEvent> CREATOR = new Parcelable.Creator<SmartspaceTargetEvent>(){

        @Override
        public SmartspaceTargetEvent createFromParcel(Parcel parcel) {
            return new SmartspaceTargetEvent(parcel);
        }

        public SmartspaceTargetEvent[] newArray(int size) {
            return new SmartspaceTargetEvent[size];
        }
    };
    @Nullable
    private final SmartspaceTarget mSmartspaceTarget;
    @Nullable
    private final String mSmartspaceActionId;
    private final int mEventType;

    private SmartspaceTargetEvent(@Nullable SmartspaceTarget smartspaceTarget, @Nullable String smartspaceActionId, int eventType) {
        this.mSmartspaceTarget = smartspaceTarget;
        this.mSmartspaceActionId = smartspaceActionId;
        this.mEventType = eventType;
    }

    private SmartspaceTargetEvent(Parcel parcel) {
        this.mSmartspaceTarget = parcel.readParcelable(null, SmartspaceTarget.class);
        this.mSmartspaceActionId = parcel.readString();
        this.mEventType = parcel.readInt();
    }

    @Nullable
    public SmartspaceTarget getSmartspaceTarget() {
        return this.mSmartspaceTarget;
    }

    @Nullable
    public String getSmartspaceActionId() {
        return this.mSmartspaceActionId;
    }

    @NonNull
    public int getEventType() {
        return this.mEventType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mSmartspaceTarget, flags);
        dest.writeString(this.mSmartspaceActionId);
        dest.writeInt(this.mEventType);
    }

    public String toString() {
        return "SmartspaceTargetEvent{mSmartspaceTarget=" + this.mSmartspaceTarget + ", mSmartspaceActionId='" + this.mSmartspaceActionId + '\'' + ", mEventType=" + this.mEventType + '}';
    }

    @SystemApi
    public static class Builder {
        private final int mEventType;
        @Nullable
        private SmartspaceTarget mSmartspaceTarget;
        @Nullable
        private String mSmartspaceActionId;

        public Builder(int eventType) {
            this.mEventType = eventType;
        }

        @NonNull
        public Builder setSmartspaceTarget(@NonNull SmartspaceTarget smartspaceTarget) {
            this.mSmartspaceTarget = smartspaceTarget;
            return this;
        }

        @NonNull
        public Builder setSmartspaceActionId(@NonNull String smartspaceActionId) {
            this.mSmartspaceActionId = smartspaceActionId;
            return this;
        }

        @NonNull
        public SmartspaceTargetEvent build() {
            return new SmartspaceTargetEvent(this.mSmartspaceTarget, this.mSmartspaceActionId, this.mEventType);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EventType {
    }
}

