/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace.uitemplatedata;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.smartspace.SmartspaceUtils;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class TapAction
implements Parcelable {
    @Nullable
    private final CharSequence mId;
    @Nullable
    private final Intent mIntent;
    @Nullable
    private final PendingIntent mPendingIntent;
    @Nullable
    private final UserHandle mUserHandle;
    @Nullable
    private final Bundle mExtras;
    private final boolean mShouldShowOnLockscreen;
    @NonNull
    public static final Parcelable.Creator<TapAction> CREATOR = new Parcelable.Creator<TapAction>(){

        @Override
        public TapAction createFromParcel(Parcel in) {
            return new TapAction(in);
        }

        public TapAction[] newArray(int size) {
            return new TapAction[size];
        }
    };

    TapAction(@NonNull Parcel in) {
        this.mId = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mIntent = in.readTypedObject(Intent.CREATOR);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mUserHandle = in.readTypedObject(UserHandle.CREATOR);
        this.mExtras = in.readBundle();
        this.mShouldShowOnLockscreen = in.readBoolean();
    }

    private TapAction(@Nullable CharSequence id2, @Nullable Intent intent, @Nullable PendingIntent pendingIntent, @Nullable UserHandle userHandle, @Nullable Bundle extras, boolean shouldShowOnLockscreen) {
        this.mId = id2;
        this.mIntent = intent;
        this.mPendingIntent = pendingIntent;
        this.mUserHandle = userHandle;
        this.mExtras = extras;
        this.mShouldShowOnLockscreen = shouldShowOnLockscreen;
    }

    @Nullable
    public CharSequence getId() {
        return this.mId;
    }

    @SuppressLint(value={"IntentBuilderName"})
    @Nullable
    public Intent getIntent() {
        return this.mIntent;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @Nullable
    @SuppressLint(value={"NullableCollection"})
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean shouldShowOnLockscreen() {
        return this.mShouldShowOnLockscreen;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        TextUtils.writeToParcel(this.mId, out, flags);
        out.writeTypedObject(this.mIntent, flags);
        out.writeTypedObject(this.mPendingIntent, flags);
        out.writeTypedObject(this.mUserHandle, flags);
        out.writeBundle(this.mExtras);
        out.writeBoolean(this.mShouldShowOnLockscreen);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TapAction)) {
            return false;
        }
        TapAction that = (TapAction)o;
        return SmartspaceUtils.isEqual(this.mId, that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    public String toString() {
        return "SmartspaceTapAction{mId=" + this.mId + "mIntent=" + this.mIntent + ", mPendingIntent=" + this.mPendingIntent + ", mUserHandle=" + this.mUserHandle + ", mExtras=" + this.mExtras + ", mShouldShowOnLockscreen=" + this.mShouldShowOnLockscreen + '}';
    }

    @SystemApi
    public static class Builder {
        private CharSequence mId;
        private Intent mIntent;
        private PendingIntent mPendingIntent;
        private UserHandle mUserHandle;
        private Bundle mExtras;
        private boolean mShouldShowOnLockScreen;

        public Builder(@NonNull CharSequence id2) {
            this.mId = Objects.requireNonNull(id2);
            this.mShouldShowOnLockScreen = false;
        }

        @NonNull
        public Builder setIntent(@NonNull Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @NonNull
        public Builder setPendingIntent(@NonNull PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @NonNull
        @SuppressLint(value={"UserHandleName"})
        public Builder setUserHandle(@Nullable UserHandle userHandle) {
            this.mUserHandle = userHandle;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public Builder setShouldShowOnLockscreen(@NonNull boolean shouldShowOnLockScreen) {
            this.mShouldShowOnLockScreen = shouldShowOnLockScreen;
            return this;
        }

        @NonNull
        public TapAction build() {
            if (this.mIntent == null && this.mPendingIntent == null && this.mExtras == null) {
                throw new IllegalStateException("Please assign at least 1 valid tap field");
            }
            return new TapAction(this.mId, this.mIntent, this.mPendingIntent, this.mUserHandle, this.mExtras, this.mShouldShowOnLockScreen);
        }
    }
}

