/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.time.TimeZoneConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Objects;

@SystemApi
public class TimeZoneCapabilities
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TimeZoneCapabilities> CREATOR = new Parcelable.Creator<TimeZoneCapabilities>(){

        @Override
        public TimeZoneCapabilities createFromParcel(Parcel in) {
            return TimeZoneCapabilities.createFromParcel(in);
        }

        public TimeZoneCapabilities[] newArray(int size) {
            return new TimeZoneCapabilities[size];
        }
    };
    @NonNull
    private final UserHandle mUserHandle;
    private final int mConfigureAutoDetectionEnabledCapability;
    private final boolean mUseLocationEnabled;
    private final int mConfigureGeoDetectionEnabledCapability;
    private final int mSetManualTimeZoneCapability;
    private final int mConfigureNotificationsEnabledCapability;

    private TimeZoneCapabilities(@NonNull Builder builder) {
        this.mUserHandle = Objects.requireNonNull(builder.mUserHandle);
        this.mConfigureAutoDetectionEnabledCapability = builder.mConfigureAutoDetectionEnabledCapability;
        this.mUseLocationEnabled = builder.mUseLocationEnabled;
        this.mConfigureGeoDetectionEnabledCapability = builder.mConfigureGeoDetectionEnabledCapability;
        this.mSetManualTimeZoneCapability = builder.mSetManualTimeZoneCapability;
        this.mConfigureNotificationsEnabledCapability = builder.mConfigureNotificationsEnabledCapability;
    }

    @NonNull
    private static TimeZoneCapabilities createFromParcel(@NonNull Parcel in) {
        UserHandle userHandle = UserHandle.readFromParcel(in);
        return new Builder(userHandle).setConfigureAutoDetectionEnabledCapability(in.readInt()).setUseLocationEnabled(in.readBoolean()).setConfigureGeoDetectionEnabledCapability(in.readInt()).setSetManualTimeZoneCapability(in.readInt()).setConfigureNotificationsEnabledCapability(in.readInt()).build();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        UserHandle.writeToParcel(this.mUserHandle, dest);
        dest.writeInt(this.mConfigureAutoDetectionEnabledCapability);
        dest.writeBoolean(this.mUseLocationEnabled);
        dest.writeInt(this.mConfigureGeoDetectionEnabledCapability);
        dest.writeInt(this.mSetManualTimeZoneCapability);
        dest.writeInt(this.mConfigureNotificationsEnabledCapability);
    }

    public int getConfigureAutoDetectionEnabledCapability() {
        return this.mConfigureAutoDetectionEnabledCapability;
    }

    public boolean isUseLocationEnabled() {
        return this.mUseLocationEnabled;
    }

    public int getConfigureGeoDetectionEnabledCapability() {
        return this.mConfigureGeoDetectionEnabledCapability;
    }

    public int getSetManualTimeZoneCapability() {
        return this.mSetManualTimeZoneCapability;
    }

    public int getConfigureNotificationsEnabledCapability() {
        return this.mConfigureNotificationsEnabledCapability;
    }

    @Nullable
    public TimeZoneConfiguration tryApplyConfigChanges(@NonNull TimeZoneConfiguration config, @NonNull TimeZoneConfiguration requestedChanges) {
        TimeZoneConfiguration.Builder newConfigBuilder = new TimeZoneConfiguration.Builder(config);
        if (requestedChanges.hasIsAutoDetectionEnabled()) {
            if (this.getConfigureAutoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setAutoDetectionEnabled(requestedChanges.isAutoDetectionEnabled());
        }
        if (requestedChanges.hasIsGeoDetectionEnabled()) {
            if (this.getConfigureGeoDetectionEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setGeoDetectionEnabled(requestedChanges.isGeoDetectionEnabled());
        }
        if (requestedChanges.hasIsNotificationsEnabled()) {
            if (this.getConfigureNotificationsEnabledCapability() < 30) {
                return null;
            }
            newConfigBuilder.setNotificationsEnabled(requestedChanges.areNotificationsEnabled());
        }
        return newConfigBuilder.build();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneCapabilities that = (TimeZoneCapabilities)o;
        return this.mUserHandle.equals(that.mUserHandle) && this.mConfigureAutoDetectionEnabledCapability == that.mConfigureAutoDetectionEnabledCapability && this.mUseLocationEnabled == that.mUseLocationEnabled && this.mConfigureGeoDetectionEnabledCapability == that.mConfigureGeoDetectionEnabledCapability && this.mSetManualTimeZoneCapability == that.mSetManualTimeZoneCapability && this.mConfigureNotificationsEnabledCapability == that.mConfigureNotificationsEnabledCapability;
    }

    public int hashCode() {
        return Objects.hash(this.mUserHandle, this.mConfigureAutoDetectionEnabledCapability, this.mConfigureGeoDetectionEnabledCapability, this.mSetManualTimeZoneCapability, this.mConfigureNotificationsEnabledCapability);
    }

    public String toString() {
        return "TimeZoneDetectorCapabilities{mUserHandle=" + this.mUserHandle + ", mConfigureAutoDetectionEnabledCapability=" + this.mConfigureAutoDetectionEnabledCapability + ", mUseLocationEnabled=" + this.mUseLocationEnabled + ", mConfigureGeoDetectionEnabledCapability=" + this.mConfigureGeoDetectionEnabledCapability + ", mSetManualTimeZoneCapability=" + this.mSetManualTimeZoneCapability + ", mConfigureNotificationsEnabledCapability=" + this.mConfigureNotificationsEnabledCapability + '}';
    }

    public static class Builder {
        @NonNull
        private UserHandle mUserHandle;
        private int mConfigureAutoDetectionEnabledCapability;
        private Boolean mUseLocationEnabled;
        private int mConfigureGeoDetectionEnabledCapability;
        private int mSetManualTimeZoneCapability;
        private int mConfigureNotificationsEnabledCapability;

        public Builder(@NonNull UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
        }

        public Builder(@NonNull TimeZoneCapabilities capabilitiesToCopy) {
            Objects.requireNonNull(capabilitiesToCopy);
            this.mUserHandle = capabilitiesToCopy.mUserHandle;
            this.mConfigureAutoDetectionEnabledCapability = capabilitiesToCopy.mConfigureAutoDetectionEnabledCapability;
            this.mUseLocationEnabled = capabilitiesToCopy.mUseLocationEnabled;
            this.mConfigureGeoDetectionEnabledCapability = capabilitiesToCopy.mConfigureGeoDetectionEnabledCapability;
            this.mSetManualTimeZoneCapability = capabilitiesToCopy.mSetManualTimeZoneCapability;
            this.mConfigureNotificationsEnabledCapability = capabilitiesToCopy.mConfigureNotificationsEnabledCapability;
        }

        public Builder setConfigureAutoDetectionEnabledCapability(int value) {
            this.mConfigureAutoDetectionEnabledCapability = value;
            return this;
        }

        public Builder setUseLocationEnabled(boolean useLocation) {
            this.mUseLocationEnabled = useLocation;
            return this;
        }

        public Builder setConfigureGeoDetectionEnabledCapability(int value) {
            this.mConfigureGeoDetectionEnabledCapability = value;
            return this;
        }

        public Builder setSetManualTimeZoneCapability(int value) {
            this.mSetManualTimeZoneCapability = value;
            return this;
        }

        public Builder setConfigureNotificationsEnabledCapability(int value) {
            this.mConfigureNotificationsEnabledCapability = value;
            return this;
        }

        @NonNull
        public TimeZoneCapabilities build() {
            this.verifyCapabilitySet(this.mConfigureAutoDetectionEnabledCapability, "configureAutoDetectionEnabledCapability");
            Objects.requireNonNull(this.mUseLocationEnabled, "useLocationEnabled");
            this.verifyCapabilitySet(this.mConfigureGeoDetectionEnabledCapability, "configureGeoDetectionEnabledCapability");
            this.verifyCapabilitySet(this.mSetManualTimeZoneCapability, "setManualTimeZoneCapability");
            this.verifyCapabilitySet(this.mConfigureNotificationsEnabledCapability, "configureNotificationsEnabledCapability");
            return new TimeZoneCapabilities(this);
        }

        private void verifyCapabilitySet(int value, String name) {
            if (value == 0) {
                throw new IllegalStateException(name + " not set");
            }
        }
    }
}

