/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.app.time.ExternalTimeSuggestion;
import android.app.time.ITimeDetectorListener;
import android.app.time.TimeCapabilitiesAndConfig;
import android.app.time.TimeConfiguration;
import android.app.time.TimeState;
import android.app.time.UnixEpochTime;
import android.app.timedetector.ManualTimeSuggestion;
import android.app.timedetector.TelephonyTimeSuggestion;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITimeDetectorService
extends IInterface {
    public static final String DESCRIPTOR = "android.app.timedetector.ITimeDetectorService";

    public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException;

    public void addListener(ITimeDetectorListener var1) throws RemoteException;

    public void removeListener(ITimeDetectorListener var1) throws RemoteException;

    public boolean updateConfiguration(TimeConfiguration var1) throws RemoteException;

    public TimeState getTimeState() throws RemoteException;

    public boolean confirmTime(UnixEpochTime var1) throws RemoteException;

    public boolean setManualTime(ManualTimeSuggestion var1) throws RemoteException;

    public void suggestExternalTime(ExternalTimeSuggestion var1) throws RemoteException;

    public boolean suggestManualTime(ManualTimeSuggestion var1) throws RemoteException;

    public void suggestTelephonyTime(TelephonyTimeSuggestion var1) throws RemoteException;

    public UnixEpochTime latestNetworkTime() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITimeDetectorService {
        static final int TRANSACTION_getCapabilitiesAndConfig = 1;
        static final int TRANSACTION_addListener = 2;
        static final int TRANSACTION_removeListener = 3;
        static final int TRANSACTION_updateConfiguration = 4;
        static final int TRANSACTION_getTimeState = 5;
        static final int TRANSACTION_confirmTime = 6;
        static final int TRANSACTION_setManualTime = 7;
        static final int TRANSACTION_suggestExternalTime = 8;
        static final int TRANSACTION_suggestManualTime = 9;
        static final int TRANSACTION_suggestTelephonyTime = 10;
        static final int TRANSACTION_latestNetworkTime = 11;

        public Stub() {
            this.attachInterface(this, ITimeDetectorService.DESCRIPTOR);
        }

        public static ITimeDetectorService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITimeDetectorService.DESCRIPTOR);
            if (iin != null && iin instanceof ITimeDetectorService) {
                return (ITimeDetectorService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getCapabilitiesAndConfig";
                }
                case 2: {
                    return "addListener";
                }
                case 3: {
                    return "removeListener";
                }
                case 4: {
                    return "updateConfiguration";
                }
                case 5: {
                    return "getTimeState";
                }
                case 6: {
                    return "confirmTime";
                }
                case 7: {
                    return "setManualTime";
                }
                case 8: {
                    return "suggestExternalTime";
                }
                case 9: {
                    return "suggestManualTime";
                }
                case 10: {
                    return "suggestTelephonyTime";
                }
                case 11: {
                    return "latestNetworkTime";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITimeDetectorService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    TimeCapabilitiesAndConfig _result = this.getCapabilitiesAndConfig();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    ITimeDetectorListener _arg0 = ITimeDetectorListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ITimeDetectorListener _arg0 = ITimeDetectorListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    TimeConfiguration _arg0 = data.readTypedObject(TimeConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.updateConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    TimeState _result = this.getTimeState();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    UnixEpochTime _arg0 = data.readTypedObject(UnixEpochTime.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.confirmTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    ManualTimeSuggestion _arg0 = data.readTypedObject(ManualTimeSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.setManualTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 8: {
                    ExternalTimeSuggestion _arg0 = data.readTypedObject(ExternalTimeSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    this.suggestExternalTime(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ManualTimeSuggestion _arg0 = data.readTypedObject(ManualTimeSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.suggestManualTime(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    TelephonyTimeSuggestion _arg0 = data.readTypedObject(TelephonyTimeSuggestion.CREATOR);
                    data.enforceNoDataAvail();
                    this.suggestTelephonyTime(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    UnixEpochTime _result = this.latestNetworkTime();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements ITimeDetectorService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITimeDetectorService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
                TimeCapabilitiesAndConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TimeCapabilitiesAndConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addListener(ITimeDetectorListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeListener(ITimeDetectorListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean updateConfiguration(TimeConfiguration timeConfiguration) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeConfiguration, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TimeState getTimeState() throws RemoteException {
                TimeState _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TimeState.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean confirmTime(UnixEpochTime time) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(time, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setManualTime(ManualTimeSuggestion timeZoneSuggestion) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeZoneSuggestion, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeSuggestion, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean suggestManualTime(ManualTimeSuggestion timeSuggestion) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeSuggestion, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestTelephonyTime(TelephonyTimeSuggestion timeSuggestion) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    _data.writeTypedObject(timeSuggestion, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UnixEpochTime latestNetworkTime() throws RemoteException {
                UnixEpochTime _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITimeDetectorService.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(UnixEpochTime.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ITimeDetectorService {
        @Override
        public TimeCapabilitiesAndConfig getCapabilitiesAndConfig() throws RemoteException {
            return null;
        }

        @Override
        public void addListener(ITimeDetectorListener listener) throws RemoteException {
        }

        @Override
        public void removeListener(ITimeDetectorListener listener) throws RemoteException {
        }

        @Override
        public boolean updateConfiguration(TimeConfiguration timeConfiguration) throws RemoteException {
            return false;
        }

        @Override
        public TimeState getTimeState() throws RemoteException {
            return null;
        }

        @Override
        public boolean confirmTime(UnixEpochTime time) throws RemoteException {
            return false;
        }

        @Override
        public boolean setManualTime(ManualTimeSuggestion timeZoneSuggestion) throws RemoteException {
            return false;
        }

        @Override
        public void suggestExternalTime(ExternalTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public boolean suggestManualTime(ManualTimeSuggestion timeSuggestion) throws RemoteException {
            return false;
        }

        @Override
        public void suggestTelephonyTime(TelephonyTimeSuggestion timeSuggestion) throws RemoteException {
        }

        @Override
        public UnixEpochTime latestNetworkTime() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

