/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.usage.NetworkStats;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.net.DataUsageRequest;
import android.net.INetworkStatsService;
import android.net.Network;
import android.net.NetworkStateSnapshot;
import android.net.NetworkTemplate;
import android.net.UnderlyingNetworkInfo;
import android.net.connectivity.android.net.netstats.IUsageCallback;
import android.net.connectivity.com.android.net.module.util.NetworkIdentityUtils;
import android.net.netstats.provider.INetworkStatsProviderCallback;
import android.net.netstats.provider.NetworkStatsProvider;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class NetworkStatsManager {
    private static final String TAG = "NetworkStatsManager";
    private static final boolean DBG = false;
    public static final int CALLBACK_LIMIT_REACHED = 0;
    public static final int CALLBACK_RELEASED = 1;
    public static final long MIN_THRESHOLD_BYTES = 0x200000L;
    private final Context mContext;
    private final INetworkStatsService mService;
    @Deprecated
    public static final String PREFIX_DEV = "dev";
    public static final int FLAG_POLL_ON_OPEN = 1;
    public static final int FLAG_POLL_FORCE = 2;
    public static final int FLAG_AUGMENT_WITH_SUBSCRIPTION_PLAN = 4;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final int NETWORK_TYPE_5G_NSA = -2;
    private int mFlags;

    @VisibleForTesting
    public NetworkStatsManager(Context context, INetworkStatsService service) {
        this.mContext = context;
        this.mService = service;
        this.setPollOnOpen(true);
        this.setAugmentWithSubscriptionPlan(true);
    }

    public INetworkStatsService getBinder() {
        return this.mService;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void setPollOnOpen(boolean pollOnOpen) {
        this.mFlags = pollOnOpen ? (this.mFlags |= 1) : (this.mFlags &= 0xFFFFFFFE);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setPollForce(boolean pollForce) {
        this.mFlags = pollForce ? (this.mFlags |= 2) : (this.mFlags &= 0xFFFFFFFD);
    }

    public void setAugmentWithSubscriptionPlan(boolean augmentWithSubscriptionPlan) {
        this.mFlags = augmentWithSubscriptionPlan ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public NetworkStats.Bucket querySummaryForDevice(@NonNull NetworkTemplate template, long startTime, long endTime) {
        Objects.requireNonNull(template);
        try {
            NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            NetworkStats.Bucket bucket = stats.getDeviceSummaryForNetwork();
            stats.close();
            return bucket;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public NetworkStats.Bucket querySummaryForDevice(int networkType, @Nullable String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummaryForDevice(template, startTime, endTime);
    }

    public NetworkStats.Bucket querySummaryForUser(int networkType, @Nullable String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats stats = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        stats.startSummaryEnumeration();
        stats.close();
        return stats.getSummaryAggregate();
    }

    public NetworkStats querySummary(int networkType, @Nullable String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.querySummary(template, startTime, endTime);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public NetworkStats querySummary(@NonNull NetworkTemplate template, long startTime, long endTime) throws SecurityException {
        Objects.requireNonNull(template);
        try {
            NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startSummaryEnumeration();
            return result;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public NetworkStats queryTaggedSummary(@NonNull NetworkTemplate template, long startTime, long endTime) throws SecurityException {
        Objects.requireNonNull(template);
        try {
            NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startTaggedSummaryEnumeration();
            return result;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public NetworkStats queryDetailsForDevice(@NonNull NetworkTemplate template, long startTime, long endTime) {
        Objects.requireNonNull(template);
        try {
            NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startHistoryDeviceEnumeration();
            return result;
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return null;
        }
    }

    @NonNull
    public NetworkStats queryDetailsForUid(int networkType, @Nullable String subscriberId, long startTime, long endTime, int uid) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, 0, -1);
    }

    @NonNull
    public NetworkStats queryDetailsForUid(@NonNull NetworkTemplate template, long startTime, long endTime, int uid) throws SecurityException {
        return this.queryDetailsForUidTagState(template, startTime, endTime, uid, 0, -1);
    }

    @NonNull
    public NetworkStats queryDetailsForUidTag(int networkType, @Nullable String subscriberId, long startTime, long endTime, int uid, int tag) throws SecurityException {
        return this.queryDetailsForUidTagState(networkType, subscriberId, startTime, endTime, uid, tag, -1);
    }

    @NonNull
    public NetworkStats queryDetailsForUidTagState(int networkType, @Nullable String subscriberId, long startTime, long endTime, int uid, int tag, int state) throws SecurityException {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        return this.queryDetailsForUidTagState(template, startTime, endTime, uid, tag, state);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @NonNull
    public NetworkStats queryDetailsForUidTagState(@NonNull NetworkTemplate template, long startTime, long endTime, int uid, int tag, int state) throws SecurityException {
        Objects.requireNonNull(template);
        try {
            NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
            result.startHistoryUidEnumeration(uid, tag, state);
            return result;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error while querying stats for uid=" + uid + " tag=" + tag + " state=" + state, e);
            e.rethrowFromSystemServer();
            return null;
        }
    }

    public NetworkStats queryDetails(int networkType, @Nullable String subscriberId, long startTime, long endTime) throws SecurityException, RemoteException {
        NetworkTemplate template;
        try {
            template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        NetworkStats result = new NetworkStats(this.mContext, template, this.mFlags, startTime, endTime, this.mService);
        result.startUserUidEnumeration();
        return result;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    @NonNull
    public android.net.NetworkStats getMobileUidStats() {
        try {
            return this.mService.getUidStatsForTransport(0);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    @NonNull
    public android.net.NetworkStats getWifiUidStats() {
        try {
            return this.mService.getUidStatsForTransport(1);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"}, conditional=true)
    public void registerUsageCallback(@NonNull NetworkTemplate template, long thresholdBytes, @NonNull Executor executor, @NonNull UsageCallback callback) {
        Objects.requireNonNull(template, "NetworkTemplate cannot be null");
        Objects.requireNonNull(callback, "UsageCallback cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        DataUsageRequest request = new DataUsageRequest(0, template, thresholdBytes);
        try {
            UsageCallbackWrapper callbackWrapper = new UsageCallbackWrapper(executor, callback);
            callback.request = this.mService.registerUsageCallback(this.mContext.getOpPackageName(), request, callbackWrapper);
            if (callback.request == null) {
                Log.e(TAG, "Request from callback is null; should not happen");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void registerUsageCallback(int networkType, @Nullable String subscriberId, long thresholdBytes, @NonNull UsageCallback callback) {
        this.registerUsageCallback(networkType, subscriberId, thresholdBytes, callback, null);
    }

    public void registerUsageCallback(int networkType, @Nullable String subscriberId, long thresholdBytes, @NonNull UsageCallback callback, @Nullable Handler handler) {
        NetworkTemplate template = NetworkStatsManager.createTemplate(networkType, subscriberId);
        Executor executor = handler == null ? r -> r.run() : r -> handler.post(r);
        this.registerUsageCallback(template, thresholdBytes, executor, callback);
    }

    public void unregisterUsageCallback(@NonNull UsageCallback callback) {
        if (callback == null || callback.request == null || callback.request.requestId == 0) {
            throw new IllegalArgumentException("Invalid UsageCallback");
        }
        try {
            this.mService.unregisterUsageRequest(callback.request);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STATS_PROVIDER", "android.permission.MAINLINE_NETWORK_STACK"})
    public void registerNetworkStatsProvider(@NonNull String tag, @NonNull NetworkStatsProvider provider) {
        try {
            if (provider.getProviderCallbackBinder() != null) {
                throw new IllegalArgumentException("provider is already registered");
            }
            INetworkStatsProviderCallback cbBinder = this.mService.registerNetworkStatsProvider(tag, provider.getProviderBinder());
            provider.setProviderCallbackBinder(cbBinder);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.NETWORK_STATS_PROVIDER", "android.permission.MAINLINE_NETWORK_STACK"})
    public void unregisterNetworkStatsProvider(@NonNull NetworkStatsProvider provider) {
        try {
            provider.getProviderCallbackBinderOrThrow().unregister();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private static NetworkTemplate createTemplate(int networkType, @Nullable String subscriberId) {
        NetworkTemplate template;
        switch (networkType) {
            case 0: {
                template = subscriberId == null ? new NetworkTemplate.Builder(1).setMeteredness(1).build() : new NetworkTemplate.Builder(1).setMeteredness(1).setSubscriberIds(Set.of(subscriberId)).build();
                break;
            }
            case 1: {
                template = TextUtils.isEmpty(subscriberId) ? new NetworkTemplate.Builder(4).build() : new NetworkTemplate.Builder(4).setSubscriberIds(Set.of(subscriberId)).build();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create template for network type " + networkType + ", subscriberId '" + NetworkIdentityUtils.scrubSubscriberId(subscriberId) + "'.");
            }
        }
        return template;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void notifyNetworkStatus(@NonNull List<Network> defaultNetworks, @NonNull List<NetworkStateSnapshot> networkStateSnapshots, @Nullable String activeIface, @NonNull List<UnderlyingNetworkInfo> underlyingNetworkInfos) {
        try {
            Objects.requireNonNull(defaultNetworks);
            Objects.requireNonNull(networkStateSnapshots);
            Objects.requireNonNull(underlyingNetworkInfos);
            this.mService.notifyNetworkStatus(defaultNetworks.toArray(new Network[0]), networkStateSnapshots.toArray(new NetworkStateSnapshot[0]), activeIface, underlyingNetworkInfos.toArray(new UnderlyingNetworkInfo[0]));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void noteUidForeground(int uid, boolean uidForeground) {
        try {
            this.mService.noteUidForeground(uid, uidForeground);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void setDefaultGlobalAlert(long alertBytes) {
        try {
            this.mService.advisePersistThreshold(alertBytes);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void forceUpdate() {
        try {
            this.mService.forceUpdate();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(anyOf={"android.permission.MAINLINE_NETWORK_STACK", "android.permission.NETWORK_STACK"})
    public void setStatsProviderWarningAndLimitAsync(@NonNull String iface, long warning, long limit) {
        try {
            this.mService.setStatsProviderWarningAndLimitAsync(iface, warning, limit);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static int getCollapsedRatType(int ratType) {
        switch (ratType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 16;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 3;
            }
            case 13: 
            case 18: {
                return 13;
            }
            case 20: {
                return 20;
            }
            case -2: {
                return -2;
            }
        }
        return 0;
    }

    private static class UsageCallbackWrapper
    extends IUsageCallback.Stub {
        private volatile UsageCallback mCallback;
        private final Executor mExecutor;

        UsageCallbackWrapper(@NonNull Executor executor, @NonNull UsageCallback callback) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onThresholdReached(DataUsageRequest request) {
            UsageCallback callback = this.mCallback;
            if (callback != null) {
                this.mExecutor.execute(() -> callback.onThresholdReached(request.template));
            } else {
                Log.e(NetworkStatsManager.TAG, "onThresholdReached with released callback for " + request);
            }
        }

        @Override
        public void onCallbackReleased(DataUsageRequest request) {
            this.mCallback = null;
        }
    }

    public static abstract class UsageCallback {
        private DataUsageRequest request;

        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public void onThresholdReached(@NonNull NetworkTemplate template) {
            int networkType = UsageCallback.networkTypeForTemplate(template);
            if (networkType != -1) {
                String subscriberId = template.getSubscriberIds().isEmpty() ? null : template.getSubscriberIds().iterator().next();
                this.onThresholdReached(networkType, subscriberId);
            }
        }

        public abstract void onThresholdReached(int var1, @Nullable String var2);

        private static int networkTypeForTemplate(@NonNull NetworkTemplate template) {
            switch (template.getMatchRule()) {
                case 1: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
            }
            return -1;
        }
    }
}

