/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.android.internal.infra.AndroidFuture;

public interface IWearableSensingCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.wearable.IWearableSensingCallback";

    public void openFile(String var1, AndroidFuture<ParcelFileDescriptor> var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWearableSensingCallback {
        static final int TRANSACTION_openFile = 1;

        public Stub() {
            this.attachInterface(this, IWearableSensingCallback.DESCRIPTOR);
        }

        public static IWearableSensingCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWearableSensingCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IWearableSensingCallback) {
                return (IWearableSensingCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "openFile";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWearableSensingCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    AndroidFuture _arg1 = data.readTypedObject(AndroidFuture.CREATOR);
                    data.enforceNoDataAvail();
                    this.openFile(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWearableSensingCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWearableSensingCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void openFile(String filename, AndroidFuture<ParcelFileDescriptor> future) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWearableSensingCallback.DESCRIPTOR);
                    _data.writeString(filename);
                    _data.writeTypedObject(future, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWearableSensingCallback {
        @Override
        public void openFile(String filename, AndroidFuture<ParcelFileDescriptor> future) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

