/*
 * Decompiled with CFR 0.152.
 */
package android.apphibernation;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.apphibernation.HibernationStats;
import android.apphibernation.IAppHibernationService;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SystemApi
public class AppHibernationManager {
    private static final String TAG = "AppHibernationManager";
    private final Context mContext;
    private final IAppHibernationService mIAppHibernationService;

    public AppHibernationManager(@NonNull Context context) {
        this.mContext = context;
        this.mIAppHibernationService = IAppHibernationService.Stub.asInterface(ServiceManager.getService("app_hibernation"));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public boolean isHibernatingForUser(@NonNull String packageName) {
        try {
            return this.mIAppHibernationService.isHibernatingForUser(packageName, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public void setHibernatingForUser(@NonNull String packageName, boolean isHibernating) {
        try {
            this.mIAppHibernationService.setHibernatingForUser(packageName, this.mContext.getUserId(), isHibernating);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public boolean isHibernatingGlobally(@NonNull String packageName) {
        try {
            return this.mIAppHibernationService.isHibernatingGlobally(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public void setHibernatingGlobally(@NonNull String packageName, boolean isHibernating) {
        try {
            this.mIAppHibernationService.setHibernatingGlobally(packageName, isHibernating);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    @NonNull
    public List<String> getHibernatingPackagesForUser() {
        try {
            return this.mIAppHibernationService.getHibernatingPackagesForUser(this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    @NonNull
    public Map<String, HibernationStats> getHibernationStatsForUser(@NonNull Set<String> packageNames) {
        try {
            return this.mIAppHibernationService.getHibernationStatsForUser(new ArrayList<String>(packageNames), this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    @NonNull
    public Map<String, HibernationStats> getHibernationStatsForUser() {
        try {
            return this.mIAppHibernationService.getHibernationStatsForUser(null, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_APP_HIBERNATION")
    public boolean isOatArtifactDeletionEnabled() {
        try {
            return this.mIAppHibernationService.isOatArtifactDeletionEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

