/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.ArraySet;
import java.util.Arrays;

@FlaggedApi(value="android.appwidget.flags.engagement_metrics")
public class AppWidgetEvent
implements Parcelable {
    public static final int MAX_NUM_ITEMS = 10;
    private final int mAppWidgetId;
    private final long mDurationMs;
    @Nullable
    private final Rect mPosition;
    @Nullable
    private final int[] mClickedIds;
    @Nullable
    private final int[] mScrolledIds;
    @NonNull
    public static final Parcelable.Creator<AppWidgetEvent> CREATOR = new Parcelable.Creator<AppWidgetEvent>(){

        @Override
        public AppWidgetEvent createFromParcel(Parcel parcel) {
            return new AppWidgetEvent(parcel);
        }

        public AppWidgetEvent[] newArray(int size) {
            return new AppWidgetEvent[size];
        }
    };

    public int getAppWidgetId() {
        return this.mAppWidgetId;
    }

    public long getDurationMs() {
        return this.mDurationMs;
    }

    @Nullable
    public Rect getPosition() {
        return this.mPosition;
    }

    @Nullable
    public int[] getClickedIds() {
        return this.mClickedIds;
    }

    @Nullable
    public int[] getScrolledIds() {
        return this.mScrolledIds;
    }

    private AppWidgetEvent(int appWidgetId, long durationMs, @Nullable Rect position, @Nullable int[] clickedIds, @Nullable int[] scrolledIds) {
        this.mAppWidgetId = appWidgetId;
        this.mDurationMs = durationMs;
        this.mPosition = position;
        this.mClickedIds = clickedIds;
        this.mScrolledIds = scrolledIds;
    }

    private AppWidgetEvent(Parcel in) {
        this.mAppWidgetId = in.readInt();
        this.mDurationMs = in.readLong();
        this.mPosition = in.readTypedObject(Rect.CREATOR);
        this.mClickedIds = in.createIntArray();
        this.mScrolledIds = in.createIntArray();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mAppWidgetId);
        out.writeLong(this.mDurationMs);
        out.writeTypedObject(this.mPosition, flags);
        out.writeIntArray(this.mClickedIds);
        out.writeIntArray(this.mScrolledIds);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public PersistableBundle toBundle() {
        PersistableBundle extras = new PersistableBundle();
        extras.putString("android.app.usage.extra.EVENT_ACTION", "widget_interaction");
        extras.putString("android.app.usage.extra.EVENT_CATEGORY", "android.appwidget");
        extras.putInt("appWidgetId", this.mAppWidgetId);
        extras.putLong("android.appwidget.extra.EVENT_DURATION_MS", this.mDurationMs);
        if (this.mPosition != null) {
            extras.putIntArray("android.appwidget.extra.EVENT_POSITION_RECT", new int[]{this.mPosition.left, this.mPosition.top, this.mPosition.right, this.mPosition.bottom});
        }
        if (this.mClickedIds != null && this.mClickedIds.length > 0) {
            extras.putIntArray("android.appwidget.extra.EVENT_CLICKED_VIEWS", this.mClickedIds);
        }
        if (this.mScrolledIds != null && this.mScrolledIds.length > 0) {
            extras.putIntArray("android.appwidget.extra.EVENT_SCROLLED_VIEWS", this.mScrolledIds);
        }
        return extras;
    }

    public String toString() {
        return TextUtils.formatSimple("AppWidgetEvent(appWidgetId=%d, durationMs=%d, position=%s, clickedIds=%s, scrolledIds=%s)", this.mAppWidgetId, this.mDurationMs, this.mPosition, Arrays.toString(this.mClickedIds), Arrays.toString(this.mScrolledIds));
    }

    public static class Builder {
        @NonNull
        private final ArraySet<Integer> mClickedIds = new ArraySet(10);
        @NonNull
        private final ArraySet<Integer> mScrolledIds = new ArraySet(10);
        private int mAppWidgetId = 0;
        private long mDurationMs = 0L;
        @Nullable
        private Rect mPosition = null;

        public Builder setAppWidgetId(int appWidgetId) {
            this.mAppWidgetId = appWidgetId;
            return this;
        }

        public Builder addDurationMs(long durationMs) {
            this.mDurationMs += durationMs;
            return this;
        }

        public Builder setPosition(@Nullable Rect position) {
            this.mPosition = position;
            return this;
        }

        public Builder addClickedId(int id2) {
            if (this.mClickedIds.size() < 10) {
                this.mClickedIds.add(id2);
            }
            return this;
        }

        public Builder addScrolledId(int id2) {
            if (this.mScrolledIds.size() < 10) {
                this.mScrolledIds.add(id2);
            }
            return this;
        }

        public void merge(@Nullable AppWidgetEvent event) {
            if (event == null) {
                return;
            }
            if (this.mAppWidgetId == 0) {
                this.setAppWidgetId(event.getAppWidgetId());
            } else if (this.mAppWidgetId != event.getAppWidgetId()) {
                throw new IllegalArgumentException("Trying to merge events with different app widget IDs: " + this.mAppWidgetId + " != " + event.getAppWidgetId());
            }
            this.addDurationMs(event.getDurationMs());
            this.setPosition(event.getPosition());
            Builder.addAllUntilMax(this.mClickedIds, event.getClickedIds());
            Builder.addAllUntilMax(this.mScrolledIds, event.getScrolledIds());
        }

        public boolean isEmpty() {
            return this.mAppWidgetId <= 0 || this.mDurationMs == 0L;
        }

        public void clear() {
            this.mDurationMs = 0L;
            this.mPosition = null;
            this.mClickedIds.clear();
            this.mScrolledIds.clear();
        }

        public AppWidgetEvent build() {
            return new AppWidgetEvent(this.mAppWidgetId, this.mDurationMs, this.mPosition, Builder.toIntArray(this.mClickedIds), Builder.toIntArray(this.mScrolledIds));
        }

        private static void addAllUntilMax(@NonNull ArraySet<Integer> set, @Nullable int[] toAdd) {
            if (toAdd == null) {
                return;
            }
            for (int i = 0; i < toAdd.length && set.size() < 10; ++i) {
                set.add(toAdd[i]);
            }
        }

        @Nullable
        private static int[] toIntArray(@NonNull ArraySet<Integer> set) {
            if (set.isEmpty()) {
                return null;
            }
            int[] array2 = new int[set.size()];
            for (int i = 0; i < array2.length; ++i) {
                array2[i] = set.valueAt(i);
            }
            return array2;
        }
    }
}

