/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.SystemServiceRegistry;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.BluetoothServiceManager;
import java.util.function.Consumer;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class BluetoothFrameworkInitializer {
    private static volatile BluetoothServiceManager sBluetoothServiceManager;
    private static volatile Consumer<Context> sBinderCallsStatsInitializer;

    private BluetoothFrameworkInitializer() {
    }

    public static void setBluetoothServiceManager(@NonNull BluetoothServiceManager bluetoothServiceManager) {
        if (sBluetoothServiceManager != null) {
            throw new IllegalStateException("setBluetoothServiceManager called twice!");
        }
        if (bluetoothServiceManager == null) {
            throw new IllegalArgumentException("bluetoothServiceManager must not be null");
        }
        sBluetoothServiceManager = bluetoothServiceManager;
    }

    public static BluetoothServiceManager getBluetoothServiceManager() {
        return sBluetoothServiceManager;
    }

    public static void setBinderCallsStatsInitializer(@NonNull Consumer<Context> binderCallsStatsConsumer) {
        if (sBinderCallsStatsInitializer != null) {
            throw new IllegalStateException("setBinderCallsStatsInitializer called twice!");
        }
        if (binderCallsStatsConsumer == null) {
            throw new IllegalArgumentException("binderCallsStatsConsumer must not be null");
        }
        sBinderCallsStatsInitializer = binderCallsStatsConsumer;
    }

    public static void initializeBinderCallsStats(Context context) {
        if (sBinderCallsStatsInitializer == null) {
            throw new IllegalStateException("sBinderCallsStatsInitializer has not been set");
        }
        sBinderCallsStatsInitializer.accept(context);
    }

    public static void registerServiceWrappers() {
        SystemServiceRegistry.registerContextAwareService("bluetooth", BluetoothManager.class, context -> new BluetoothManager(context));
    }
}

