/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.bluetooth.BluetoothGattCharacteristic;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import java.util.UUID;

public class BluetoothGattDescriptor
implements Parcelable {
    public static final byte[] ENABLE_NOTIFICATION_VALUE = new byte[]{1, 0};
    public static final byte[] ENABLE_INDICATION_VALUE = new byte[]{2, 0};
    public static final byte[] DISABLE_NOTIFICATION_VALUE = new byte[]{0, 0};
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    protected UUID mUuid;
    @UnsupportedAppUsage
    protected int mInstance;
    protected int mPermissions;
    @UnsupportedAppUsage
    protected BluetoothGattCharacteristic mCharacteristic;
    protected byte[] mValue;
    @NonNull
    public static final Parcelable.Creator<BluetoothGattDescriptor> CREATOR = new Parcelable.Creator<BluetoothGattDescriptor>(){

        @Override
        public BluetoothGattDescriptor createFromParcel(Parcel in) {
            return new BluetoothGattDescriptor(in);
        }

        public BluetoothGattDescriptor[] newArray(int size) {
            return new BluetoothGattDescriptor[size];
        }
    };

    public BluetoothGattDescriptor(UUID uuid, int permissions) {
        this.initDescriptor(null, uuid, 0, permissions);
    }

    BluetoothGattDescriptor(BluetoothGattCharacteristic characteristic, UUID uuid, int instance, int permissions) {
        this.initDescriptor(characteristic, uuid, instance, permissions);
    }

    public BluetoothGattDescriptor(UUID uuid, int instance, int permissions) {
        this.initDescriptor(null, uuid, instance, permissions);
    }

    private void initDescriptor(BluetoothGattCharacteristic characteristic, UUID uuid, int instance, int permissions) {
        this.mCharacteristic = characteristic;
        this.mUuid = uuid;
        this.mInstance = instance;
        this.mPermissions = permissions;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        new ParcelUuid(this.mUuid).writeToParcel(out, flags);
        out.writeInt(this.mInstance);
        out.writeInt(this.mPermissions);
    }

    private BluetoothGattDescriptor(Parcel in) {
        this.mUuid = ParcelUuid.CREATOR.createFromParcel(in).getUuid();
        this.mInstance = in.readInt();
        this.mPermissions = in.readInt();
    }

    public BluetoothGattCharacteristic getCharacteristic() {
        return this.mCharacteristic;
    }

    @UnsupportedAppUsage
    void setCharacteristic(BluetoothGattCharacteristic characteristic) {
        this.mCharacteristic = characteristic;
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public int getInstanceId() {
        return this.mInstance;
    }

    public void setInstanceId(int instanceId) {
        this.mInstance = instanceId;
    }

    public int getPermissions() {
        return this.mPermissions;
    }

    @Deprecated
    public byte[] getValue() {
        return this.mValue;
    }

    @Deprecated
    public boolean setValue(byte[] value) {
        this.mValue = value;
        return true;
    }
}

