/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.bluetooth.jarjar.com.android.bluetooth.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class BluetoothLeAudioCodecConfig
implements Parcelable {
    public static final int SOURCE_CODEC_TYPE_LC3 = 0;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.leaudio_add_opus_codec_type")
    public static final int SOURCE_CODEC_TYPE_OPUS = 1;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.leaudio_add_opus_hi_res_codec_type_api")
    public static final int SOURCE_CODEC_TYPE_OPUS_HI_RES = 2;
    public static final int SOURCE_CODEC_TYPE_INVALID = 1000000;
    public static final int CODEC_PRIORITY_DISABLED = -1;
    public static final int CODEC_PRIORITY_DEFAULT = 0;
    public static final int CODEC_PRIORITY_HIGHEST = 1000000;
    public static final int SAMPLE_RATE_NONE = 0;
    public static final int SAMPLE_RATE_8000 = 1;
    public static final int SAMPLE_RATE_11025 = 2;
    public static final int SAMPLE_RATE_16000 = 4;
    public static final int SAMPLE_RATE_22050 = 8;
    public static final int SAMPLE_RATE_24000 = 16;
    public static final int SAMPLE_RATE_32000 = 32;
    public static final int SAMPLE_RATE_44100 = 64;
    public static final int SAMPLE_RATE_48000 = 128;
    public static final int SAMPLE_RATE_88200 = 256;
    public static final int SAMPLE_RATE_96000 = 512;
    public static final int SAMPLE_RATE_176400 = 1024;
    public static final int SAMPLE_RATE_192000 = 2048;
    public static final int SAMPLE_RATE_384000 = 4096;
    public static final int BITS_PER_SAMPLE_NONE = 0;
    public static final int BITS_PER_SAMPLE_16 = 1;
    public static final int BITS_PER_SAMPLE_24 = 2;
    public static final int BITS_PER_SAMPLE_32 = 8;
    public static final int CHANNEL_COUNT_NONE = 0;
    public static final int CHANNEL_COUNT_1 = 1;
    public static final int CHANNEL_COUNT_2 = 2;
    public static final int FRAME_DURATION_NONE = 0;
    public static final int FRAME_DURATION_7500 = 1;
    public static final int FRAME_DURATION_10000 = 2;
    public static final int FRAME_DURATION_20000 = 4;
    private final int mCodecType;
    private final int mCodecPriority;
    private final int mSampleRate;
    private final int mBitsPerSample;
    private final int mChannelCount;
    private final int mFrameDuration;
    private final int mOctetsPerFrame;
    private final int mMinOctetsPerFrame;
    private final int mMaxOctetsPerFrame;
    @NonNull
    public static final Parcelable.Creator<BluetoothLeAudioCodecConfig> CREATOR = new Parcelable.Creator<BluetoothLeAudioCodecConfig>(){

        @Override
        public BluetoothLeAudioCodecConfig createFromParcel(Parcel in) {
            int codecType = in.readInt();
            int codecPriority = in.readInt();
            int sampleRate = in.readInt();
            int bitsPerSample = in.readInt();
            int channelCount = in.readInt();
            int frameDuration = in.readInt();
            int octetsPerFrame = in.readInt();
            int minOctetsPerFrame = in.readInt();
            int maxOctetsPerFrame = in.readInt();
            return new BluetoothLeAudioCodecConfig(codecType, codecPriority, sampleRate, bitsPerSample, channelCount, frameDuration, octetsPerFrame, minOctetsPerFrame, maxOctetsPerFrame);
        }

        public BluetoothLeAudioCodecConfig[] newArray(int size) {
            return new BluetoothLeAudioCodecConfig[size];
        }
    };

    private BluetoothLeAudioCodecConfig(int codecType, int codecPriority, int sampleRate, int bitsPerSample, int channelCount, int frameDuration, int octetsPerFrame, int minOctetsPerFrame, int maxOctetsPerFrame) {
        this.mCodecType = codecType;
        this.mCodecPriority = codecPriority;
        this.mSampleRate = sampleRate;
        this.mBitsPerSample = bitsPerSample;
        this.mChannelCount = channelCount;
        this.mFrameDuration = frameDuration;
        this.mOctetsPerFrame = octetsPerFrame;
        this.mMinOctetsPerFrame = minOctetsPerFrame;
        this.mMaxOctetsPerFrame = maxOctetsPerFrame;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mCodecType);
        out.writeInt(this.mCodecPriority);
        out.writeInt(this.mSampleRate);
        out.writeInt(this.mBitsPerSample);
        out.writeInt(this.mChannelCount);
        out.writeInt(this.mFrameDuration);
        out.writeInt(this.mOctetsPerFrame);
        out.writeInt(this.mMinOctetsPerFrame);
        out.writeInt(this.mMaxOctetsPerFrame);
    }

    private static String sampleRateToString(int sampleRateBit) {
        String string2;
        switch (sampleRateBit) {
            case 0: {
                string2 = "None";
                break;
            }
            case 1: {
                string2 = "8 kHz";
                break;
            }
            case 2: {
                string2 = "11.025 kHz";
                break;
            }
            case 4: {
                string2 = "16 kHz";
                break;
            }
            case 8: {
                string2 = "22.05 kHz";
                break;
            }
            case 16: {
                string2 = "24 kHz";
                break;
            }
            case 32: {
                string2 = "32 kHz";
                break;
            }
            case 64: {
                string2 = "44.1 kHz";
                break;
            }
            case 128: {
                string2 = "48 kHz";
                break;
            }
            case 256: {
                string2 = "88.2 kHz";
                break;
            }
            case 512: {
                string2 = "96 kHz";
                break;
            }
            case 1024: {
                string2 = "176.4 kHz";
                break;
            }
            case 2048: {
                string2 = "192 kHz";
                break;
            }
            case 4096: {
                string2 = "384 kHz";
                break;
            }
            default: {
                string2 = "Unknown bit " + sampleRateBit;
            }
        }
        return string2;
    }

    private static String frameDurationToString(int frameDurationBit) {
        String string2;
        switch (frameDurationBit) {
            case 0: {
                string2 = "None";
                break;
            }
            case 1: {
                string2 = "7.5 ms";
                break;
            }
            case 2: {
                string2 = "10 ms";
                break;
            }
            case 4: {
                string2 = "20 ms";
                break;
            }
            default: {
                string2 = "Unknown bit " + frameDurationBit;
            }
        }
        return string2;
    }

    public String toString() {
        return "{codecName:" + this.getCodecName() + ",mCodecType:" + this.mCodecType + ",mCodecPriority:" + this.mCodecPriority + ",mSampleRate:" + BluetoothLeAudioCodecConfig.sampleRateToString(this.mSampleRate) + ",mBitsPerSample:" + this.mBitsPerSample + ",mChannelCountBitMask:" + this.mChannelCount + ",mFrameDuration:" + BluetoothLeAudioCodecConfig.frameDurationToString(this.mFrameDuration) + ",mOctetsPerFrame:" + this.mOctetsPerFrame + ",mMinOctetsPerFrame:" + this.mMinOctetsPerFrame + ",mMaxOctetsPerFrame:" + this.mMaxOctetsPerFrame + "}";
    }

    public int getCodecType() {
        return this.mCodecType;
    }

    @NonNull
    public String getCodecName() {
        switch (this.mCodecType) {
            case 0: {
                return "LC3";
            }
            case 1000000: {
                return "INVALID CODEC";
            }
        }
        if (Flags.leaudioAddOpusCodecType() && this.mCodecType == 1) {
            return "Opus";
        }
        if (Flags.leaudioAddOpusHiResCodecTypeApi() && this.mCodecType == 2) {
            return "Opus Hi-Res";
        }
        return "UNKNOWN CODEC(" + this.mCodecType + ")";
    }

    public int getCodecPriority() {
        return this.mCodecPriority;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getBitsPerSample() {
        return this.mBitsPerSample;
    }

    public int getChannelCount() {
        return this.mChannelCount;
    }

    public int getFrameDuration() {
        return this.mFrameDuration;
    }

    public int getOctetsPerFrame() {
        return this.mOctetsPerFrame;
    }

    public int getMinOctetsPerFrame() {
        return this.mMinOctetsPerFrame;
    }

    public int getMaxOctetsPerFrame() {
        return this.mMaxOctetsPerFrame;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof BluetoothLeAudioCodecConfig) {
            BluetoothLeAudioCodecConfig other = (BluetoothLeAudioCodecConfig)o;
            return other.getCodecType() == this.mCodecType && other.getCodecPriority() == this.mCodecPriority && other.getSampleRate() == this.mSampleRate && other.getBitsPerSample() == this.mBitsPerSample && other.getChannelCount() == this.mChannelCount && other.getFrameDuration() == this.mFrameDuration && other.getOctetsPerFrame() == this.mOctetsPerFrame && other.getMinOctetsPerFrame() == this.mMinOctetsPerFrame && other.getMaxOctetsPerFrame() == this.mMaxOctetsPerFrame;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mCodecType, this.mCodecPriority, this.mSampleRate, this.mBitsPerSample, this.mChannelCount, this.mFrameDuration, this.mOctetsPerFrame, this.mMinOctetsPerFrame, this.mMaxOctetsPerFrame);
    }

    public static class Builder {
        private int mCodecType = 1000000;
        private int mCodecPriority = 0;
        private int mSampleRate = 0;
        private int mBitsPerSample = 0;
        private int mChannelCount = 0;
        private int mFrameDuration = 0;
        private int mOctetsPerFrame = 0;
        private int mMinOctetsPerFrame = 0;
        private int mMaxOctetsPerFrame = 0;

        public Builder() {
        }

        public Builder(@NonNull BluetoothLeAudioCodecConfig config) {
            this.mCodecType = config.getCodecType();
            this.mCodecPriority = config.getCodecPriority();
            this.mSampleRate = config.getSampleRate();
            this.mBitsPerSample = config.getBitsPerSample();
            this.mChannelCount = config.getChannelCount();
            this.mFrameDuration = config.getFrameDuration();
            this.mOctetsPerFrame = config.getOctetsPerFrame();
            this.mMinOctetsPerFrame = config.getMinOctetsPerFrame();
            this.mMaxOctetsPerFrame = config.getMaxOctetsPerFrame();
        }

        @NonNull
        public Builder setCodecType(int codecType) {
            this.mCodecType = codecType;
            return this;
        }

        @NonNull
        public Builder setCodecPriority(int codecPriority) {
            this.mCodecPriority = codecPriority;
            return this;
        }

        @NonNull
        public Builder setSampleRate(int sampleRate) {
            this.mSampleRate = sampleRate;
            return this;
        }

        @NonNull
        public Builder setBitsPerSample(int bitsPerSample) {
            this.mBitsPerSample = bitsPerSample;
            return this;
        }

        @NonNull
        public Builder setChannelCount(int channelCount) {
            this.mChannelCount = channelCount;
            return this;
        }

        @NonNull
        public Builder setFrameDuration(int frameDuration) {
            this.mFrameDuration = frameDuration;
            return this;
        }

        @NonNull
        public Builder setOctetsPerFrame(int octetsPerFrame) {
            this.mOctetsPerFrame = octetsPerFrame;
            return this;
        }

        @NonNull
        public Builder setMinOctetsPerFrame(int minOctetsPerFrame) {
            this.mMinOctetsPerFrame = minOctetsPerFrame;
            return this;
        }

        @NonNull
        public Builder setMaxOctetsPerFrame(int maxOctetsPerFrame) {
            this.mMaxOctetsPerFrame = maxOctetsPerFrame;
            return this;
        }

        @NonNull
        public BluetoothLeAudioCodecConfig build() {
            return new BluetoothLeAudioCodecConfig(this.mCodecType, this.mCodecPriority, this.mSampleRate, this.mBitsPerSample, this.mChannelCount, this.mFrameDuration, this.mOctetsPerFrame, this.mMinOctetsPerFrame, this.mMaxOctetsPerFrame);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameDuration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelCount {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BitsPerSample {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SampleRate {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CodecPriority {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceCodecType {
    }
}

