/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public interface BluetoothProfile {
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_STATE = "android.bluetooth.profile.extra.STATE";
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.profile.extra.PREVIOUS_STATE";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.add_profile_as_intent_extra")
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_PROFILE = "android.bluetooth.profile.extra.PROFILE";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    public static final int HEADSET = 1;
    public static final int A2DP = 2;
    @Deprecated
    public static final int HEALTH = 3;
    @SystemApi
    public static final int HID_HOST = 4;
    @SystemApi
    public static final int PAN = 5;
    @SystemApi
    public static final int PBAP = 6;
    public static final int GATT = 7;
    public static final int GATT_SERVER = 8;
    @SystemApi
    public static final int MAP = 9;
    public static final int SAP = 10;
    @SystemApi
    public static final int A2DP_SINK = 11;
    @SystemApi
    public static final int AVRCP_CONTROLLER = 12;
    public static final int AVRCP = 13;
    @SystemApi
    public static final int HEADSET_CLIENT = 16;
    @SystemApi
    public static final int PBAP_CLIENT = 17;
    @SystemApi
    public static final int MAP_CLIENT = 18;
    public static final int HID_DEVICE = 19;
    @SystemApi
    public static final int OPP = 20;
    public static final int HEARING_AID = 21;
    public static final int LE_AUDIO = 22;
    @SystemApi
    public static final int VOLUME_CONTROL = 23;
    public static final int MCP_SERVER = 24;
    public static final int CSIP_SET_COORDINATOR = 25;
    @SystemApi
    public static final int LE_AUDIO_BROADCAST = 26;
    public static final int LE_CALL_CONTROL = 27;
    public static final int HAP_CLIENT = 28;
    @SystemApi
    public static final int LE_AUDIO_BROADCAST_ASSISTANT = 29;
    public static final int BATTERY = 30;
    public static final int GMAP = 31;
    public static final int MAX_PROFILE_ID = 31;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int PRIORITY_AUTO_CONNECT = 1000;
    @Deprecated
    @SystemApi
    public static final int PRIORITY_ON = 100;
    @Deprecated
    @SystemApi
    public static final int PRIORITY_OFF = 0;
    @UnsupportedAppUsage
    public static final int PRIORITY_UNDEFINED = -1;
    @SystemApi
    public static final int CONNECTION_POLICY_ALLOWED = 100;
    @SystemApi
    public static final int CONNECTION_POLICY_FORBIDDEN = 0;
    @SystemApi
    public static final int CONNECTION_POLICY_UNKNOWN = -1;

    public List<BluetoothDevice> getConnectedDevices();

    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] var1);

    public int getConnectionState(BluetoothDevice var1);

    public void onServiceConnected(IBinder var1);

    public void onServiceDisconnected();

    public BluetoothAdapter getAdapter();

    @SystemApi
    @NonNull
    @RequiresNoPermission
    public static String getConnectionStateName(int connectionState) {
        String string2;
        switch (connectionState) {
            case 0: {
                string2 = "STATE_DISCONNECTED";
                break;
            }
            case 1: {
                string2 = "STATE_CONNECTING";
                break;
            }
            case 2: {
                string2 = "STATE_CONNECTED";
                break;
            }
            case 3: {
                string2 = "STATE_DISCONNECTING";
                break;
            }
            default: {
                string2 = "STATE_UNKNOWN";
            }
        }
        return string2;
    }

    @SystemApi
    @NonNull
    @RequiresNoPermission
    public static String getProfileName(int profile) {
        String string2;
        switch (profile) {
            case 1: {
                string2 = "HEADSET";
                break;
            }
            case 2: {
                string2 = "A2DP";
                break;
            }
            case 4: {
                string2 = "HID_HOST";
                break;
            }
            case 5: {
                string2 = "PAN";
                break;
            }
            case 6: {
                string2 = "PBAP";
                break;
            }
            case 7: {
                string2 = "GATT";
                break;
            }
            case 8: {
                string2 = "GATT_SERVER";
                break;
            }
            case 9: {
                string2 = "MAP";
                break;
            }
            case 10: {
                string2 = "SAP";
                break;
            }
            case 11: {
                string2 = "A2DP_SINK";
                break;
            }
            case 12: {
                string2 = "AVRCP_CONTROLLER";
                break;
            }
            case 13: {
                string2 = "AVRCP";
                break;
            }
            case 16: {
                string2 = "HEADSET_CLIENT";
                break;
            }
            case 17: {
                string2 = "PBAP_CLIENT";
                break;
            }
            case 18: {
                string2 = "MAP_CLIENT";
                break;
            }
            case 19: {
                string2 = "HID_DEVICE";
                break;
            }
            case 20: {
                string2 = "OPP";
                break;
            }
            case 21: {
                string2 = "HEARING_AID";
                break;
            }
            case 22: {
                string2 = "LE_AUDIO";
                break;
            }
            case 23: {
                string2 = "VOLUME_CONTROL";
                break;
            }
            case 24: {
                string2 = "MCP_SERVER";
                break;
            }
            case 25: {
                string2 = "CSIP_SET_COORDINATOR";
                break;
            }
            case 26: {
                string2 = "LE_AUDIO_BROADCAST";
                break;
            }
            case 27: {
                string2 = "LE_CALL_CONTROL";
                break;
            }
            case 28: {
                string2 = "HAP_CLIENT";
                break;
            }
            case 29: {
                string2 = "LE_AUDIO_BROADCAST_ASSISTANT";
                break;
            }
            case 30: {
                string2 = "BATTERY";
                break;
            }
            default: {
                string2 = "UNKNOWN_PROFILE (" + profile + ")";
            }
        }
        return string2;
    }

    public static interface ServiceListener {
        @RequiresNoPermission
        public void onServiceConnected(int var1, BluetoothProfile var2);

        @RequiresNoPermission
        public void onServiceDisconnected(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionPolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BtProfileState {
    }
}

