/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
public class ActivityPolicyExemption
implements Parcelable {
    @Nullable
    private final ComponentName mComponentName;
    @Nullable
    private final String mPackageName;
    private final int mDisplayId;
    @NonNull
    public static final Parcelable.Creator<ActivityPolicyExemption> CREATOR = new Parcelable.Creator<ActivityPolicyExemption>(){

        @Override
        public ActivityPolicyExemption createFromParcel(Parcel in) {
            return new ActivityPolicyExemption(in);
        }

        public ActivityPolicyExemption[] newArray(int size) {
            return new ActivityPolicyExemption[size];
        }
    };

    private ActivityPolicyExemption(@Nullable ComponentName componentName, @Nullable String packageName, int displayId) {
        this.mComponentName = componentName;
        this.mPackageName = packageName;
        this.mDisplayId = displayId;
    }

    private ActivityPolicyExemption(@NonNull Parcel parcel) {
        this.mComponentName = parcel.readTypedObject(ComponentName.CREATOR);
        this.mPackageName = parcel.readString8();
        this.mDisplayId = parcel.readInt();
    }

    @Nullable
    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mComponentName, flags);
        dest.writeString8(this.mPackageName);
        dest.writeInt(this.mDisplayId);
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.activity_control_api")
    public static class Builder {
        @Nullable
        private ComponentName mComponentName;
        @Nullable
        private String mPackageName;
        private int mDisplayId = -1;

        @NonNull
        public Builder setComponentName(@NonNull ComponentName componentName) {
            this.mComponentName = Objects.requireNonNull(componentName);
            this.mPackageName = null;
            return this;
        }

        @NonNull
        public Builder setPackageName(@NonNull String packageName) {
            this.mComponentName = null;
            this.mPackageName = Objects.requireNonNull(packageName);
            return this;
        }

        @NonNull
        public Builder setDisplayId(int displayId) {
            this.mDisplayId = displayId;
            return this;
        }

        @NonNull
        public ActivityPolicyExemption build() {
            if (this.mComponentName == null == (this.mPackageName == null)) {
                throw new IllegalArgumentException("Either component name or package name must be set");
            }
            return new ActivityPolicyExemption(this.mComponentName, this.mPackageName, this.mDisplayId);
        }
    }
}

