/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.time.Duration;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.companion.virtualdevice.flags.viewconfiguration_apis")
public class ViewConfigurationParams
implements Parcelable {
    public static final int INVALID_VALUE = -1;
    private final float mTouchSlopDp;
    private final float mMinimumFlingVelocityDpPerSecond;
    private final float mMaximumFlingVelocityDpPerSecond;
    private final float mScrollFriction;
    private final int mTapTimeoutMillis;
    private final int mDoubleTapTimeoutMillis;
    private final int mDoubleTapMinTimeMillis;
    private final int mLongPressTimeoutMillis;
    private final int mMultiPressTimeoutMillis;
    @NonNull
    public static final Parcelable.Creator<ViewConfigurationParams> CREATOR = new Parcelable.Creator<ViewConfigurationParams>(){

        @Override
        public ViewConfigurationParams createFromParcel(Parcel in) {
            return new ViewConfigurationParams(in);
        }

        public ViewConfigurationParams[] newArray(int size) {
            return new ViewConfigurationParams[size];
        }
    };

    private ViewConfigurationParams(float touchSlopDp, float minimumFlingVelocityDpPerSecond, float maximumFlingVelocityDpPerSecond, float scrollFriction, int tapTimeoutMillis, int doubleTapTimeoutMillis, int doubleTapMinTimeMillis, int longPressTimeoutMillis, int multiPressTimeoutMillis) {
        this.mTouchSlopDp = touchSlopDp;
        this.mMinimumFlingVelocityDpPerSecond = minimumFlingVelocityDpPerSecond;
        this.mMaximumFlingVelocityDpPerSecond = maximumFlingVelocityDpPerSecond;
        this.mScrollFriction = scrollFriction;
        this.mTapTimeoutMillis = tapTimeoutMillis;
        this.mDoubleTapTimeoutMillis = doubleTapTimeoutMillis;
        this.mDoubleTapMinTimeMillis = doubleTapMinTimeMillis;
        this.mLongPressTimeoutMillis = longPressTimeoutMillis;
        this.mMultiPressTimeoutMillis = multiPressTimeoutMillis;
    }

    private ViewConfigurationParams(Parcel in) {
        this.mTouchSlopDp = in.readFloat();
        this.mMinimumFlingVelocityDpPerSecond = in.readFloat();
        this.mMaximumFlingVelocityDpPerSecond = in.readFloat();
        this.mScrollFriction = in.readFloat();
        this.mTapTimeoutMillis = in.readInt();
        this.mDoubleTapTimeoutMillis = in.readInt();
        this.mDoubleTapMinTimeMillis = in.readInt();
        this.mLongPressTimeoutMillis = in.readInt();
        this.mMultiPressTimeoutMillis = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeFloat(this.mTouchSlopDp);
        dest.writeFloat(this.mMinimumFlingVelocityDpPerSecond);
        dest.writeFloat(this.mMaximumFlingVelocityDpPerSecond);
        dest.writeFloat(this.mScrollFriction);
        dest.writeInt(this.mTapTimeoutMillis);
        dest.writeInt(this.mDoubleTapTimeoutMillis);
        dest.writeInt(this.mDoubleTapMinTimeMillis);
        dest.writeInt(this.mLongPressTimeoutMillis);
        dest.writeInt(this.mMultiPressTimeoutMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewConfigurationParams)) {
            return false;
        }
        ViewConfigurationParams that = (ViewConfigurationParams)o;
        return Float.compare(this.mTouchSlopDp, that.mTouchSlopDp) == 0 && Float.compare(this.mMinimumFlingVelocityDpPerSecond, that.mMinimumFlingVelocityDpPerSecond) == 0 && Float.compare(this.mMaximumFlingVelocityDpPerSecond, that.mMaximumFlingVelocityDpPerSecond) == 0 && Float.compare(this.mScrollFriction, that.mScrollFriction) == 0 && this.mTapTimeoutMillis == that.mTapTimeoutMillis && this.mDoubleTapTimeoutMillis == that.mDoubleTapTimeoutMillis && this.mDoubleTapMinTimeMillis == that.mDoubleTapMinTimeMillis && this.mLongPressTimeoutMillis == that.mLongPressTimeoutMillis && this.mMultiPressTimeoutMillis == that.mMultiPressTimeoutMillis;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mTouchSlopDp), Float.valueOf(this.mMinimumFlingVelocityDpPerSecond), Float.valueOf(this.mMaximumFlingVelocityDpPerSecond), Float.valueOf(this.mScrollFriction), this.mTapTimeoutMillis, this.mDoubleTapTimeoutMillis, this.mDoubleTapMinTimeMillis, this.mLongPressTimeoutMillis, this.mMultiPressTimeoutMillis);
    }

    @NonNull
    public String toString() {
        return "ViewConfigurationParams(mTouchSlopDp=" + this.mTouchSlopDp + ", mMinimumFlingVelocityDpPerSecond=" + this.mMinimumFlingVelocityDpPerSecond + ", mMaximumFlingVelocityDpPerSecond=" + this.mMaximumFlingVelocityDpPerSecond + ", mScrollFriction=" + this.mScrollFriction + ", mTapTimeoutMillis=" + this.mTapTimeoutMillis + ", mDoubleTapTimeoutMillis=" + this.mDoubleTapTimeoutMillis + ", mDoubleTapMinTimeMillis=" + this.mDoubleTapMinTimeMillis + ", mLongPressTimeoutMillis=" + this.mLongPressTimeoutMillis + ", mMultiPressTimeoutMillis=" + this.mMultiPressTimeoutMillis + ')';
    }

    public float getTouchSlopDp() {
        return this.mTouchSlopDp;
    }

    public float getMinimumFlingVelocityDpPerSecond() {
        return this.mMinimumFlingVelocityDpPerSecond;
    }

    public float getMaximumFlingVelocityDpPerSecond() {
        return this.mMaximumFlingVelocityDpPerSecond;
    }

    public float getScrollFriction() {
        return this.mScrollFriction;
    }

    @NonNull
    public Duration getTapTimeoutDuration() {
        return Duration.ofMillis(this.mTapTimeoutMillis);
    }

    @NonNull
    public Duration getDoubleTapTimeoutDuration() {
        return Duration.ofMillis(this.mDoubleTapTimeoutMillis);
    }

    @NonNull
    public Duration getDoubleTapMinTimeDuration() {
        return Duration.ofMillis(this.mDoubleTapMinTimeMillis);
    }

    @NonNull
    public Duration getLongPressTimeoutDuration() {
        return Duration.ofMillis(this.mLongPressTimeoutMillis);
    }

    @NonNull
    public Duration getMultiPressTimeoutDuration() {
        return Duration.ofMillis(this.mMultiPressTimeoutMillis);
    }

    @FlaggedApi(value="android.companion.virtualdevice.flags.viewconfiguration_apis")
    public static class Builder {
        private float mTouchSlopDp = -1.0f;
        private float mMinimumFlingVelocityDpPerSecond = -1.0f;
        private float mMaximumFlingVelocityDpPerSecond = -1.0f;
        private float mScrollFriction = -1.0f;
        private int mTapTimeoutMillis = -1;
        private int mDoubleTapTimeoutMillis = -1;
        private int mDoubleTapMinTimeMillis = -1;
        private int mLongPressTimeoutMillis = -1;
        private int mMultiPressTimeoutMillis = -1;

        @NonNull
        public Builder setTouchSlopDp(float touchSlopDp) {
            if (touchSlopDp < 0.0f) {
                throw new IllegalArgumentException("Touch slop cannot be negative");
            }
            this.mTouchSlopDp = touchSlopDp;
            return this;
        }

        @NonNull
        public Builder setMinimumFlingVelocityDpPerSecond(float minimumFlingVelocityDpPerSecond) {
            if (minimumFlingVelocityDpPerSecond < 0.0f) {
                throw new IllegalArgumentException("Minimum ling velocity cannot be negative");
            }
            this.mMinimumFlingVelocityDpPerSecond = minimumFlingVelocityDpPerSecond;
            return this;
        }

        @NonNull
        public Builder setMaximumFlingVelocityDpPerSecond(float maximumFlingVelocityDpPerSecond) {
            if (maximumFlingVelocityDpPerSecond < 0.0f) {
                throw new IllegalArgumentException("Maximum fling velocity cannot be negative");
            }
            this.mMaximumFlingVelocityDpPerSecond = maximumFlingVelocityDpPerSecond;
            return this;
        }

        @NonNull
        public Builder setScrollFriction(float scrollFriction) {
            if (scrollFriction < 0.0f) {
                throw new IllegalArgumentException("Scroll friction cannot be negative");
            }
            this.mScrollFriction = scrollFriction;
            return this;
        }

        @NonNull
        public Builder setTapTimeoutDuration(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Tap timeout cannot be negative");
            }
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Tap timeout cannot be larger than 2147483647");
            }
            this.mTapTimeoutMillis = (int)millis;
            return this;
        }

        @NonNull
        public Builder setDoubleTapTimeoutDuration(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Double tap timeout cannot be negative");
            }
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Double tap timeout cannot be larger than 2147483647");
            }
            this.mDoubleTapTimeoutMillis = (int)millis;
            return this;
        }

        @NonNull
        public Builder setDoubleTapMinTimeDuration(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Double tap min time cannot be negative");
            }
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Double tap min time cannot be larger than 2147483647");
            }
            this.mDoubleTapMinTimeMillis = (int)millis;
            return this;
        }

        @NonNull
        public Builder setLongPressTimeoutDuration(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Long press timeout cannot be negative");
            }
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Long press timeout cannot be larger than 2147483647");
            }
            this.mLongPressTimeoutMillis = (int)millis;
            return this;
        }

        @NonNull
        public Builder setMultiPressTimeoutDuration(@NonNull Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Multi press timeout cannot be negative");
            }
            long millis = duration.toMillis();
            if (millis > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Multi press timeout cannot be larger than 2147483647");
            }
            this.mMultiPressTimeoutMillis = (int)millis;
            return this;
        }

        @NonNull
        public ViewConfigurationParams build() {
            if (this.mTouchSlopDp == -1.0f && this.mMinimumFlingVelocityDpPerSecond == -1.0f && this.mMaximumFlingVelocityDpPerSecond == -1.0f && this.mScrollFriction == -1.0f && this.mTapTimeoutMillis == -1 && this.mDoubleTapTimeoutMillis == -1 && this.mDoubleTapMinTimeMillis == -1 && this.mLongPressTimeoutMillis == -1 && this.mMultiPressTimeoutMillis == -1) {
                throw new IllegalArgumentException("None of the parameters are set");
            }
            if (this.mMinimumFlingVelocityDpPerSecond != -1.0f && this.mMaximumFlingVelocityDpPerSecond != -1.0f && this.mMinimumFlingVelocityDpPerSecond > this.mMaximumFlingVelocityDpPerSecond) {
                throw new IllegalArgumentException("Minimum fling velocity cannot be greater than the maximum fling velocity");
            }
            return new ViewConfigurationParams(this.mTouchSlopDp, this.mMinimumFlingVelocityDpPerSecond, this.mMaximumFlingVelocityDpPerSecond, this.mScrollFriction, this.mTapTimeoutMillis, this.mDoubleTapTimeoutMillis, this.mDoubleTapMinTimeMillis, this.mLongPressTimeoutMillis, this.mMultiPressTimeoutMillis);
        }
    }
}

