/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.camera;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;

@SystemApi
public class VirtualCameraStreamConfig
implements Parcelable {
    static final int MAX_FPS_UPPER_LIMIT = 60;
    private final int mWidth;
    private final int mHeight;
    private final int mFormat;
    private final int mMaxFps;
    @NonNull
    public static final Parcelable.Creator<VirtualCameraStreamConfig> CREATOR = new Parcelable.Creator<VirtualCameraStreamConfig>(){

        @Override
        public VirtualCameraStreamConfig createFromParcel(Parcel in) {
            return new VirtualCameraStreamConfig(in);
        }

        public VirtualCameraStreamConfig[] newArray(int size) {
            return new VirtualCameraStreamConfig[size];
        }
    };

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public VirtualCameraStreamConfig(int width, int height, int format, int maxFps) {
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mMaxFps = maxFps;
    }

    private VirtualCameraStreamConfig(@NonNull Parcel in) {
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        this.mFormat = in.readInt();
        this.mMaxFps = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        dest.writeInt(this.mFormat);
        dest.writeInt(this.mMaxFps);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualCameraStreamConfig that = (VirtualCameraStreamConfig)o;
        return this.mWidth == that.mWidth && this.mHeight == that.mHeight && this.mFormat == that.mFormat && this.mMaxFps == that.mMaxFps;
    }

    public int hashCode() {
        return Objects.hash(this.mWidth, this.mHeight, this.mFormat, this.mMaxFps);
    }

    public int getFormat() {
        return this.mFormat;
    }

    public int getMaximumFramesPerSecond() {
        return this.mMaxFps;
    }
}

