/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.sensor.VirtualSensorAdditionalInfo;
import android.companion.virtual.sensor.VirtualSensorEvent;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags;

@SystemApi
public class VirtualSensor
implements Parcelable {
    private final int mHandle;
    private final int mType;
    private final String mName;
    private final int mFlags;
    private final IVirtualDevice mVirtualDevice;
    private final IBinder mToken;
    private final Object mAdditionalInfoLock = new Object();
    @NonNull
    public static final Parcelable.Creator<VirtualSensor> CREATOR = new Parcelable.Creator<VirtualSensor>(){

        @Override
        public VirtualSensor createFromParcel(Parcel in) {
            return new VirtualSensor(in);
        }

        public VirtualSensor[] newArray(int size) {
            return new VirtualSensor[size];
        }
    };

    public VirtualSensor(int handle, int type, String name, IVirtualDevice virtualDevice, IBinder token) {
        this(handle, type, name, 0, virtualDevice, token);
    }

    public VirtualSensor(int handle, int type, String name, int flags, IVirtualDevice virtualDevice, IBinder token) {
        this.mHandle = handle;
        this.mType = type;
        this.mName = name;
        this.mFlags = flags;
        this.mVirtualDevice = virtualDevice;
        this.mToken = token;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public VirtualSensor(int handle, int type, @NonNull String name) {
        this(handle, type, name, 0, null, null);
    }

    private VirtualSensor(Parcel parcel) {
        this.mHandle = parcel.readInt();
        this.mType = parcel.readInt();
        this.mName = parcel.readString8();
        this.mFlags = parcel.readInt();
        this.mVirtualDevice = IVirtualDevice.Stub.asInterface(parcel.readStrongBinder());
        this.mToken = parcel.readStrongBinder();
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getHandle() {
        return this.mHandle;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    public int getDeviceId() {
        try {
            return this.mVirtualDevice.getDeviceId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mHandle);
        parcel.writeInt(this.mType);
        parcel.writeString8(this.mName);
        parcel.writeInt(this.mFlags);
        parcel.writeStrongBinder(this.mVirtualDevice.asBinder());
        parcel.writeStrongBinder(this.mToken);
    }

    public String toString() {
        return "VirtualSensor{ mType=" + this.mType + ", mName='" + this.mName + "' }";
    }

    public void sendEvent(@NonNull VirtualSensorEvent event) {
        try {
            this.mVirtualDevice.sendSensorEvent(this.mToken, event);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.companion.virtualdevice.flags.virtual_sensor_additional_info")
    public void sendAdditionalInfo(@NonNull VirtualSensorAdditionalInfo info) {
        if (!Flags.virtualSensorAdditionalInfo()) {
            throw new UnsupportedOperationException("Sensor additional info not supported.");
        }
        if ((this.mFlags & 0x40) == 0) {
            throw new UnsupportedOperationException("Sensor additional info not supported.");
        }
        try {
            Object object = this.mAdditionalInfoLock;
            synchronized (object) {
                this.mVirtualDevice.sendSensorAdditionalInfo(this.mToken, info);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

