/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;

@SystemApi
public class VirtualSensorEvent
implements Parcelable {
    @NonNull
    private float[] mValues;
    private long mTimestampNanos;
    @NonNull
    public static final Parcelable.Creator<VirtualSensorEvent> CREATOR = new Parcelable.Creator<VirtualSensorEvent>(){

        @Override
        public VirtualSensorEvent createFromParcel(Parcel source) {
            return new VirtualSensorEvent(source);
        }

        public VirtualSensorEvent[] newArray(int size) {
            return new VirtualSensorEvent[size];
        }
    };

    private VirtualSensorEvent(@NonNull float[] values, long timestampNanos) {
        this.mValues = values;
        this.mTimestampNanos = timestampNanos;
    }

    private VirtualSensorEvent(@NonNull Parcel parcel) {
        int valuesLength = parcel.readInt();
        this.mValues = new float[valuesLength];
        parcel.readFloatArray(this.mValues);
        this.mTimestampNanos = parcel.readLong();
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeInt(this.mValues.length);
        parcel.writeFloatArray(this.mValues);
        parcel.writeLong(this.mTimestampNanos);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public float[] getValues() {
        return this.mValues;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public static class Builder {
        @NonNull
        private float[] mValues;
        private long mTimestampNanos = 0L;

        public Builder(@NonNull float[] values) {
            this.mValues = values;
        }

        @NonNull
        public VirtualSensorEvent build() {
            if (this.mValues == null || this.mValues.length == 0) {
                throw new IllegalArgumentException("Cannot build virtual sensor event with no values.");
            }
            if (this.mTimestampNanos <= 0L) {
                this.mTimestampNanos = SystemClock.elapsedRealtimeNanos();
            }
            return new VirtualSensorEvent(this.mValues, this.mTimestampNanos);
        }

        @NonNull
        public Builder setTimestampNanos(long timestampNanos) {
            this.mTimestampNanos = timestampNanos;
            return this;
        }
    }
}

