/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.AppGlobals;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.ParcelFileDescriptor;
import android.os.RemoteCallback;
import android.os.RemoteException;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public interface IContentProvider
extends IInterface {
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static final String descriptor = "android.content.IContentProvider";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int QUERY_TRANSACTION = 1;
    public static final int GET_TYPE_TRANSACTION = 2;
    public static final int INSERT_TRANSACTION = 3;
    public static final int DELETE_TRANSACTION = 4;
    public static final int UPDATE_TRANSACTION = 10;
    public static final int BULK_INSERT_TRANSACTION = 13;
    public static final int OPEN_FILE_TRANSACTION = 14;
    public static final int OPEN_ASSET_FILE_TRANSACTION = 15;
    public static final int APPLY_BATCH_TRANSACTION = 20;
    public static final int CALL_TRANSACTION = 21;
    public static final int GET_STREAM_TYPES_TRANSACTION = 22;
    public static final int OPEN_TYPED_ASSET_FILE_TRANSACTION = 23;
    public static final int CREATE_CANCELATION_SIGNAL_TRANSACTION = 24;
    public static final int CANONICALIZE_TRANSACTION = 25;
    public static final int UNCANONICALIZE_TRANSACTION = 26;
    public static final int REFRESH_TRANSACTION = 27;
    public static final int CHECK_URI_PERMISSION_TRANSACTION = 28;
    public static final int GET_TYPE_ASYNC_TRANSACTION = 29;
    public static final int CANONICALIZE_ASYNC_TRANSACTION = 30;
    public static final int UNCANONICALIZE_ASYNC_TRANSACTION = 31;
    public static final int GET_TYPE_ANONYMOUS_ASYNC_TRANSACTION = 32;

    public Cursor query(@NonNull AttributionSource var1, Uri var2, @Nullable String[] var3, @Nullable Bundle var4, @Nullable ICancellationSignal var5) throws RemoteException;

    public String getType(@NonNull AttributionSource var1, Uri var2) throws RemoteException;

    public void getTypeAsync(@NonNull AttributionSource var1, Uri var2, RemoteCallback var3) throws RemoteException;

    @Deprecated
    default public String getType(Uri url) throws RemoteException {
        return this.getType(new AttributionSource(Binder.getCallingUid(), AppGlobals.getPackageManager().getPackagesForUid(Binder.getCallingUid())[0], null), url);
    }

    @Deprecated
    default public void getTypeAsync(Uri uri, RemoteCallback callback) throws RemoteException {
        this.getTypeAsync(new AttributionSource(Binder.getCallingUid(), AppGlobals.getPackageManager().getPackagesForUid(Binder.getCallingUid())[0], null), uri, callback);
    }

    public void getTypeAnonymousAsync(Uri var1, RemoteCallback var2) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link ContentProviderClient#insert(android.net.Uri, android.content.ContentValues)} instead")
    default public Uri insert(String callingPkg, Uri url, ContentValues initialValues) throws RemoteException {
        return this.insert(new AttributionSource(Binder.getCallingUid(), callingPkg, null), url, initialValues, null);
    }

    public Uri insert(@NonNull AttributionSource var1, Uri var2, ContentValues var3, Bundle var4) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link ContentProviderClient#bulkInsert(android.net.Uri, android.content.ContentValues[])} instead")
    default public int bulkInsert(String callingPkg, Uri url, ContentValues[] initialValues) throws RemoteException {
        return this.bulkInsert(new AttributionSource(Binder.getCallingUid(), callingPkg, null), url, initialValues);
    }

    public int bulkInsert(@NonNull AttributionSource var1, Uri var2, ContentValues[] var3) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link ContentProviderClient#delete(android.net.Uri, java.lang.String, java.lang.String[])} instead")
    default public int delete(String callingPkg, Uri url, String selection, String[] selectionArgs) throws RemoteException {
        return this.delete(new AttributionSource(Binder.getCallingUid(), callingPkg, null), url, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    public int delete(@NonNull AttributionSource var1, Uri var2, Bundle var3) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link ContentProviderClient#update(android.net.Uri, android.content.ContentValues, java.lang.String, java.lang.String[])} instead")
    default public int update(String callingPkg, Uri url, ContentValues values, String selection, String[] selectionArgs) throws RemoteException {
        return this.update(new AttributionSource(Binder.getCallingUid(), callingPkg, null), url, values, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    public int update(@NonNull AttributionSource var1, Uri var2, ContentValues var3, Bundle var4) throws RemoteException;

    public ParcelFileDescriptor openFile(@NonNull AttributionSource var1, Uri var2, String var3, ICancellationSignal var4) throws RemoteException, FileNotFoundException;

    public AssetFileDescriptor openAssetFile(@NonNull AttributionSource var1, Uri var2, String var3, ICancellationSignal var4) throws RemoteException, FileNotFoundException;

    public ContentProviderResult[] applyBatch(@NonNull AttributionSource var1, String var2, ArrayList<ContentProviderOperation> var3) throws RemoteException, OperationApplicationException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=29, publicAlternatives="Use {@link ContentProviderClient#call(java.lang.String, java.lang.String, android.os.Bundle)} instead")
    default public Bundle call(String callingPkg, String method, @Nullable String arg, @Nullable Bundle extras) throws RemoteException {
        return this.call(new AttributionSource(Binder.getCallingUid(), callingPkg, null), "unknown", method, arg, extras);
    }

    public Bundle call(@NonNull AttributionSource var1, String var2, String var3, @Nullable String var4, @Nullable Bundle var5) throws RemoteException;

    public int checkUriPermission(@NonNull AttributionSource var1, Uri var2, int var3, int var4) throws RemoteException;

    public ICancellationSignal createCancellationSignal() throws RemoteException;

    public Uri canonicalize(@NonNull AttributionSource var1, Uri var2) throws RemoteException;

    public void canonicalizeAsync(@NonNull AttributionSource var1, Uri var2, RemoteCallback var3) throws RemoteException;

    public Uri uncanonicalize(@NonNull AttributionSource var1, Uri var2) throws RemoteException;

    public void uncanonicalizeAsync(@NonNull AttributionSource var1, Uri var2, RemoteCallback var3) throws RemoteException;

    public boolean refresh(@NonNull AttributionSource var1, Uri var2, @Nullable Bundle var3, ICancellationSignal var4) throws RemoteException;

    @Deprecated
    default public String[] getStreamTypes(Uri url, String mimeTypeFilter) throws RemoteException {
        return this.getStreamTypes(new AttributionSource(Binder.getCallingUid(), AppGlobals.getPackageManager().getPackagesForUid(Binder.getCallingUid())[0], null), url, mimeTypeFilter);
    }

    public String[] getStreamTypes(AttributionSource var1, Uri var2, String var3) throws RemoteException;

    public AssetFileDescriptor openTypedAssetFile(@NonNull AttributionSource var1, Uri var2, String var3, Bundle var4, ICancellationSignal var5) throws RemoteException, FileNotFoundException;
}

