/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.AndroidException;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.concurrent.Executor;

public class IntentSender
implements Parcelable {
    private static final long REMOVE_HIDDEN_SEND_INTENT_METHOD = 356174596L;
    private static final long COVER_INTENT_SENDER = 405995292L;
    private static final Bundle SEND_INTENT_DEFAULT_OPTIONS = ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(-1).toBundle();
    @UnsupportedAppUsage
    private final IIntentSender mTarget;
    IBinder mWhitelistToken;
    @Nullable
    private ActivityManager.PendingIntentInfo mCachedInfo;
    @NonNull
    public static final Parcelable.Creator<IntentSender> CREATOR = new Parcelable.Creator<IntentSender>(){

        @Override
        public IntentSender createFromParcel(Parcel in) {
            IBinder target = in.readStrongBinder();
            return target != null ? new IntentSender(target) : null;
        }

        public IntentSender[] newArray(int size) {
            return new IntentSender[size];
        }
    };

    public void sendIntent(Context context, int code, Intent intent, OnFinished onFinished, Handler handler) throws SendIntentException {
        this.sendIntent(context, code, intent, null, this.getSendIntentDefaultOptions(), handler == null ? null : handler::post, onFinished);
    }

    public void sendIntent(Context context, int code, Intent intent, OnFinished onFinished, Handler handler, String requiredPermission) throws SendIntentException {
        this.sendIntent(context, code, intent, requiredPermission, this.getSendIntentDefaultOptions(), handler == null ? null : handler::post, onFinished);
    }

    private Bundle getSendIntentDefaultOptions() {
        if (!Flags.balCoverIntentSender()) {
            return SEND_INTENT_DEFAULT_OPTIONS;
        }
        if (!CompatChanges.isChangeEnabled(405995292L)) {
            return SEND_INTENT_DEFAULT_OPTIONS;
        }
        return null;
    }

    @Deprecated
    public void sendIntent(Context context, int code, Intent intent, OnFinished onFinished, Handler handler, String requiredPermission, @Nullable Bundle options) throws SendIntentException {
        if (CompatChanges.isChangeEnabled(356174596L)) {
            throw new NoSuchMethodError("This overload of sendIntent was removed.");
        }
        this.sendIntent(context, code, intent, requiredPermission, options, handler == null ? null : handler::post, onFinished);
    }

    @FlaggedApi(value="com.android.window.flags.bal_send_intent_with_options")
    public void sendIntent(@Nullable Context context, int code, @Nullable Intent intent, @Nullable String requiredPermission, @Nullable Bundle options, @Nullable Executor executor, @Nullable OnFinished onFinished) throws SendIntentException {
        try {
            if (intent != null) {
                intent.collectExtraIntentKeys();
            }
            String resolvedType = intent != null ? intent.resolveTypeIfNeeded(context.getContentResolver()) : null;
            ActivityThread.ApplicationThread app = ActivityThread.currentActivityThread().getApplicationThread();
            int res = ActivityManager.getService().sendIntentSender(app, this.mTarget, this.mWhitelistToken, code, intent, resolvedType, onFinished != null ? new FinishedDispatcher(this, onFinished, executor) : null, requiredPermission, options);
            if (res < 0) {
                throw new SendIntentException();
            }
        }
        catch (RemoteException e) {
            throw new SendIntentException();
        }
    }

    @Deprecated
    public String getTargetPackage() {
        return this.getCreatorPackage();
    }

    public String getCreatorPackage() {
        return this.getCachedInfo().getCreatorPackage();
    }

    public int getCreatorUid() {
        return this.getCachedInfo().getCreatorUid();
    }

    public UserHandle getCreatorUserHandle() {
        int uid = this.getCachedInfo().getCreatorUid();
        return uid > 0 ? new UserHandle(UserHandle.getUserId(uid)) : null;
    }

    public boolean equals(@Nullable Object otherObj) {
        if (otherObj instanceof IntentSender) {
            return this.mTarget.asBinder().equals(((IntentSender)otherObj).mTarget.asBinder());
        }
        return false;
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("IntentSender{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(": ");
        sb.append(this.mTarget != null ? this.mTarget.asBinder() : null);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeStrongBinder(this.mTarget.asBinder());
    }

    public static void writeIntentSenderOrNullToParcel(IntentSender sender, Parcel out) {
        out.writeStrongBinder(sender != null ? sender.mTarget.asBinder() : null);
    }

    public static IntentSender readIntentSenderOrNullFromParcel(Parcel in) {
        IBinder b = in.readStrongBinder();
        return b != null ? new IntentSender(b) : null;
    }

    @UnsupportedAppUsage
    public IIntentSender getTarget() {
        return this.mTarget;
    }

    public IBinder getWhitelistToken() {
        return this.mWhitelistToken;
    }

    @UnsupportedAppUsage
    public IntentSender(IIntentSender target) {
        this.mTarget = target;
    }

    public IntentSender(IIntentSender target, IBinder allowlistToken) {
        this.mTarget = target;
        this.mWhitelistToken = allowlistToken;
    }

    public IntentSender(IBinder target) {
        this.mTarget = IIntentSender.Stub.asInterface(target);
    }

    private ActivityManager.PendingIntentInfo getCachedInfo() {
        if (this.mCachedInfo == null) {
            try {
                this.mCachedInfo = ActivityManager.getService().getInfoForIntentSender(this.mTarget);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return this.mCachedInfo;
    }

    public boolean isImmutable() {
        return this.getCachedInfo().isImmutable();
    }

    public static interface OnFinished {
        public void onSendFinished(IntentSender var1, Intent var2, int var3, String var4, Bundle var5);
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final IntentSender mIntentSender;
        private final OnFinished mWho;
        private final Executor mExecutor;
        private Intent mIntent;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;

        FinishedDispatcher(IntentSender pi, OnFinished who, Executor executor) {
            this.mIntentSender = pi;
            this.mWho = who;
            this.mExecutor = executor;
        }

        @Override
        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean serialized, boolean sticky, int sendingUser) {
            this.mIntent = intent;
            this.mResultCode = resultCode;
            this.mResultData = data;
            this.mResultExtras = extras;
            if (this.mExecutor == null) {
                this.run();
            } else {
                this.mExecutor.execute(this);
            }
        }

        @Override
        public void run() {
            this.mWho.onSendFinished(this.mIntentSender, this.mIntent, this.mResultCode, this.mResultData, this.mResultExtras);
        }
    }

    public static class SendIntentException
    extends AndroidException {
        public SendIntentException() {
        }

        public SendIntentException(String name) {
            super(name);
        }

        public SendIntentException(Exception cause) {
            super(cause);
        }
    }
}

