/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.UriRelativeFilterParcel;
import android.net.Uri;
import android.os.Parcel;
import android.os.PatternMatcher;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.AnnotationValidations;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
public class UriRelativeFilter {
    private static final String FILTER_STR = "filter";
    private static final String PART_STR = "part";
    private static final String PATTERN_STR = "pattern";
    static final String URI_RELATIVE_FILTER_STR = "uriRelativeFilter";
    public static final int PATH = 0;
    public static final int QUERY = 1;
    public static final int FRAGMENT = 2;
    private final int mUriPart;
    private final int mPatternType;
    private final String mFilter;

    public UriRelativeFilter(int uriPart, int patternType, @NonNull String filter) {
        this.mUriPart = uriPart;
        AnnotationValidations.validate(UriPart.class, null, this.mUriPart);
        this.mPatternType = patternType;
        AnnotationValidations.validate(PatternMatcher.PatternType.class, null, this.mPatternType);
        this.mFilter = filter;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mFilter);
    }

    public int getUriPart() {
        return this.mUriPart;
    }

    public int getPatternType() {
        return this.mPatternType;
    }

    @NonNull
    public String getFilter() {
        return this.mFilter;
    }

    public boolean matchData(@NonNull Uri data) {
        PatternMatcher pe = new PatternMatcher(this.mFilter, this.mPatternType);
        switch (this.getUriPart()) {
            case 0: {
                return pe.match(data.getPath());
            }
            case 1: {
                return this.matchQuery(pe, data.getQuery());
            }
            case 2: {
                return pe.match(data.getFragment());
            }
        }
        return false;
    }

    private boolean matchQuery(PatternMatcher pe, String query) {
        if (query != null) {
            String[] params = query.split("&");
            if (params.length == 1) {
                params = query.split(";");
            }
            for (int i = 0; i < params.length; ++i) {
                if (!pe.match(params[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, this.mUriPart);
        proto.write(1120986464258L, this.mPatternType);
        proto.write(1138166333443L, this.mFilter);
        proto.end(token);
    }

    public void writeToXml(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, URI_RELATIVE_FILTER_STR);
        serializer.attribute(null, PATTERN_STR, Integer.toString(this.mPatternType));
        serializer.attribute(null, PART_STR, Integer.toString(this.mUriPart));
        serializer.attribute(null, FILTER_STR, this.mFilter);
        serializer.endTag(null, URI_RELATIVE_FILTER_STR);
    }

    private String uriPartToString() {
        switch (this.mUriPart) {
            case 0: {
                return "PATH";
            }
            case 1: {
                return "QUERY";
            }
            case 2: {
                return "FRAGMENT";
            }
        }
        return "UNKNOWN";
    }

    private String patternTypeToString() {
        switch (this.mPatternType) {
            case 0: {
                return "LITERAL";
            }
            case 1: {
                return "PREFIX";
            }
            case 2: {
                return "GLOB";
            }
            case 3: {
                return "ADVANCED_GLOB";
            }
            case 4: {
                return "SUFFIX";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "UriRelativeFilter { uriPart = " + this.uriPartToString() + ", patternType = " + this.patternTypeToString() + ", filter = " + this.mFilter + " }";
    }

    public UriRelativeFilterParcel toParcel() {
        UriRelativeFilterParcel parcel = new UriRelativeFilterParcel();
        parcel.uriPart = this.mUriPart;
        parcel.patternType = this.mPatternType;
        parcel.filter = this.mFilter;
        return parcel;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriRelativeFilter that = (UriRelativeFilter)o;
        return this.mUriPart == that.mUriPart && this.mPatternType == that.mPatternType && Objects.equals(this.mFilter, that.mFilter);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mUriPart;
        _hash = 31 * _hash + this.mPatternType;
        _hash = 31 * _hash + Objects.hashCode(this.mFilter);
        return _hash;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mUriPart);
        dest.writeInt(this.mPatternType);
        dest.writeString(this.mFilter);
    }

    UriRelativeFilter(@NonNull Parcel in) {
        this.mUriPart = in.readInt();
        this.mPatternType = in.readInt();
        this.mFilter = in.readString();
    }

    public UriRelativeFilter(XmlPullParser parser) throws XmlPullParserException, IOException {
        this.mUriPart = Integer.parseInt(parser.getAttributeValue(null, PART_STR));
        this.mPatternType = Integer.parseInt(parser.getAttributeValue(null, PATTERN_STR));
        this.mFilter = parser.getAttributeValue(null, FILTER_STR);
    }

    public UriRelativeFilter(UriRelativeFilterParcel parcel) {
        this.mUriPart = parcel.uriPart;
        this.mPatternType = parcel.patternType;
        this.mFilter = parcel.filter;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UriPart {
    }
}

