/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.UriRelativeFilter;
import android.content.UriRelativeFilterGroupParcel;
import android.content.UriRelativeFilterParcel;
import android.net.Uri;
import android.os.Parcel;
import android.util.ArraySet;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@FlaggedApi(value="android.content.pm.relative_reference_intent_filters")
public class UriRelativeFilterGroup {
    private static final String TAG = "UriRelativeFilterGroup";
    private static final String ALLOW_STR = "allow";
    private static final String URI_RELATIVE_FILTER_GROUP_STR = "uriRelativeFilterGroup";
    public static final int ACTION_ALLOW = 0;
    public static final int ACTION_BLOCK = 1;
    private final int mAction;
    private final ArraySet<UriRelativeFilter> mUriRelativeFilters = new ArraySet();

    public static boolean matchGroupsToUri(List<UriRelativeFilterGroup> groups, Uri uri) {
        for (int i = 0; i < groups.size(); ++i) {
            if (!groups.get(i).matchData(uri)) continue;
            return groups.get(i).getAction() == 0;
        }
        return false;
    }

    public static List<UriRelativeFilterGroup> parcelsToGroups(@Nullable List<UriRelativeFilterGroupParcel> parcels) {
        ArrayList<UriRelativeFilterGroup> groups = new ArrayList<UriRelativeFilterGroup>();
        if (parcels != null) {
            for (int i = 0; i < parcels.size(); ++i) {
                groups.add(new UriRelativeFilterGroup(parcels.get(i)));
            }
        }
        return groups;
    }

    public static List<UriRelativeFilterGroupParcel> groupsToParcels(@Nullable List<UriRelativeFilterGroup> groups) {
        ArrayList<UriRelativeFilterGroupParcel> parcels = new ArrayList<UriRelativeFilterGroupParcel>();
        if (groups != null) {
            for (int i = 0; i < groups.size(); ++i) {
                parcels.add(groups.get(i).toParcel());
            }
        }
        return parcels;
    }

    public UriRelativeFilterGroup(int action) {
        this.mAction = action;
    }

    public UriRelativeFilterGroup(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        this.mAction = Integer.parseInt(parser.getAttributeValue(null, ALLOW_STR));
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("uriRelativeFilter")) {
                this.addUriRelativeFilter(new UriRelativeFilter(parser));
            } else {
                Log.w("IntentFilter", "Unknown tag parsing IntentFilter: " + tagName);
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public void addUriRelativeFilter(@NonNull UriRelativeFilter uriRelativeFilter) {
        Objects.requireNonNull(uriRelativeFilter);
        if (!CollectionUtils.contains(this.mUriRelativeFilters, uriRelativeFilter)) {
            this.mUriRelativeFilters.add(uriRelativeFilter);
        }
    }

    @NonNull
    public Collection<UriRelativeFilter> getUriRelativeFilters() {
        return Collections.unmodifiableCollection(this.mUriRelativeFilters);
    }

    public boolean matchData(@NonNull Uri data) {
        if (this.mUriRelativeFilters.size() == 0) {
            return false;
        }
        for (UriRelativeFilter filter : this.mUriRelativeFilters) {
            if (filter.matchData(data)) continue;
            return false;
        }
        return true;
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10E00000001L, this.mAction);
        Iterator<UriRelativeFilter> it = this.mUriRelativeFilters.iterator();
        while (it.hasNext()) {
            it.next().dumpDebug(proto, 0x20B00000002L);
        }
        proto.end(token);
    }

    public void writeToXml(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, URI_RELATIVE_FILTER_GROUP_STR);
        serializer.attribute(null, ALLOW_STR, Integer.toString(this.mAction));
        for (UriRelativeFilter filter : this.mUriRelativeFilters) {
            filter.writeToXml(serializer);
        }
        serializer.endTag(null, URI_RELATIVE_FILTER_GROUP_STR);
    }

    public String toString() {
        return "UriRelativeFilterGroup { allow = " + this.mAction + ", uri_filters = " + this.mUriRelativeFilters + ",  }";
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAction);
        int n = this.mUriRelativeFilters.size();
        if (n > 0) {
            dest.writeInt(n);
            int i = 0;
            Iterator<UriRelativeFilter> it = this.mUriRelativeFilters.iterator();
            while (it.hasNext()) {
                it.next().writeToParcel(dest, flags);
                ++i;
            }
            if (i != n) {
                Log.e(TAG, "UriRelativeFilters was unexpectedly modified while writing to parcel. Expected " + n + " but found " + i + " filters", new Exception());
            }
        } else {
            dest.writeInt(0);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriRelativeFilterGroup that = (UriRelativeFilterGroup)o;
        if (this.mAction != that.mAction) {
            return false;
        }
        return this.mUriRelativeFilters.equals(that.mUriRelativeFilters);
    }

    public int hashCode() {
        int _hash = 0;
        _hash = 31 * _hash + this.mAction;
        _hash = 31 * _hash + Objects.hashCode(this.mUriRelativeFilters);
        return _hash;
    }

    public UriRelativeFilterGroupParcel toParcel() {
        UriRelativeFilterGroupParcel parcel = new UriRelativeFilterGroupParcel();
        parcel.action = this.mAction;
        parcel.filters = new ArrayList<UriRelativeFilterParcel>();
        for (UriRelativeFilter filter : this.mUriRelativeFilters) {
            parcel.filters.add(filter.toParcel());
        }
        return parcel;
    }

    UriRelativeFilterGroup(@NonNull Parcel src) {
        this.mAction = src.readInt();
        int n = src.readInt();
        for (int i = 0; i < n; ++i) {
            this.mUriRelativeFilters.add(new UriRelativeFilter(src));
        }
    }

    public UriRelativeFilterGroup(UriRelativeFilterGroupParcel parcel) {
        this.mAction = parcel.action;
        for (int i = 0; i < parcel.filters.size(); ++i) {
            this.mUriRelativeFilters.add(new UriRelativeFilter(parcel.filters.get(i)));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
    }
}

