/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Person;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import android.content.ComponentName;
import android.content.Intent;
import android.content.LocusId;
import android.content.pm.AppSearchShortcutPerson;
import android.content.pm.ShortcutInfo;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AppSearchShortcutInfo
extends GenericDocument {
    public static final long SHORTCUT_TTL = TimeUnit.DAYS.toMillis(90L);
    public static final String SCHEMA_TYPE = "Shortcut";
    public static final int SCHEMA_VERSION = 3;
    public static final String KEY_ACTIVITY = "activity";
    public static final String KEY_SHORT_LABEL = "shortLabel";
    public static final String KEY_LONG_LABEL = "longLabel";
    public static final String KEY_DISABLED_MESSAGE = "disabledMessage";
    public static final String KEY_CATEGORIES = "categories";
    public static final String KEY_INTENTS = "intents";
    public static final String KEY_INTENT_PERSISTABLE_EXTRAS = "intentPersistableExtras";
    public static final String KEY_PERSON = "person";
    public static final String KEY_LOCUS_ID = "locusId";
    public static final String KEY_EXTRAS = "extras";
    public static final String KEY_FLAGS = "flags";
    public static final String KEY_ICON_RES_ID = "iconResId";
    public static final String KEY_ICON_RES_NAME = "iconResName";
    public static final String KEY_ICON_URI = "iconUri";
    public static final String KEY_DISABLED_REASON = "disabledReason";
    public static final String KEY_CAPABILITY = "capability";
    public static final String KEY_CAPABILITY_BINDINGS = "capabilityBindings";
    public static final AppSearchSchema SCHEMA = new AppSearchSchema.Builder("Shortcut").addProperty(new AppSearchSchema.StringPropertyConfig.Builder("activity").setCardinality(2).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("shortLabel").setCardinality(2).setTokenizerType(1).setIndexingType(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("longLabel").setCardinality(2).setTokenizerType(1).setIndexingType(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("disabledMessage").setCardinality(2).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("categories").setCardinality(1).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("intents").setCardinality(1).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.BytesPropertyConfig.Builder("intentPersistableExtras").setCardinality(1).build()).addProperty(new AppSearchSchema.DocumentPropertyConfig.Builder("person", "ShortcutPerson").setCardinality(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("locusId").setCardinality(2).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.BytesPropertyConfig.Builder("extras").setCardinality(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("flags").setCardinality(1).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.LongPropertyConfig.Builder("iconResId").setCardinality(2).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("iconResName").setCardinality(2).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("iconUri").setCardinality(2).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("disabledReason").setCardinality(3).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("capability").setCardinality(1).setTokenizerType(1).setIndexingType(1).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("capabilityBindings").setCardinality(1).setTokenizerType(1).setIndexingType(2).build()).build();
    public static final String IS_DYNAMIC = "Dyn";
    public static final String NOT_DYNAMIC = "nDyn";
    public static final String IS_MANIFEST = "Man";
    public static final String NOT_MANIFEST = "nMan";
    public static final String IS_DISABLED = "Dis";
    public static final String NOT_DISABLED = "nDis";
    public static final String IS_IMMUTABLE = "Im";
    public static final String NOT_IMMUTABLE = "nIm";

    public AppSearchShortcutInfo(@NonNull GenericDocument document) {
        super(document);
    }

    @NonNull
    public static AppSearchShortcutInfo instance(@NonNull ShortcutInfo shortcutInfo) {
        Objects.requireNonNull(shortcutInfo);
        return ((Builder)((Builder)new Builder(shortcutInfo.getPackage(), shortcutInfo.getId()).setActivity(shortcutInfo.getActivity()).setShortLabel(shortcutInfo.getShortLabel()).setLongLabel(shortcutInfo.getLongLabel()).setDisabledMessage(shortcutInfo.getDisabledMessage()).setCategories(shortcutInfo.getCategories()).setIntents(shortcutInfo.getIntents()).setExtras(shortcutInfo.getExtras()).setCreationTimestampMillis(shortcutInfo.getLastChangedTimestamp())).setFlags(shortcutInfo.getFlags()).setIconResId(shortcutInfo.getIconResourceId()).setIconResName(shortcutInfo.getIconResName()).setIconUri(shortcutInfo.getIconUri()).setDisabledReason(shortcutInfo.getDisabledReason()).setPersons(shortcutInfo.getPersons()).setLocusId(shortcutInfo.getLocusId()).setCapabilityBindings(shortcutInfo.getCapabilityBindingsInternal()).setTtlMillis(SHORTCUT_TTL)).build();
    }

    @NonNull
    public ShortcutInfo toShortcutInfo(int userId) {
        Bundle[] intentExtrases;
        String packageName = this.getNamespace();
        String activityString = this.getPropertyString(KEY_ACTIVITY);
        ComponentName activity = activityString == null ? null : ComponentName.unflattenFromString(activityString);
        Icon icon = null;
        String shortLabel = this.getPropertyString(KEY_SHORT_LABEL);
        String longLabel = this.getPropertyString(KEY_LONG_LABEL);
        String disabledMessage = this.getPropertyString(KEY_DISABLED_MESSAGE);
        String[] categories = this.getPropertyStringArray(KEY_CATEGORIES);
        ArraySet<String> categoriesSet = categories == null ? null : new ArraySet<String>(Arrays.asList(categories));
        String[] intentsStrings = this.getPropertyStringArray(KEY_INTENTS);
        Intent[] intents = intentsStrings == null ? new Intent[]{} : (Intent[])Arrays.stream(intentsStrings).map(uri -> {
            if (TextUtils.isEmpty(uri)) {
                return new Intent("android.intent.action.VIEW");
            }
            try {
                return Intent.parseUri(uri, 0);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }).toArray(Intent[]::new);
        byte[][] intentExtrasesBytes = this.getPropertyBytesArray(KEY_INTENT_PERSISTABLE_EXTRAS);
        Bundle[] bundleArray = intentExtrases = intentExtrasesBytes == null ? null : (Bundle[])Arrays.stream(intentExtrasesBytes).map(this::transformToBundle).toArray(Bundle[]::new);
        if (intents != null) {
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null || intentExtrases == null || intentExtrases.length <= i || intentExtrases[i] == null || intentExtrases[i].size() == 0) continue;
                intent.replaceExtras(intentExtrases[i]);
            }
        }
        Person[] persons = AppSearchShortcutInfo.parsePerson(this.getPropertyDocumentArray(KEY_PERSON));
        String locusIdString = this.getPropertyString(KEY_LOCUS_ID);
        LocusId locusId = locusIdString == null ? null : new LocusId(locusIdString);
        byte[] extrasByte = this.getPropertyBytes(KEY_EXTRAS);
        PersistableBundle extras = this.transformToPersistableBundle(extrasByte);
        int flags = AppSearchShortcutInfo.parseFlags(this.getPropertyStringArray(KEY_FLAGS));
        int iconResId = (int)this.getPropertyLong(KEY_ICON_RES_ID);
        String iconResName = this.getPropertyString(KEY_ICON_RES_NAME);
        String iconUri = this.getPropertyString(KEY_ICON_URI);
        String disabledReasonString = this.getPropertyString(KEY_DISABLED_REASON);
        int disabledReason = !TextUtils.isEmpty(disabledReasonString) ? Integer.parseInt(this.getPropertyString(KEY_DISABLED_REASON)) : 0;
        Map<String, Map<String, List<String>>> capabilityBindings = AppSearchShortcutInfo.parseCapabilityBindings(this.getPropertyStringArray(KEY_CAPABILITY_BINDINGS));
        return new ShortcutInfo(userId, this.getId(), packageName, activity, icon, shortLabel, 0, null, longLabel, 0, null, disabledMessage, 0, null, categoriesSet, intents, Integer.MAX_VALUE, extras, this.getCreationTimestampMillis(), flags, iconResId, iconResName, null, iconUri, disabledReason, persons, locusId, null, capabilityBindings);
    }

    @NonNull
    public static List<GenericDocument> toGenericDocuments(@NonNull Collection<ShortcutInfo> shortcuts) {
        ArrayList<GenericDocument> docs = new ArrayList<GenericDocument>(shortcuts.size());
        for (ShortcutInfo si : shortcuts) {
            docs.add(AppSearchShortcutInfo.instance(si));
        }
        return docs;
    }

    @Nullable
    private static byte[] transformToByteArray(@NonNull PersistableBundle extras) {
        byte[] byArray;
        Objects.requireNonNull(extras);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new PersistableBundle(extras).writeToStream(baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    @Nullable
    private Bundle transformToBundle(@Nullable byte[] extras) {
        Bundle bundle;
        if (extras == null) {
            return null;
        }
        Objects.requireNonNull(extras);
        ByteArrayInputStream bais = new ByteArrayInputStream(extras);
        try {
            Bundle ret = new Bundle();
            ret.putAll(PersistableBundle.readFromStream(bais));
            bundle = ret;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        bais.close();
        return bundle;
    }

    @Nullable
    private PersistableBundle transformToPersistableBundle(@Nullable byte[] extras) {
        PersistableBundle persistableBundle;
        if (extras == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(extras);
        try {
            persistableBundle = PersistableBundle.readFromStream(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        bais.close();
        return persistableBundle;
    }

    private static String[] flattenFlags(int flags) {
        ArrayList<String> flattenedFlags = new ArrayList<String>();
        for (int i = 0; i < 31; ++i) {
            int mask = 1 << i;
            String value = AppSearchShortcutInfo.flagToString(flags, mask);
            if (value == null) continue;
            flattenedFlags.add(value);
        }
        return flattenedFlags.toArray(new String[0]);
    }

    @Nullable
    private static String flagToString(int flags, int mask) {
        switch (mask) {
            case 1: {
                return (flags & mask) != 0 ? IS_DYNAMIC : NOT_DYNAMIC;
            }
            case 32: {
                return (flags & mask) != 0 ? IS_MANIFEST : NOT_MANIFEST;
            }
            case 64: {
                return (flags & mask) != 0 ? IS_DISABLED : NOT_DISABLED;
            }
            case 256: {
                return (flags & mask) != 0 ? IS_IMMUTABLE : NOT_IMMUTABLE;
            }
        }
        return null;
    }

    private static int parseFlags(@Nullable String[] flags) {
        if (flags == null) {
            return 0;
        }
        int ret = 0;
        for (int i = 0; i < flags.length; ++i) {
            ret |= AppSearchShortcutInfo.parseFlag(flags[i]);
        }
        return ret;
    }

    private static int parseFlag(String value) {
        switch (value) {
            case "Dyn": {
                return 1;
            }
            case "Man": {
                return 32;
            }
            case "Dis": {
                return 64;
            }
            case "Im": {
                return 256;
            }
        }
        return 0;
    }

    @NonNull
    private static Person[] parsePerson(@Nullable GenericDocument[] persons) {
        if (persons == null) {
            return new Person[0];
        }
        Person[] ret = new Person[persons.length];
        for (int i = 0; i < persons.length; ++i) {
            GenericDocument document = persons[i];
            if (document == null) continue;
            AppSearchShortcutPerson person = new AppSearchShortcutPerson(document);
            ret[i] = person.toPerson();
        }
        return ret;
    }

    @Nullable
    private static Map<String, Map<String, List<String>>> parseCapabilityBindings(@Nullable String[] capabilityBindings) {
        if (capabilityBindings == null || capabilityBindings.length == 0) {
            return null;
        }
        ArrayMap<String, Map<String, List<String>>> ret = new ArrayMap<String, Map<String, List<String>>>(1);
        Arrays.stream(capabilityBindings).forEach(binding -> {
            Map params;
            if (TextUtils.isEmpty(binding)) {
                return;
            }
            int capabilityStopIndex = binding.indexOf("/");
            if (capabilityStopIndex == -1 || capabilityStopIndex == binding.length() - 1) {
                return;
            }
            String capabilityName = binding.substring(0, capabilityStopIndex);
            int paramStopIndex = binding.indexOf("/", capabilityStopIndex + 1);
            if (paramStopIndex == -1 || paramStopIndex == binding.length() - 1) {
                return;
            }
            String paramName = binding.substring(capabilityStopIndex + 1, paramStopIndex);
            String paramValue = binding.substring(paramStopIndex + 1);
            if (!ret.containsKey(capabilityName)) {
                ret.put(capabilityName, new ArrayMap(1));
            }
            if (!(params = (Map)ret.get(capabilityName)).containsKey(paramName)) {
                params.put(paramName, new ArrayList(1));
            }
            ((List)params.get(paramName)).add(paramValue);
        });
        return ret;
    }

    @VisibleForTesting
    public static class Builder
    extends GenericDocument.Builder<Builder> {
        private final List<String> mFlags = new ArrayList<String>(1);

        public Builder(String packageName, String id2) {
            super(packageName, id2, AppSearchShortcutInfo.SCHEMA_TYPE);
        }

        @NonNull
        public Builder setLocusId(@Nullable LocusId locusId) {
            if (locusId != null) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_LOCUS_ID, locusId.getId());
            }
            return this;
        }

        @NonNull
        public Builder setActivity(@Nullable ComponentName activity) {
            if (activity != null) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_ACTIVITY, activity.flattenToShortString());
            }
            return this;
        }

        @NonNull
        public Builder setShortLabel(@Nullable CharSequence shortLabel) {
            if (!TextUtils.isEmpty(shortLabel)) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_SHORT_LABEL, Preconditions.checkStringNotEmpty(shortLabel, "shortLabel cannot be empty").toString());
            }
            return this;
        }

        @NonNull
        public Builder setLongLabel(@Nullable CharSequence longLabel) {
            if (!TextUtils.isEmpty(longLabel)) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_LONG_LABEL, Preconditions.checkStringNotEmpty(longLabel, "longLabel cannot be empty").toString());
            }
            return this;
        }

        @NonNull
        public Builder setDisabledMessage(@Nullable CharSequence disabledMessage) {
            if (!TextUtils.isEmpty(disabledMessage)) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_DISABLED_MESSAGE, Preconditions.checkStringNotEmpty(disabledMessage, "disabledMessage cannot be empty").toString());
            }
            return this;
        }

        @NonNull
        public Builder setCategories(@Nullable Set<String> categories) {
            if (categories != null && !categories.isEmpty()) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_CATEGORIES, (String[])categories.stream().toArray(String[]::new));
            }
            return this;
        }

        @NonNull
        public Builder setIntent(@Nullable Intent intent) {
            if (intent == null) {
                return this;
            }
            return this.setIntents(new Intent[]{intent});
        }

        @NonNull
        public Builder setIntents(@Nullable Intent[] intents) {
            if (intents == null || intents.length == 0) {
                return this;
            }
            for (Intent intent : intents) {
                Objects.requireNonNull(intent, "intents cannot contain null");
                Objects.requireNonNull(intent.getAction(), "intent's action must be set");
            }
            byte[][] intentExtrases = new byte[intents.length][];
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                Bundle extras = intent.getExtras();
                intentExtrases[i] = extras == null ? new byte[]{} : AppSearchShortcutInfo.transformToByteArray(new PersistableBundle(extras));
            }
            this.setPropertyString(AppSearchShortcutInfo.KEY_INTENTS, (String[])Arrays.stream(intents).map(it -> it.toUri(0)).toArray(String[]::new));
            this.setPropertyBytes(AppSearchShortcutInfo.KEY_INTENT_PERSISTABLE_EXTRAS, intentExtrases);
            return this;
        }

        @NonNull
        public Builder setPerson(@Nullable Person person) {
            if (person == null) {
                return this;
            }
            return this.setPersons(new Person[]{person});
        }

        @NonNull
        public Builder setPersons(@Nullable Person[] persons) {
            if (persons == null || persons.length == 0) {
                return this;
            }
            GenericDocument[] documents = new GenericDocument[persons.length];
            for (int i = 0; i < persons.length; ++i) {
                Person person = persons[i];
                if (person == null) continue;
                AppSearchShortcutPerson personEntity = AppSearchShortcutPerson.instance(person);
                documents[i] = personEntity;
            }
            this.setPropertyDocument(AppSearchShortcutInfo.KEY_PERSON, documents);
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable PersistableBundle extras) {
            if (extras != null) {
                this.setPropertyBytes(AppSearchShortcutInfo.KEY_EXTRAS, new byte[][]{AppSearchShortcutInfo.transformToByteArray(extras)});
            }
            return this;
        }

        public Builder setFlags(int flags) {
            String[] flagArray = AppSearchShortcutInfo.flattenFlags(flags);
            if (flagArray != null && flagArray.length > 0) {
                this.mFlags.addAll(Arrays.asList(flagArray));
            }
            return this;
        }

        @NonNull
        public Builder setIconResId(@Nullable int iconResId) {
            this.setPropertyLong(AppSearchShortcutInfo.KEY_ICON_RES_ID, iconResId);
            return this;
        }

        public Builder setIconResName(@Nullable String iconResName) {
            if (!TextUtils.isEmpty(iconResName)) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_ICON_RES_NAME, iconResName);
            }
            return this;
        }

        public Builder setIconUri(@Nullable String iconUri) {
            if (!TextUtils.isEmpty(iconUri)) {
                this.setPropertyString(AppSearchShortcutInfo.KEY_ICON_URI, iconUri);
            }
            return this;
        }

        public Builder setDisabledReason(int disabledReason) {
            this.setPropertyString(AppSearchShortcutInfo.KEY_DISABLED_REASON, String.valueOf(disabledReason));
            return this;
        }

        public Builder setCapabilityBindings(@Nullable Map<String, Map<String, List<String>>> bindings) {
            if (bindings != null && !bindings.isEmpty()) {
                Set<String> capabilityNames = bindings.keySet();
                ArraySet capabilityBindings = new ArraySet(1);
                for (String capabilityName : capabilityNames) {
                    Map<String, List<String>> params = bindings.get(capabilityName);
                    for (String paramName : params.keySet()) {
                        params.get(paramName).stream().map(v -> capabilityName + "/" + paramName + "/" + v).forEach(capabilityBindings::add);
                    }
                }
                this.setPropertyString(AppSearchShortcutInfo.KEY_CAPABILITY, capabilityNames.toArray(new String[0]));
                this.setPropertyString(AppSearchShortcutInfo.KEY_CAPABILITY_BINDINGS, capabilityBindings.toArray(new String[0]));
            }
            return this;
        }

        @Override
        @NonNull
        public AppSearchShortcutInfo build() {
            this.setPropertyString(AppSearchShortcutInfo.KEY_FLAGS, this.mFlags.toArray(new String[0]));
            return new AppSearchShortcutInfo(super.build());
        }
    }
}

