/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Person;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.GenericDocument;
import android.graphics.drawable.Icon;
import android.net.UriCodec;
import com.android.internal.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

public class AppSearchShortcutPerson
extends GenericDocument {
    public static final String SCHEMA_TYPE = "ShortcutPerson";
    private static final String KEY_NAME = "name";
    private static final String KEY_KEY = "key";
    private static final String KEY_IS_BOT = "isBot";
    private static final String KEY_IS_IMPORTANT = "isImportant";
    private static final String KEY_ICON = "icon";
    public static final AppSearchSchema SCHEMA = new AppSearchSchema.Builder("ShortcutPerson").addProperty(new AppSearchSchema.StringPropertyConfig.Builder("name").setCardinality(2).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.StringPropertyConfig.Builder("key").setCardinality(2).setTokenizerType(0).setIndexingType(0).build()).addProperty(new AppSearchSchema.BooleanPropertyConfig.Builder("isBot").setCardinality(3).build()).addProperty(new AppSearchSchema.BooleanPropertyConfig.Builder("isImportant").setCardinality(3).build()).addProperty(new AppSearchSchema.BytesPropertyConfig.Builder("icon").setCardinality(2).build()).build();

    public AppSearchShortcutPerson(@NonNull GenericDocument document) {
        super(document);
    }

    @NonNull
    public static AppSearchShortcutPerson instance(@NonNull Person person) {
        Objects.requireNonNull(person);
        String id2 = person.getUri() != null ? person.getUri() : ((Object)UUID.randomUUID()).toString();
        return new Builder(id2).setName(person.getName()).setKey(person.getKey()).setIsBot(person.isBot()).setIsImportant(person.isImportant()).setIcon(AppSearchShortcutPerson.transformToByteArray(person.getIcon())).build();
    }

    @NonNull
    public Person toPerson() {
        String uri;
        try {
            uri = UriCodec.decode(this.getId(), false, StandardCharsets.UTF_8, true);
        }
        catch (IllegalArgumentException e) {
            uri = null;
        }
        return new Person.Builder().setName(this.getPropertyString(KEY_NAME)).setUri(uri).setKey(this.getPropertyString(KEY_KEY)).setBot(this.getPropertyBoolean(KEY_IS_BOT)).setImportant(this.getPropertyBoolean(KEY_IS_IMPORTANT)).setIcon(this.transformToIcon(this.getPropertyBytes(KEY_ICON))).build();
    }

    @Nullable
    private static byte[] transformToByteArray(@Nullable Icon icon) {
        byte[] byArray;
        if (icon == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            icon.writeToStream(baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    @Nullable
    private Icon transformToIcon(@Nullable byte[] icon) {
        Icon icon2;
        if (icon == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(icon);
        try {
            icon2 = Icon.createFromStream(bais);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        bais.close();
        return icon2;
    }

    @VisibleForTesting
    public static class Builder
    extends GenericDocument.Builder<Builder> {
        public Builder(@NonNull String id2) {
            super("", id2, AppSearchShortcutPerson.SCHEMA_TYPE);
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            if (name != null) {
                this.setPropertyString(AppSearchShortcutPerson.KEY_NAME, name.toString());
            }
            return this;
        }

        @NonNull
        public Builder setKey(@Nullable String key) {
            if (key != null) {
                this.setPropertyString(AppSearchShortcutPerson.KEY_KEY, key);
            }
            return this;
        }

        @NonNull
        public Builder setIsBot(boolean isBot) {
            this.setPropertyBoolean(AppSearchShortcutPerson.KEY_IS_BOT, isBot);
            return this;
        }

        @NonNull
        public Builder setIsImportant(boolean isImportant) {
            this.setPropertyBoolean(AppSearchShortcutPerson.KEY_IS_IMPORTANT, isImportant);
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable byte[] icon) {
            if (icon != null) {
                this.setPropertyBytes(AppSearchShortcutPerson.KEY_ICON, new byte[][]{icon});
            }
            return this;
        }

        @Override
        @NonNull
        public AppSearchShortcutPerson build() {
            return new AppSearchShortcutPerson(super.build());
        }
    }
}

