/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.pm.ArchivedActivityParcel;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Slog;
import com.android.internal.util.AnnotationValidations;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;

@FlaggedApi(value="android.content.pm.archiving")
public class ArchivedActivityInfo {
    private static final String TAG = "ArchivedActivityInfo";
    @NonNull
    private CharSequence mLabel;
    @NonNull
    private ComponentName mComponentName;
    @Nullable
    private Drawable mIcon;
    @Nullable
    private Drawable mMonochromeIcon;

    public ArchivedActivityInfo(@NonNull CharSequence label, @NonNull ComponentName componentName) {
        Objects.requireNonNull(label);
        Objects.requireNonNull(componentName);
        this.mLabel = label;
        this.mComponentName = componentName;
    }

    ArchivedActivityInfo(@NonNull ArchivedActivityParcel parcel) {
        this.mLabel = parcel.title;
        this.mComponentName = parcel.originalComponentName;
        this.mIcon = ArchivedActivityInfo.drawableFromCompressedBitmap(parcel.iconBitmap);
        this.mMonochromeIcon = ArchivedActivityInfo.drawableFromCompressedBitmap(parcel.monochromeIconBitmap);
    }

    @NonNull
    ArchivedActivityParcel getParcel() {
        ArchivedActivityParcel parcel = new ArchivedActivityParcel();
        parcel.title = this.mLabel.toString();
        parcel.originalComponentName = this.mComponentName;
        parcel.iconBitmap = this.mIcon == null ? null : ArchivedActivityInfo.bytesFromBitmap(ArchivedActivityInfo.drawableToBitmap(this.mIcon));
        parcel.monochromeIconBitmap = this.mMonochromeIcon == null ? null : ArchivedActivityInfo.bytesFromBitmap(ArchivedActivityInfo.drawableToBitmap(this.mMonochromeIcon));
        return parcel;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        return ArchivedActivityInfo.drawableToBitmap(drawable2, 0);
    }

    public static Bitmap drawableToBitmap(Drawable drawable2, int iconSize) {
        Bitmap bitmap;
        if (drawable2 instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)drawable2).getBitmap();
        } else {
            bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888) : Bitmap.createBitmap(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
        }
        if (iconSize <= 0) {
            return bitmap;
        }
        if (bitmap.getWidth() < iconSize || bitmap.getHeight() < iconSize || bitmap.getWidth() > iconSize * 2 || bitmap.getHeight() > iconSize * 2) {
            Bitmap scaledBitmap = Bitmap.createScaledBitmap(bitmap, iconSize, iconSize, true);
            if (scaledBitmap != bitmap) {
                bitmap.recycle();
            }
            return scaledBitmap;
        }
        return bitmap;
    }

    public static byte[] bytesFromBitmap(Bitmap bitmap) {
        byte[] byArray;
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bitmap.getByteCount());
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to compress bitmap", e);
                return null;
            }
        }
        baos.close();
        return byArray;
    }

    private static Drawable drawableFromCompressedBitmap(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new BitmapDrawable(null, new ByteArrayInputStream(bytes));
    }

    @NonNull
    public CharSequence getLabel() {
        return this.mLabel;
    }

    @NonNull
    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    @Nullable
    public Drawable getIcon() {
        return this.mIcon;
    }

    @Nullable
    public Drawable getMonochromeIcon() {
        return this.mMonochromeIcon;
    }

    @NonNull
    public ArchivedActivityInfo setLabel(@NonNull CharSequence value) {
        this.mLabel = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mLabel);
        return this;
    }

    @NonNull
    public ArchivedActivityInfo setComponentName(@NonNull ComponentName value) {
        this.mComponentName = value;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mComponentName);
        return this;
    }

    @NonNull
    public ArchivedActivityInfo setIcon(@NonNull Drawable value) {
        this.mIcon = value;
        return this;
    }

    @NonNull
    public ArchivedActivityInfo setMonochromeIcon(@NonNull Drawable value) {
        this.mMonochromeIcon = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

