/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

abstract class BaseParceledListSlice<T>
implements Parcelable {
    private static final String TAG = "ParceledListSlice";
    private static final boolean DEBUG = false;
    private static final int MAX_IPC_SIZE = IBinder.getSuggestedMaxIpcSizeBytes();
    private static final int WARN_ELM_SIZE = MAX_IPC_SIZE / 4;
    private List<T> mList;
    private int mInlineCountLimit = Integer.MAX_VALUE;
    private boolean mHasBeenParceled = false;

    public BaseParceledListSlice(List<T> list) {
        this.mList = list;
    }

    BaseParceledListSlice(Parcel p, ClassLoader loader) {
        int i;
        int N2 = p.readInt();
        this.mList = new ArrayList<T>(N2);
        if (N2 <= 0) {
            return;
        }
        Parcelable.Creator<?> creator = this.readParcelableCreator(p, loader);
        Class<?> listElementClass = null;
        for (i = 0; i < N2 && p.readInt() != 0; ++i) {
            listElementClass = this.readVerifyAndAddElement(creator, p, loader, listElementClass);
        }
        if (i >= N2) {
            return;
        }
        IBinder retriever = p.readStrongBinder();
        while (i < N2) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            data.writeInt(i);
            try {
                retriever.transact(1, data, reply, 0);
                reply.readException();
                while (i < N2 && reply.readInt() != 0) {
                    listElementClass = this.readVerifyAndAddElement(creator, reply, loader, listElementClass);
                    ++i;
                }
            }
            catch (RemoteException e) {
                throw new BadParcelableException("Failure retrieving array; only received " + i + " of " + N2, e);
            }
            finally {
                reply.recycle();
                data.recycle();
            }
        }
    }

    private Class<?> readVerifyAndAddElement(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader, Class<?> listElementClass) {
        T parcelable = this.readCreator(creator, p, loader);
        if (listElementClass == null) {
            listElementClass = parcelable.getClass();
        } else {
            BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
        }
        this.mList.add(parcelable);
        return listElementClass;
    }

    private T readCreator(Parcelable.Creator<?> creator, Parcel p, ClassLoader loader) {
        if (creator instanceof Parcelable.ClassLoaderCreator) {
            Parcelable.ClassLoaderCreator classLoaderCreator = (Parcelable.ClassLoaderCreator)creator;
            return classLoaderCreator.createFromParcel(p, loader);
        }
        return (T)creator.createFromParcel(p);
    }

    private static void verifySameType(Class<?> expected, Class<?> actual) {
        if (!actual.equals(expected)) {
            throw new IllegalArgumentException("Can't unparcel type " + (actual == null ? null : actual.getName()) + " in list of type " + (expected == null ? null : expected.getName()));
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public List<T> getList() {
        return this.mList;
    }

    public void setInlineCountLimit(int maxCount) {
        this.mInlineCountLimit = maxCount;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mHasBeenParceled) {
            throw new IllegalStateException("Can't Parcel a ParceledListSlice more than once");
        }
        this.mHasBeenParceled = true;
        final int N2 = this.mList.size();
        final int callFlags = flags;
        dest.writeInt(N2);
        if (N2 > 0) {
            int i;
            final Class<?> listElementClass = this.mList.get(0).getClass();
            this.writeParcelableCreator(this.mList.get(0), dest);
            for (i = 0; i < N2 && i < this.mInlineCountLimit && dest.dataSize() < MAX_IPC_SIZE; ++i) {
                dest.writeInt(1);
                T parcelable = this.mList.get(i);
                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                this.writeElement(parcelable, dest, callFlags);
            }
            if (i < N2) {
                dest.writeInt(0);
                Binder retriever = new Binder(){

                    @Override
                    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        if (code != 1) {
                            return super.onTransact(code, data, reply, flags);
                        }
                        if (BaseParceledListSlice.this.mList == null) {
                            throw new IllegalArgumentException("Attempt to transfer null list, did transfer finish?");
                        }
                        try {
                            int i;
                            reply.writeNoException();
                            for (i = data.readInt(); i < N2 && reply.dataSize() < 65536; ++i) {
                                reply.writeInt(1);
                                int preWriteSize = reply.dataSize();
                                Object parcelable = BaseParceledListSlice.this.mList.get(i);
                                BaseParceledListSlice.verifySameType(listElementClass, parcelable.getClass());
                                BaseParceledListSlice.this.writeElement(parcelable, reply, callFlags);
                                int elmSize = reply.dataSize() - preWriteSize;
                                if (elmSize < WARN_ELM_SIZE) continue;
                                Log.w(BaseParceledListSlice.TAG, "Element #" + i + " is " + elmSize + " bytes.");
                            }
                            if (i < N2) {
                                reply.writeInt(0);
                            } else {
                                BaseParceledListSlice.this.mList = null;
                            }
                            if (reply.dataSize() >= 65536 + WARN_ELM_SIZE) {
                                Log.w(BaseParceledListSlice.TAG, "Overly large reply size: " + reply.dataSize());
                            }
                        }
                        catch (RuntimeException e) {
                            BaseParceledListSlice.this.mList = null;
                            throw e;
                        }
                        return true;
                    }
                };
                dest.writeStrongBinder(retriever);
            }
        }
    }

    protected abstract void writeElement(T var1, Parcel var2, int var3);

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    protected abstract void writeParcelableCreator(T var1, Parcel var2);

    protected abstract Parcelable.Creator<?> readParcelableCreator(Parcel var1, ClassLoader var2);
}

