/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CapabilityParams
implements Parcelable {
    @NonNull
    private final String mName;
    @NonNull
    private final String mPrimaryValue;
    @NonNull
    private final List<String> mAliases;
    @NonNull
    public static final Parcelable.Creator<CapabilityParams> CREATOR = new Parcelable.Creator<CapabilityParams>(){

        public CapabilityParams[] newArray(int size) {
            return new CapabilityParams[size];
        }

        @Override
        public CapabilityParams createFromParcel(@NonNull Parcel in) {
            return new CapabilityParams(in);
        }
    };

    private CapabilityParams(@NonNull String name, @NonNull String primaryValue, @Nullable Collection<String> aliases) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(primaryValue);
        this.mName = name;
        this.mPrimaryValue = primaryValue;
        this.mAliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(aliases));
    }

    CapabilityParams(@NonNull CapabilityParams orig) {
        this(orig.mName, orig.mPrimaryValue, orig.mAliases);
    }

    private CapabilityParams(@NonNull Builder builder) {
        this(builder.mKey, builder.mPrimaryValue, builder.mAliases);
    }

    private CapabilityParams(@NonNull Parcel in) {
        this.mName = in.readString();
        this.mPrimaryValue = in.readString();
        ArrayList<String> values = new ArrayList<String>();
        in.readStringList(values);
        this.mAliases = Collections.unmodifiableList(values);
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public String getValue() {
        return this.mPrimaryValue;
    }

    @NonNull
    public List<String> getAliases() {
        return new ArrayList<String>(this.mAliases);
    }

    @NonNull
    List<String> getValues() {
        if (this.mAliases == null) {
            return new ArrayList<String>(Collections.singletonList(this.mPrimaryValue));
        }
        ArrayList<String> ret = new ArrayList<String>(this.mAliases.size() + 1);
        ret.add(this.mPrimaryValue);
        ret.addAll(this.mAliases);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CapabilityParams)) {
            return false;
        }
        CapabilityParams target = (CapabilityParams)obj;
        return this.mName.equals(target.mName) && this.mPrimaryValue.equals(target.mPrimaryValue) && this.mAliases.equals(target.mAliases);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mPrimaryValue, this.mAliases);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mPrimaryValue);
        dest.writeStringList(this.mAliases);
    }

    public static class Builder {
        @NonNull
        private final String mKey;
        @NonNull
        private final String mPrimaryValue;
        @NonNull
        private Set<String> mAliases;

        public Builder(@NonNull String key, @NonNull String value) {
            Objects.requireNonNull(key);
            if (TextUtils.isEmpty(value)) {
                throw new IllegalArgumentException("Primary value cannot be empty or null");
            }
            this.mPrimaryValue = value;
            this.mKey = key;
        }

        @NonNull
        public Builder addAlias(@NonNull String alias) {
            if (this.mAliases == null) {
                this.mAliases = new ArraySet<String>(1);
            }
            this.mAliases.add(alias);
            return this;
        }

        @NonNull
        public CapabilityParams build() {
            return new CapabilityParams(this);
        }
    }
}

