/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.appwidget.AppWidgetProviderInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.LocusId;
import android.content.pm.AppLaunchInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.IPinItemRequest;
import android.content.pm.IShortcutChangeCallback;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherActivityInfoInternal;
import android.content.pm.LauncherUserInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutQueryWrapper;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import android.window.IDumpCallback;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.multiuser.Flags;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class LauncherApps {
    static final String TAG = "LauncherApps";
    static final boolean DEBUG = false;
    public static final String ACTION_CONFIRM_PIN_SHORTCUT = "android.content.pm.action.CONFIRM_PIN_SHORTCUT";
    public static final String ACTION_CONFIRM_PIN_APPWIDGET = "android.content.pm.action.CONFIRM_PIN_APPWIDGET";
    public static final String EXTRA_PIN_ITEM_REQUEST = "android.content.pm.extra.PIN_ITEM_REQUEST";
    public static final int FLAG_CACHE_NOTIFICATION_SHORTCUTS = 0;
    public static final int FLAG_CACHE_BUBBLE_SHORTCUTS = 1;
    public static final int FLAG_CACHE_PEOPLE_TILE_SHORTCUTS = 2;
    private static final String LAUNCHER_USER_INFO_EXTRA_KEY = "launcher_user_info";
    private final Context mContext;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final ILauncherApps mService;
    @UnsupportedAppUsage
    private final PackageManager mPm;
    private final UserManager mUserManager;
    private final List<CallbackMessageHandler> mCallbacks = new ArrayList<CallbackMessageHandler>();
    private final List<PackageInstaller.SessionCallbackDelegate> mDelegates = new ArrayList<PackageInstaller.SessionCallbackDelegate>();
    private final Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> mShortcutChangeCallbacks = new HashMap<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>>();
    private final IOnAppsChangedListener.Stub mAppsChangedListener = new IOnAppsChangedListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageRemoved(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageRemoved(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageChanged(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageChanged(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageAdded(UserHandle user, String packageName) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageAdded(packageName, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesAvailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesAvailable(packageNames, user, replacing);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesUnavailable(UserHandle user, String[] packageNames, boolean replacing) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesUnavailable(packageNames, user, replacing);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesSuspended(UserHandle user, String[] packageNames, Bundle launcherExtras) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesSuspended(packageNames, launcherExtras, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackagesUnsuspended(UserHandle user, String[] packageNames) throws RemoteException {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackagesUnsuspended(packageNames, user);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShortcutChanged(UserHandle user, String packageName, ParceledListSlice shortcuts) {
            List list = shortcuts.getList();
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnShortcutChanged(packageName, user, list);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnPackageLoadingProgressChanged(user, packageName, progress);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserConfigChanged(LauncherUserInfo launcherUserInfo) {
            LauncherApps launcherApps = LauncherApps.this;
            synchronized (launcherApps) {
                for (CallbackMessageHandler callback : LauncherApps.this.mCallbacks) {
                    callback.postOnUserConfigChanged(launcherUserInfo);
                }
            }
        }
    };

    public LauncherApps(Context context, ILauncherApps service) {
        this.mContext = context;
        this.mService = service;
        this.mPm = context.getPackageManager();
        this.mUserManager = context.getSystemService(UserManager.class);
    }

    public LauncherApps(Context context) {
        this(context, ILauncherApps.Stub.asInterface(ServiceManager.getService("launcherapps")));
    }

    private void logErrorForInvalidProfileAccess(@NonNull UserHandle target) {
        if (UserHandle.myUserId() != target.getIdentifier() && this.mUserManager.isManagedProfile() && this.mContext.checkSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            Log.w(TAG, "Accessing other profiles/users from managed profile is no longer allowed.");
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public List<UserHandle> getProfiles() {
        if (this.mUserManager.isManagedProfile() || Flags.enableLauncherAppsHiddenProfileChecks() && com.android.internal.hidden_from_bootclasspath.android.os.Flags.allowPrivateProfile() && Flags.enablePrivateSpaceFeatures() && this.mUserManager.isPrivateProfile()) {
            ArrayList<UserHandle> result = new ArrayList<UserHandle>(1);
            result.add(Process.myUserHandle());
            return result;
        }
        if (Flags.enableLauncherAppsHiddenProfileChecks()) {
            try {
                return this.mService.getUserProfiles();
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
        return this.mUserManager.getUserProfiles();
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public List<LauncherActivityInfo> getActivityList(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getLauncherActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.START_TASKS_FROM_RECENTS")
    @Nullable
    public PendingIntent getMainActivityLaunchIntent(@NonNull ComponentName component, @Nullable Bundle startActivityOptions, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getActivityLaunchIntent(this.mContext.getPackageName(), component, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Nullable
    @SuppressLint(value={"RequiresPermission"})
    @FlaggedApi(value="android.os.allow_private_profile")
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public LauncherUserInfo getLauncherUserInfo(@NonNull UserHandle userHandle) {
        try {
            return this.mService.getLauncherUserInfo(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Nullable
    @SuppressLint(value={"RequiresPermission"})
    @FlaggedApi(value="android.os.allow_private_profile")
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public IntentSender getAppMarketActivityIntent(@Nullable String packageName, @NonNull UserHandle user) {
        try {
            return this.mService.getAppMarketActivityIntent(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.os.allow_private_profile")
    @NonNull
    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public List<String> getPreInstalledSystemPackages(@NonNull UserHandle userHandle) {
        try {
            return this.mService.getPreInstalledSystemPackages(userHandle);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Nullable
    @FlaggedApi(value="android.os.get_private_space_settings")
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public IntentSender getPrivateSpaceSettingsIntent() {
        try {
            return this.mService.getPrivateSpaceSettingsIntent();
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            LauncherActivityInfoInternal ai = this.mService.resolveLauncherActivityInternal(this.mContext.getPackageName(), intent.getComponent(), user);
            if (ai == null) {
                return null;
            }
            return new LauncherActivityInfo(this.mContext, ai);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Map<String, LauncherActivityInfo> getActivityOverrides() {
        ArrayMap<String, LauncherActivityInfo> activityOverrides = new ArrayMap<String, LauncherActivityInfo>();
        try {
            Map<String, LauncherActivityInfoInternal> activityOverridesInternal = this.mService.getActivityOverrides(this.mContext.getPackageName(), this.mContext.getUserId());
            for (Map.Entry<String, LauncherActivityInfoInternal> packageToOverride : activityOverridesInternal.entrySet()) {
                activityOverrides.put(packageToOverride.getKey(), new LauncherActivityInfo(this.mContext, packageToOverride.getValue()));
            }
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
        return activityOverrides;
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public void startMainActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.startActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Map<ComponentName, Intent> getActivityLaunchIntentForAllApps(@NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            ParceledListSlice infos = this.mService.getActivityLaunchIntentForAllApps(this.mContext.getPackageName(), user);
            if (infos == null || infos.getList().isEmpty()) {
                return new HashMap<ComponentName, Intent>();
            }
            List appLaunchInfos = infos.getList();
            HashMap<ComponentName, Intent> convertedApps = new HashMap<ComponentName, Intent>(appLaunchInfos.size());
            for (AppLaunchInfo info : appLaunchInfos) {
                if (info.getComponentName() == null) continue;
                convertedApps.put(info.getComponentName(), info.getLaunchIntent());
            }
            return convertedApps;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ShortcutInfo> getAvailableShortcuts(@NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            ParceledListSlice shortcuts = this.mService.getAvailableShortcuts(this.mContext.getPackageName(), user);
            if (shortcuts == null || shortcuts.getList().isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return shortcuts.getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void startPackageInstallerSessionDetailsActivity(@NonNull PackageInstaller.SessionInfo sessionInfo, @Nullable Rect sourceBounds, @Nullable Bundle opts) {
        try {
            this.mService.startSessionDetailsActivityAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), sessionInfo, sourceBounds, opts, sessionInfo.getUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public void startAppDetailsActivity(ComponentName component, UserHandle user, Rect sourceBounds, Bundle opts) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.showAppDetailsAsUser(this.mContext.getIApplicationThread(), this.mContext.getPackageName(), this.mContext.getAttributionTag(), component, sourceBounds, opts, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @Nullable
    public PendingIntent getShortcutIntent(@NonNull String packageName, @NonNull String shortcutId, @Nullable Bundle opts, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getShortcutIntent(this.mContext.getPackageName(), packageName, shortcutId, null, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public List<LauncherActivityInfo> getShortcutConfigActivityList(@Nullable String packageName, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.convertToActivityList(this.mService.getShortcutConfigActivities(this.mContext.getPackageName(), packageName, user), user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private List<LauncherActivityInfo> convertToActivityList(@Nullable ParceledListSlice<LauncherActivityInfoInternal> internals, UserHandle user) {
        if (internals == null || internals.getList().isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> lais = new ArrayList<LauncherActivityInfo>();
        for (LauncherActivityInfoInternal internal : internals.getList()) {
            LauncherActivityInfo lai = new LauncherActivityInfo(this.mContext, internal);
            lais.add(lai);
        }
        return lais;
    }

    @Nullable
    public IntentSender getShortcutConfigActivityIntent(@NonNull LauncherActivityInfo info) {
        try {
            return this.mService.getShortcutConfigActivityIntent(this.mContext.getPackageName(), info.getComponentName(), info.getUser());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public boolean isPackageEnabled(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isPackageEnabled(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    @Nullable
    public Bundle getSuspendedPackageLauncherExtras(String packageName, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.getSuspendedPackageLauncherExtras(packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public boolean shouldHideFromSuggestions(@NonNull String packageName, @NonNull UserHandle user) {
        Objects.requireNonNull(packageName, "packageName");
        Objects.requireNonNull(user, "user");
        try {
            return this.mService.shouldHideFromSuggestions(packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public ApplicationInfo getApplicationInfo(@NonNull String packageName, int flags, @NonNull UserHandle user) throws PackageManager.NameNotFoundException {
        Objects.requireNonNull(packageName, "packageName");
        Objects.requireNonNull(user, "user");
        this.logErrorForInvalidProfileAccess(user);
        try {
            ApplicationInfo ai = this.mService.getApplicationInfo(this.mContext.getPackageName(), packageName, flags, user);
            if (ai == null) {
                throw new PackageManager.NameNotFoundException("Package " + packageName + " not found for user " + user.getIdentifier());
            }
            return ai;
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Nullable
    public AppUsageLimit getAppUsageLimit(@NonNull String packageName, @NonNull UserHandle user) {
        try {
            return this.mService.getAppUsageLimit(this.mContext.getPackageName(), packageName, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public boolean isActivityEnabled(ComponentName component, UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.mService.isActivityEnabled(this.mContext.getPackageName(), component, user);
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    public boolean hasShortcutHostPermission() {
        try {
            return this.mService.hasShortcutHostPermission(this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private List<ShortcutInfo> maybeUpdateDisabledMessage(List<ShortcutInfo> shortcuts) {
        if (shortcuts == null) {
            return null;
        }
        for (int i = shortcuts.size() - 1; i >= 0; --i) {
            ShortcutInfo si = shortcuts.get(i);
            String message = ShortcutInfo.getDisabledReasonForRestoreIssue(this.mContext, si.getDisabledReason());
            if (message == null) continue;
            si.setDisabledMessage(message);
        }
        return shortcuts;
    }

    @RequiresPermission(value="android.permission.READ_FRAME_BUFFER")
    public void registerDumpCallback(IDumpCallback cb) {
        try {
            this.mService.registerDumpCallback(cb);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_FRAME_BUFFER")
    public void saveViewCaptureData() {
        try {
            this.mService.saveViewCaptureData();
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(value="android.permission.READ_FRAME_BUFFER")
    public void unRegisterDumpCallback(IDumpCallback cb) {
        try {
            this.mService.unRegisterDumpCallback(cb);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    @Nullable
    public List<ShortcutInfo> getShortcuts(@NonNull ShortcutQuery query, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            return this.maybeUpdateDisabledMessage(this.mService.getShortcuts(this.mContext.getPackageName(), new ShortcutQueryWrapper(query), user).getList());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @Nullable
    public List<ShortcutInfo> getShortcutInfo(@NonNull String packageName, @NonNull List<String> ids, @NonNull UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(ids);
        q.setQueryFlags(27);
        return this.getShortcuts(q, user);
    }

    @RequiresPermission(conditional=true, value="android.permission.ACCESS_SHORTCUTS")
    public void pinShortcuts(@NonNull String packageName, @NonNull List<String> shortcutIds, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.pinShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
    public void cacheShortcuts(@NonNull String packageName, @NonNull List<String> shortcutIds, @NonNull UserHandle user, int cacheFlags) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.cacheShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user, cacheFlags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
    public void uncacheShortcuts(@NonNull String packageName, @NonNull List<String> shortcutIds, @NonNull UserHandle user, int cacheFlags) {
        this.logErrorForInvalidProfileAccess(user);
        try {
            this.mService.uncacheShortcuts(this.mContext.getPackageName(), packageName, shortcutIds, user, cacheFlags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public int getShortcutIconResId(@NonNull ShortcutInfo shortcut) {
        return shortcut.getIconResourceId();
    }

    @Deprecated
    public int getShortcutIconResId(@NonNull String packageName, @NonNull String shortcutId, @NonNull UserHandle user) {
        ShortcutQuery q = new ShortcutQuery();
        q.setPackage(packageName);
        q.setShortcutIds(Arrays.asList(shortcutId));
        q.setQueryFlags(27);
        List<ShortcutInfo> shortcuts = this.getShortcuts(q, user);
        return shortcuts.size() > 0 ? shortcuts.get(0).getIconResourceId() : 0;
    }

    public ParcelFileDescriptor getShortcutIconFd(@NonNull ShortcutInfo shortcut) {
        return this.getShortcutIconFd(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
    }

    public ParcelFileDescriptor getShortcutIconFd(@NonNull String packageName, @NonNull String shortcutId, @NonNull UserHandle user) {
        return this.getShortcutIconFd(packageName, shortcutId, user.getIdentifier());
    }

    private ParcelFileDescriptor getShortcutIconFd(@NonNull String packageName, @NonNull String shortcutId, int userId) {
        try {
            return this.mService.getShortcutIconFd(this.mContext.getPackageName(), packageName, shortcutId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @VisibleForTesting
    public ParcelFileDescriptor getUriShortcutIconFd(@NonNull ShortcutInfo shortcut) {
        return this.getUriShortcutIconFd(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
    }

    private ParcelFileDescriptor getUriShortcutIconFd(@NonNull String packageName, @NonNull String shortcutId, int userId) {
        String uri = this.getShortcutIconUri(packageName, shortcutId, userId);
        if (uri == null) {
            return null;
        }
        try {
            return this.mContext.getContentResolver().openFileDescriptor(Uri.parse(uri), "r");
        }
        catch (Exception e) {
            Log.e(TAG, "Failed to open icon file: " + uri, e);
            return null;
        }
    }

    private String getShortcutIconUri(@NonNull String packageName, @NonNull String shortcutId, int userId) {
        String uri = null;
        try {
            uri = this.mService.getShortcutIconUri(this.mContext.getPackageName(), packageName, shortcutId, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return uri;
    }

    public Drawable getShortcutIconDrawable(@NonNull ShortcutInfo shortcut, int density) {
        if (shortcut.hasIconFile()) {
            ParcelFileDescriptor pfd = this.getShortcutIconFd(shortcut);
            return this.loadDrawableFromFileDescriptor(pfd, shortcut.hasAdaptiveBitmap());
        }
        if (shortcut.hasIconUri()) {
            ParcelFileDescriptor pfd = this.getUriShortcutIconFd(shortcut);
            return this.loadDrawableFromFileDescriptor(pfd, shortcut.hasAdaptiveBitmap());
        }
        if (shortcut.hasIconResource()) {
            return this.loadDrawableResourceFromPackage(shortcut.getPackage(), shortcut.getIconResourceId(), shortcut.getUserHandle(), density);
        }
        if (shortcut.getIcon() != null) {
            Icon icon = shortcut.getIcon();
            switch (icon.getType()) {
                case 2: {
                    return this.loadDrawableResourceFromPackage(shortcut.getPackage(), icon.getResId(), shortcut.getUserHandle(), density);
                }
                case 1: 
                case 5: {
                    return icon.loadDrawable(this.mContext);
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Drawable loadDrawableFromFileDescriptor(ParcelFileDescriptor pfd, boolean adaptive) {
        if (pfd == null) {
            return null;
        }
        try {
            Bitmap bmp = BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor());
            if (bmp != null) {
                BitmapDrawable dr = new BitmapDrawable(this.mContext.getResources(), bmp);
                if (adaptive) {
                    AdaptiveIconDrawable adaptiveIconDrawable = new AdaptiveIconDrawable(null, dr);
                    return adaptiveIconDrawable;
                }
                BitmapDrawable bitmapDrawable = dr;
                return bitmapDrawable;
            }
            Drawable drawable2 = null;
            return drawable2;
        }
        finally {
            try {
                pfd.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Icon getShortcutIcon(@NonNull ShortcutInfo shortcut) {
        if (shortcut.hasIconFile()) {
            ParcelFileDescriptor pfd = this.getShortcutIconFd(shortcut);
            if (pfd == null) {
                return null;
            }
            try {
                Bitmap bmp = BitmapFactory.decodeFileDescriptor(pfd.getFileDescriptor());
                if (bmp != null) {
                    if (shortcut.hasAdaptiveBitmap()) {
                        Icon icon = Icon.createWithAdaptiveBitmap(bmp);
                        return icon;
                    }
                    Icon icon = Icon.createWithBitmap(bmp);
                    return icon;
                }
                Icon icon = null;
                return icon;
            }
            finally {
                try {
                    pfd.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!shortcut.hasIconUri()) {
            if (!shortcut.hasIconResource()) return shortcut.getIcon();
            return Icon.createWithResource(shortcut.getPackage(), shortcut.getIconResourceId());
        }
        String uri = this.getShortcutIconUri(shortcut.getPackage(), shortcut.getId(), shortcut.getUserId());
        if (uri == null) {
            return null;
        }
        if (!shortcut.hasAdaptiveBitmap()) return Icon.createWithContentUri(uri);
        return Icon.createWithAdaptiveBitmapContentUri(uri);
    }

    private Drawable loadDrawableResourceFromPackage(String packageName, int resId, UserHandle user, int density) {
        try {
            if (resId == 0) {
                return null;
            }
            ApplicationInfo ai = this.getApplicationInfo(packageName, 0, user);
            Resources res = this.mContext.getPackageManager().getResourcesForApplication(ai);
            return res.getDrawableForDensity(resId, density);
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return null;
        }
    }

    public Drawable getShortcutBadgedIconDrawable(ShortcutInfo shortcut, int density) {
        Drawable originalIcon = this.getShortcutIconDrawable(shortcut, density);
        return originalIcon == null ? null : this.mContext.getPackageManager().getUserBadgedIcon(originalIcon, shortcut.getUserHandle());
    }

    public void startShortcut(@NonNull String packageName, @NonNull String shortcutId, @Nullable Rect sourceBounds, @Nullable Bundle startActivityOptions, @NonNull UserHandle user) {
        this.logErrorForInvalidProfileAccess(user);
        this.startShortcut(packageName, shortcutId, sourceBounds, startActivityOptions, user.getIdentifier());
    }

    public void startShortcut(@NonNull ShortcutInfo shortcut, @Nullable Rect sourceBounds, @Nullable Bundle startActivityOptions) {
        this.startShortcut(shortcut.getPackage(), shortcut.getId(), sourceBounds, startActivityOptions, shortcut.getUserId());
    }

    @UnsupportedAppUsage
    private void startShortcut(@NonNull String packageName, @NonNull String shortcutId, @Nullable Rect sourceBounds, @Nullable Bundle startActivityOptions, int userId) {
        try {
            boolean success = this.mService.startShortcut(this.mContext.getPackageName(), packageName, null, shortcutId, sourceBounds, startActivityOptions, userId);
            if (!success) {
                throw new ActivityNotFoundException("Shortcut could not be started");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    public void registerCallback(Callback callback, Handler handler) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            if (callback != null && this.findCallbackLocked(callback) < 0) {
                boolean addedFirstCallback = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (addedFirstCallback) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mContext.getPackageName(), this.mAppsChangedListener);
                    }
                    catch (RemoteException re) {
                        throw re.rethrowFromSystemServer();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        LauncherApps launcherApps = this;
        synchronized (launcherApps) {
            this.removeCallbackLocked(callback);
            if (this.mCallbacks.size() == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException re) {
                    throw re.rethrowFromSystemServer();
                }
            }
        }
    }

    @FlaggedApi(value="android.content.pm.archiving")
    public void setArchiveCompatibility(@NonNull ArchiveCompatibilityParams params) {
        try {
            this.mService.setArchiveCompatibilityOptions(params.isEnableIconOverlay(), params.isEnableUnarchivalConfirmation());
        }
        catch (RemoteException re) {
            throw re.rethrowFromSystemServer();
        }
    }

    private int findCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int size = this.mCallbacks.size();
        for (int i = 0; i < size; ++i) {
            if (this.mCallbacks.get((int)i).mCallback != callback) continue;
            return i;
        }
        return -1;
    }

    private void removeCallbackLocked(Callback callback) {
        int pos = this.findCallbackLocked(callback);
        if (pos >= 0) {
            this.mCallbacks.remove(pos);
        }
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler toAdd = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(toAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPackageInstallerSessionCallback(@NonNull Executor executor, @NonNull PackageInstaller.SessionCallback callback) {
        if (executor == null) {
            throw new NullPointerException("Executor must not be null");
        }
        List<PackageInstaller.SessionCallbackDelegate> list = this.mDelegates;
        synchronized (list) {
            PackageInstaller.SessionCallbackDelegate delegate = new PackageInstaller.SessionCallbackDelegate(callback, executor);
            try {
                this.mService.registerPackageInstallerCallback(this.mContext.getPackageName(), delegate);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mDelegates.add(delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPackageInstallerSessionCallback(@NonNull PackageInstaller.SessionCallback callback) {
        List<PackageInstaller.SessionCallbackDelegate> list = this.mDelegates;
        synchronized (list) {
            Iterator<PackageInstaller.SessionCallbackDelegate> i = this.mDelegates.iterator();
            while (i.hasNext()) {
                PackageInstaller.SessionCallbackDelegate delegate = i.next();
                if (delegate.mCallback != callback) continue;
                this.mPm.getPackageInstaller().unregisterSessionCallback(delegate.mCallback);
                i.remove();
            }
        }
    }

    @SuppressLint(value={"RequiresPermission"})
    @RequiresPermission(conditional=true, anyOf={"android.permission.ACCESS_HIDDEN_PROFILES_FULL", "android.permission.ACCESS_HIDDEN_PROFILES"})
    @NonNull
    public List<PackageInstaller.SessionInfo> getAllPackageInstallerSessions() {
        try {
            return this.mService.getAllSessions(this.mContext.getPackageName()).getList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShortcutChangeCallback(@NonNull ShortcutChangeCallback callback, @NonNull ShortcutQuery query, @NonNull Executor executor) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        Objects.requireNonNull(query, "Query cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> map = this.mShortcutChangeCallbacks;
        synchronized (map) {
            ShortcutChangeCallbackProxy proxy = new ShortcutChangeCallbackProxy(executor, callback);
            this.mShortcutChangeCallbacks.put(callback, new Pair<Executor, ShortcutChangeCallbackProxy>(executor, proxy));
            try {
                this.mService.registerShortcutChangeCallback(this.mContext.getPackageName(), new ShortcutQueryWrapper(query), proxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShortcutChangeCallback(@NonNull ShortcutChangeCallback callback) {
        Objects.requireNonNull(callback, "Callback cannot be null");
        Map<ShortcutChangeCallback, Pair<Executor, IShortcutChangeCallback>> map = this.mShortcutChangeCallbacks;
        synchronized (map) {
            if (this.mShortcutChangeCallbacks.containsKey(callback)) {
                IShortcutChangeCallback proxy = (IShortcutChangeCallback)this.mShortcutChangeCallbacks.remove((Object)callback).second;
                try {
                    this.mService.unregisterShortcutChangeCallback(this.mContext.getPackageName(), proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    public PinItemRequest getPinItemRequest(Intent intent) {
        return intent.getParcelableExtra(EXTRA_PIN_ITEM_REQUEST, PinItemRequest.class);
    }

    @SystemApi
    public static class AppUsageLimit
    implements Parcelable {
        private final long mTotalUsageLimit;
        private final long mUsageRemaining;
        @NonNull
        public static final Parcelable.Creator<AppUsageLimit> CREATOR = new Parcelable.Creator<AppUsageLimit>(){

            @Override
            public AppUsageLimit createFromParcel(Parcel source) {
                return new AppUsageLimit(source);
            }

            public AppUsageLimit[] newArray(int size) {
                return new AppUsageLimit[size];
            }
        };

        public AppUsageLimit(long totalUsageLimit, long usageRemaining) {
            this.mTotalUsageLimit = totalUsageLimit;
            this.mUsageRemaining = usageRemaining;
        }

        public long getTotalUsageLimit() {
            return this.mTotalUsageLimit;
        }

        public long getUsageRemaining() {
            return this.mUsageRemaining;
        }

        private AppUsageLimit(Parcel source) {
            this.mTotalUsageLimit = source.readLong();
            this.mUsageRemaining = source.readLong();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.mTotalUsageLimit);
            dest.writeLong(this.mUsageRemaining);
        }
    }

    public static class ShortcutQuery {
        public static final int FLAG_MATCH_DYNAMIC = 1;
        @Deprecated
        public static final int FLAG_GET_DYNAMIC = 1;
        public static final int FLAG_MATCH_PINNED = 2;
        @Deprecated
        public static final int FLAG_GET_PINNED = 2;
        public static final int FLAG_MATCH_MANIFEST = 8;
        public static final int FLAG_MATCH_CACHED = 16;
        @Deprecated
        public static final int FLAG_GET_MANIFEST = 8;
        public static final int FLAG_MATCH_PINNED_BY_ANY_LAUNCHER = 1024;
        public static final int FLAG_MATCH_ALL_KINDS = 27;
        public static final int FLAG_MATCH_ALL_KINDS_WITH_ALL_PINNED = 1051;
        @Deprecated
        public static final int FLAG_GET_ALL_KINDS = 27;
        public static final int FLAG_GET_KEY_FIELDS_ONLY = 4;
        @SystemApi
        @RequiresPermission(value="android.permission.ACCESS_SHORTCUTS")
        public static final int FLAG_GET_PERSONS_DATA = 2048;
        @SystemApi
        public static final int FLAG_GET_PERSISTED_DATA = 4096;
        long mChangedSince;
        @Nullable
        String mPackage;
        @Nullable
        List<String> mShortcutIds;
        @Nullable
        List<LocusId> mLocusIds;
        @Nullable
        ComponentName mActivity;
        int mQueryFlags;

        public ShortcutQuery setChangedSince(long changedSince) {
            this.mChangedSince = changedSince;
            return this;
        }

        public ShortcutQuery setPackage(@Nullable String packageName) {
            this.mPackage = packageName;
            return this;
        }

        public ShortcutQuery setShortcutIds(@Nullable List<String> shortcutIds) {
            this.mShortcutIds = shortcutIds;
            return this;
        }

        @NonNull
        public ShortcutQuery setLocusIds(@Nullable List<LocusId> locusIds) {
            this.mLocusIds = locusIds;
            return this;
        }

        public ShortcutQuery setActivity(@Nullable ComponentName activity) {
            this.mActivity = activity;
            return this;
        }

        public ShortcutQuery setQueryFlags(int queryFlags) {
            this.mQueryFlags = queryFlags;
            return this;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface QueryFlags {
        }
    }

    public static abstract class Callback {
        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);

        public void onPackagesSuspended(String[] packageNames, UserHandle user) {
        }

        @Deprecated
        public void onPackagesSuspended(String[] packageNames, UserHandle user, @Nullable Bundle launcherExtras) {
            this.onPackagesSuspended(packageNames, user);
        }

        public void onPackagesUnsuspended(String[] packageNames, UserHandle user) {
        }

        public void onShortcutsChanged(@NonNull String packageName, @NonNull List<ShortcutInfo> shortcuts, @NonNull UserHandle user) {
        }

        public void onPackageLoadingProgressChanged(@NonNull String packageName, @NonNull UserHandle user, float progress) {
        }

        @FlaggedApi(value="android.multiuser.add_launcher_user_config")
        public void onUserConfigChanged(@NonNull LauncherUserInfo launcherUserInfo) {
        }
    }

    @FlaggedApi(value="android.content.pm.archiving")
    public static class ArchiveCompatibilityParams {
        private boolean mEnableIconOverlay = true;
        private boolean mEnableUnarchivalConfirmation = true;

        public boolean isEnableIconOverlay() {
            return this.mEnableIconOverlay;
        }

        public boolean isEnableUnarchivalConfirmation() {
            return this.mEnableUnarchivalConfirmation;
        }

        public void setEnableIconOverlay(boolean enableIconOverlay) {
            this.mEnableIconOverlay = enableIconOverlay;
        }

        public void setEnableUnarchivalConfirmation(boolean enableUnarchivalConfirmation) {
            this.mEnableUnarchivalConfirmation = enableUnarchivalConfirmation;
        }
    }

    private static class CallbackMessageHandler
    extends Handler {
        private static final int MSG_ADDED = 1;
        private static final int MSG_REMOVED = 2;
        private static final int MSG_CHANGED = 3;
        private static final int MSG_AVAILABLE = 4;
        private static final int MSG_UNAVAILABLE = 5;
        private static final int MSG_SUSPENDED = 6;
        private static final int MSG_UNSUSPENDED = 7;
        private static final int MSG_SHORTCUT_CHANGED = 8;
        private static final int MSG_LOADING_PROGRESS_CHANGED = 9;
        private static final int MSG_USER_CONFIG_CHANGED = 10;
        private final Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message msg) {
            if (this.mCallback == null || !(msg.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo info = (CallbackInfo)msg.obj;
            switch (msg.what) {
                case 1: {
                    this.mCallback.onPackageAdded(info.packageName, info.user);
                    break;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(info.packageName, info.user);
                    break;
                }
                case 3: {
                    this.mCallback.onPackageChanged(info.packageName, info.user);
                    break;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 5: {
                    this.mCallback.onPackagesUnavailable(info.packageNames, info.user, info.replacing);
                    break;
                }
                case 6: {
                    this.mCallback.onPackagesSuspended(info.packageNames, info.user, info.launcherExtras);
                    break;
                }
                case 7: {
                    this.mCallback.onPackagesUnsuspended(info.packageNames, info.user);
                    break;
                }
                case 8: {
                    this.mCallback.onShortcutsChanged(info.packageName, info.shortcuts, info.user);
                    break;
                }
                case 9: {
                    this.mCallback.onPackageLoadingProgressChanged(info.packageName, info.user, info.mLoadingProgress);
                    break;
                }
                case 10: {
                    if (!com.android.internal.hidden_from_bootclasspath.android.os.Flags.allowPrivateProfile() || !Flags.addLauncherUserConfig()) break;
                    this.mCallback.onUserConfigChanged(Objects.requireNonNull(info.launcherExtras.getParcelable(LauncherApps.LAUNCHER_USER_INFO_EXTRA_KEY, LauncherUserInfo.class)));
                }
            }
        }

        public void postOnPackageAdded(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(1, info).sendToTarget();
        }

        public void postOnPackageRemoved(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(2, info).sendToTarget();
        }

        public void postOnPackageChanged(String packageName, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            this.obtainMessage(3, info).sendToTarget();
        }

        public void postOnPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(4, info).sendToTarget();
        }

        public void postOnPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.replacing = replacing;
            info.user = user;
            this.obtainMessage(5, info).sendToTarget();
        }

        public void postOnPackagesSuspended(String[] packageNames, Bundle launcherExtras, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.user = user;
            info.launcherExtras = launcherExtras;
            this.obtainMessage(6, info).sendToTarget();
        }

        public void postOnPackagesUnsuspended(String[] packageNames, UserHandle user) {
            CallbackInfo info = new CallbackInfo();
            info.packageNames = packageNames;
            info.user = user;
            this.obtainMessage(7, info).sendToTarget();
        }

        public void postOnShortcutChanged(String packageName, UserHandle user, List<ShortcutInfo> shortcuts) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            info.shortcuts = shortcuts;
            this.obtainMessage(8, info).sendToTarget();
        }

        public void postOnPackageLoadingProgressChanged(UserHandle user, String packageName, float progress) {
            CallbackInfo info = new CallbackInfo();
            info.packageName = packageName;
            info.user = user;
            info.mLoadingProgress = progress;
            this.obtainMessage(9, info).sendToTarget();
        }

        public void postOnUserConfigChanged(LauncherUserInfo launcherUserInfo) {
            CallbackInfo info = new CallbackInfo();
            info.launcherExtras = new Bundle();
            info.launcherExtras.putParcelable(LauncherApps.LAUNCHER_USER_INFO_EXTRA_KEY, launcherUserInfo);
            this.obtainMessage(10, info).sendToTarget();
        }

        private static class CallbackInfo {
            String[] packageNames;
            String packageName;
            Bundle launcherExtras;
            boolean replacing;
            UserHandle user;
            List<ShortcutInfo> shortcuts;
            float mLoadingProgress;

            private CallbackInfo() {
            }
        }
    }

    private static class ShortcutChangeCallbackProxy
    extends IShortcutChangeCallback.Stub {
        private final WeakReference<Pair<Executor, ShortcutChangeCallback>> mRemoteReferences;

        ShortcutChangeCallbackProxy(Executor executor, ShortcutChangeCallback callback) {
            this.mRemoteReferences = new WeakReference<Pair<Executor, ShortcutChangeCallback>>(new Pair<Executor, ShortcutChangeCallback>(executor, callback));
        }

        @Override
        public void onShortcutsAddedOrUpdated(@NonNull String packageName, @NonNull List<ShortcutInfo> shortcuts, @NonNull UserHandle user) {
            Pair remoteReferences = (Pair)this.mRemoteReferences.get();
            if (remoteReferences == null) {
                return;
            }
            Executor executor = (Executor)remoteReferences.first;
            ShortcutChangeCallback callback = (ShortcutChangeCallback)remoteReferences.second;
            executor.execute(PooledLambda.obtainRunnable(ShortcutChangeCallback::onShortcutsAddedOrUpdated, callback, packageName, shortcuts, user).recycleOnUse());
        }

        @Override
        public void onShortcutsRemoved(@NonNull String packageName, @NonNull List<ShortcutInfo> shortcuts, @NonNull UserHandle user) {
            Pair remoteReferences = (Pair)this.mRemoteReferences.get();
            if (remoteReferences == null) {
                return;
            }
            Executor executor = (Executor)remoteReferences.first;
            ShortcutChangeCallback callback = (ShortcutChangeCallback)remoteReferences.second;
            executor.execute(PooledLambda.obtainRunnable(ShortcutChangeCallback::onShortcutsRemoved, callback, packageName, shortcuts, user).recycleOnUse());
        }
    }

    public static interface ShortcutChangeCallback {
        default public void onShortcutsAddedOrUpdated(@NonNull String packageName, @NonNull List<ShortcutInfo> shortcuts, @NonNull UserHandle user) {
        }

        default public void onShortcutsRemoved(@NonNull String packageName, @NonNull List<ShortcutInfo> shortcuts, @NonNull UserHandle user) {
        }
    }

    public static class PinItemRequest
    implements Parcelable {
        public static final int REQUEST_TYPE_SHORTCUT = 1;
        public static final int REQUEST_TYPE_APPWIDGET = 2;
        private final int mRequestType;
        private final IPinItemRequest mInner;
        @NonNull
        public static final Parcelable.Creator<PinItemRequest> CREATOR = new Parcelable.Creator<PinItemRequest>(){

            @Override
            public PinItemRequest createFromParcel(Parcel source) {
                return new PinItemRequest(source);
            }

            public PinItemRequest[] newArray(int size) {
                return new PinItemRequest[size];
            }
        };

        public PinItemRequest(IPinItemRequest inner, int type) {
            this.mInner = inner;
            this.mRequestType = type;
        }

        public int getRequestType() {
            return this.mRequestType;
        }

        @Nullable
        public ShortcutInfo getShortcutInfo() {
            try {
                return this.mInner.getShortcutInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        @Nullable
        public AppWidgetProviderInfo getAppWidgetProviderInfo(Context context) {
            try {
                AppWidgetProviderInfo info = this.mInner.getAppWidgetProviderInfo();
                if (info == null) {
                    return null;
                }
                info.updateDimensions(context.getResources().getDisplayMetrics());
                return info;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        @Nullable
        public Bundle getExtras() {
            try {
                return this.mInner.getExtras();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }

        public boolean isValid() {
            try {
                return this.mInner.isValid();
            }
            catch (RemoteException e) {
                return false;
            }
        }

        public boolean accept(@Nullable Bundle options) {
            try {
                return this.mInner.accept(options);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        public boolean accept() {
            return this.accept(null);
        }

        private PinItemRequest(Parcel source) {
            ClassLoader cl = this.getClass().getClassLoader();
            this.mRequestType = source.readInt();
            this.mInner = IPinItemRequest.Stub.asInterface(source.readStrongBinder());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mRequestType);
            dest.writeStrongBinder(this.mInner.asBinder());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RequestType {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShortcutCacheFlags {
    }
}

