/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ModuleInfo
implements Parcelable {
    private CharSequence mName;
    private String mPackageName;
    @Nullable
    private String mApexModuleName;
    private boolean mHidden;
    @Nullable
    private List<String> mApkInApexPackageNames;
    @NonNull
    public static final Parcelable.Creator<ModuleInfo> CREATOR = new Parcelable.Creator<ModuleInfo>(){

        @Override
        public ModuleInfo createFromParcel(Parcel source) {
            return new ModuleInfo(source);
        }

        public ModuleInfo[] newArray(int size) {
            return new ModuleInfo[size];
        }
    };

    public ModuleInfo() {
    }

    public ModuleInfo(ModuleInfo orig) {
        this.mName = orig.mName;
        this.mPackageName = orig.mPackageName;
        this.mHidden = orig.mHidden;
        this.mApexModuleName = orig.mApexModuleName;
        if (orig.mApkInApexPackageNames != null) {
            this.mApkInApexPackageNames = List.copyOf(orig.mApkInApexPackageNames);
        }
    }

    public ModuleInfo setName(CharSequence name) {
        this.mName = name;
        return this;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    public ModuleInfo setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    public ModuleInfo setHidden(boolean hidden) {
        this.mHidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public ModuleInfo setApexModuleName(@Nullable String apexModuleName) {
        this.mApexModuleName = apexModuleName;
        return this;
    }

    @Nullable
    public String getApexModuleName() {
        return this.mApexModuleName;
    }

    public ModuleInfo setApkInApexPackageNames(@NonNull Collection<String> apkInApexPackageNames) {
        Objects.requireNonNull(apkInApexPackageNames);
        this.mApkInApexPackageNames = List.copyOf(apkInApexPackageNames);
        return this;
    }

    @NonNull
    public Collection<String> getApkInApexPackageNames() {
        if (this.mApkInApexPackageNames == null) {
            return Collections.emptyList();
        }
        return this.mApkInApexPackageNames;
    }

    public String toString() {
        return "ModuleInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Objects.hashCode(this.mName);
        hashCode = 31 * hashCode + Objects.hashCode(this.mPackageName);
        hashCode = 31 * hashCode + Objects.hashCode(this.mApexModuleName);
        hashCode = 31 * hashCode + Objects.hashCode(this.mApkInApexPackageNames);
        hashCode = 31 * hashCode + Boolean.hashCode(this.mHidden);
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)obj;
        return Objects.equals(this.mName, other.mName) && Objects.equals(this.mPackageName, other.mPackageName) && Objects.equals(this.mApexModuleName, other.mApexModuleName) && Objects.equals(this.mApkInApexPackageNames, other.mApkInApexPackageNames) && this.mHidden == other.mHidden;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeCharSequence(this.mName);
        dest.writeString(this.mPackageName);
        dest.writeBoolean(this.mHidden);
        dest.writeString(this.mApexModuleName);
        dest.writeStringList(this.mApkInApexPackageNames);
    }

    private ModuleInfo(Parcel source) {
        this.mName = source.readCharSequence();
        this.mPackageName = source.readString();
        this.mHidden = source.readBoolean();
        this.mApexModuleName = source.readString();
        this.mApkInApexPackageNames = source.createStringArrayList();
    }
}

