/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.Signature;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.PackageUtils;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import libcore.util.HexEncoding;

public class SigningDetails
implements Parcelable {
    private static final String TAG = "SigningDetails";
    @Nullable
    private final Signature[] mSignatures;
    private final int mSignatureSchemeVersion;
    @Nullable
    private final ArraySet<PublicKey> mPublicKeys;
    @Nullable
    private final Signature[] mPastSigningCertificates;
    private static final int PAST_CERT_EXISTS = 0;
    public static final SigningDetails UNKNOWN = new SigningDetails(null, 0, null, null);
    @NonNull
    public static final Parcelable.Creator<SigningDetails> CREATOR = new Parcelable.Creator<SigningDetails>(){

        @Override
        public SigningDetails createFromParcel(@NonNull Parcel source) {
            if (source.readBoolean()) {
                return UNKNOWN;
            }
            return new SigningDetails(source);
        }

        public SigningDetails[] newArray(int size) {
            return new SigningDetails[size];
        }
    };

    @VisibleForTesting
    public SigningDetails(@Nullable Signature[] signatures, int signatureSchemeVersion, @Nullable ArraySet<PublicKey> keys, @Nullable Signature[] pastSigningCertificates) {
        this.mSignatures = signatures;
        this.mSignatureSchemeVersion = signatureSchemeVersion;
        this.mPublicKeys = keys;
        this.mPastSigningCertificates = pastSigningCertificates;
    }

    public SigningDetails(@Nullable Signature[] signatures, int signatureSchemeVersion, @Nullable Signature[] pastSigningCertificates) throws CertificateException {
        this(signatures, signatureSchemeVersion, SigningDetails.toSigningKeys(signatures), pastSigningCertificates);
    }

    public SigningDetails(@Nullable Signature[] signatures, int signatureSchemeVersion) throws CertificateException {
        this(signatures, signatureSchemeVersion, null);
    }

    public SigningDetails(@Nullable SigningDetails orig) {
        if (orig != null) {
            this.mSignatures = orig.mSignatures != null ? (Signature[])orig.mSignatures.clone() : null;
            this.mSignatureSchemeVersion = orig.mSignatureSchemeVersion;
            this.mPublicKeys = new ArraySet<PublicKey>(orig.mPublicKeys);
            this.mPastSigningCertificates = orig.mPastSigningCertificates != null ? (Signature[])orig.mPastSigningCertificates.clone() : null;
        } else {
            this.mSignatures = null;
            this.mSignatureSchemeVersion = 0;
            this.mPublicKeys = null;
            this.mPastSigningCertificates = null;
        }
    }

    @NonNull
    public SigningDetails mergeLineageWith(@NonNull SigningDetails otherSigningDetails) {
        return this.mergeLineageWith(otherSigningDetails, 1);
    }

    @NonNull
    public SigningDetails mergeLineageWith(@NonNull SigningDetails otherSigningDetails, @CapabilityMergeRule int mergeRule) {
        if (!this.hasPastSigningCertificates()) {
            return otherSigningDetails.hasPastSigningCertificates() && otherSigningDetails.hasAncestorOrSelf(this) ? otherSigningDetails : this;
        }
        if (!otherSigningDetails.hasPastSigningCertificates()) {
            return this;
        }
        SigningDetails descendantSigningDetails = this.getDescendantOrSelf(otherSigningDetails);
        if (descendantSigningDetails == null) {
            return this;
        }
        SigningDetails mergedDetails = this;
        if (descendantSigningDetails == this) {
            mergedDetails = this.mergeLineageWithAncestorOrSelf(otherSigningDetails, mergeRule);
        } else {
            switch (mergeRule) {
                case 0: {
                    mergedDetails = otherSigningDetails.mergeLineageWithAncestorOrSelf(this, 1);
                    break;
                }
                case 1: {
                    mergedDetails = otherSigningDetails.mergeLineageWithAncestorOrSelf(this, 0);
                    break;
                }
                case 2: {
                    mergedDetails = otherSigningDetails.mergeLineageWithAncestorOrSelf(this, mergeRule);
                }
            }
        }
        return mergedDetails;
    }

    @NonNull
    private SigningDetails mergeLineageWithAncestorOrSelf(@NonNull SigningDetails otherSigningDetails, @CapabilityMergeRule int mergeRule) {
        int index = this.mPastSigningCertificates.length - 1;
        int otherIndex = otherSigningDetails.mPastSigningCertificates.length - 1;
        if (index < 0 || otherIndex < 0) {
            return this;
        }
        ArrayList<Signature> mergedSignatures = new ArrayList<Signature>();
        boolean capabilitiesModified = false;
        while (index >= 0 && !this.mPastSigningCertificates[index].equals(otherSigningDetails.mPastSigningCertificates[otherIndex])) {
            mergedSignatures.add(new Signature(this.mPastSigningCertificates[index--]));
        }
        if (index < 0) {
            return this;
        }
        do {
            Signature signature = this.mPastSigningCertificates[index--];
            Signature ancestorSignature = otherSigningDetails.mPastSigningCertificates[otherIndex--];
            Signature mergedSignature = new Signature(signature);
            if (signature.getFlags() != ancestorSignature.getFlags()) {
                capabilitiesModified = true;
                switch (mergeRule) {
                    case 0: {
                        mergedSignature.setFlags(signature.getFlags());
                        break;
                    }
                    case 1: {
                        mergedSignature.setFlags(ancestorSignature.getFlags());
                        break;
                    }
                    case 2: {
                        mergedSignature.setFlags(signature.getFlags() & ancestorSignature.getFlags());
                    }
                }
            }
            mergedSignatures.add(mergedSignature);
        } while (index >= 0 && otherIndex >= 0 && this.mPastSigningCertificates[index].equals(otherSigningDetails.mPastSigningCertificates[otherIndex]));
        if (index >= 0 && otherIndex >= 0) {
            return this;
        }
        while (otherIndex >= 0) {
            mergedSignatures.add(new Signature(otherSigningDetails.mPastSigningCertificates[otherIndex--]));
        }
        while (index >= 0) {
            mergedSignatures.add(new Signature(this.mPastSigningCertificates[index--]));
        }
        if (mergedSignatures.size() == this.mPastSigningCertificates.length && !capabilitiesModified) {
            return this;
        }
        Collections.reverse(mergedSignatures);
        try {
            return new SigningDetails(new Signature[]{new Signature(this.mSignatures[0])}, this.mSignatureSchemeVersion, mergedSignatures.toArray(new Signature[0]));
        }
        catch (CertificateException e) {
            Slog.e(TAG, "Caught an exception creating the merged lineage: ", e);
            return this;
        }
    }

    public boolean hasCommonAncestor(@NonNull SigningDetails otherSigningDetails) {
        if (!this.hasPastSigningCertificates()) {
            return otherSigningDetails.hasAncestorOrSelf(this);
        }
        if (!otherSigningDetails.hasPastSigningCertificates()) {
            return this.hasAncestorOrSelf(otherSigningDetails);
        }
        return this.getDescendantOrSelf(otherSigningDetails) != null;
    }

    public boolean hasAncestorOrSelfWithDigest(@Nullable Set<String> certDigests) {
        if (this == UNKNOWN || certDigests == null || certDigests.size() == 0) {
            return false;
        }
        if (this.mSignatures.length > 1) {
            if (certDigests.size() < this.mSignatures.length) {
                return false;
            }
            for (Signature signature : this.mSignatures) {
                String signatureDigest = PackageUtils.computeSha256Digest(signature.toByteArray());
                if (certDigests.contains(signatureDigest)) continue;
                return false;
            }
            return true;
        }
        String signatureDigest = PackageUtils.computeSha256Digest(this.mSignatures[0].toByteArray());
        if (certDigests.contains(signatureDigest)) {
            return true;
        }
        if (this.hasPastSigningCertificates()) {
            for (int i = 0; i < this.mPastSigningCertificates.length - 1; ++i) {
                signatureDigest = PackageUtils.computeSha256Digest(this.mPastSigningCertificates[i].toByteArray());
                if (!certDigests.contains(signatureDigest)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private SigningDetails getDescendantOrSelf(@NonNull SigningDetails otherSigningDetails) {
        int descendantIndex;
        SigningDetails ancestorSigningDetails;
        SigningDetails descendantSigningDetails;
        if (this.hasAncestorOrSelf(otherSigningDetails)) {
            descendantSigningDetails = this;
            ancestorSigningDetails = otherSigningDetails;
        } else if (otherSigningDetails.hasAncestor(this)) {
            descendantSigningDetails = otherSigningDetails;
            ancestorSigningDetails = this;
        } else {
            return null;
        }
        int ancestorIndex = ancestorSigningDetails.mPastSigningCertificates.length - 1;
        for (descendantIndex = descendantSigningDetails.mPastSigningCertificates.length - 1; descendantIndex >= 0 && !descendantSigningDetails.mPastSigningCertificates[descendantIndex].equals(ancestorSigningDetails.mPastSigningCertificates[ancestorIndex]); --descendantIndex) {
        }
        if (descendantIndex < 0) {
            return null;
        }
        while (--descendantIndex >= 0 && --ancestorIndex >= 0 && descendantSigningDetails.mPastSigningCertificates[descendantIndex].equals(ancestorSigningDetails.mPastSigningCertificates[ancestorIndex])) {
        }
        if (descendantIndex >= 0 && ancestorIndex >= 0) {
            return null;
        }
        return descendantSigningDetails;
    }

    public boolean hasSignatures() {
        return this.mSignatures != null && this.mSignatures.length > 0;
    }

    public boolean hasPastSigningCertificates() {
        return this.mPastSigningCertificates != null && this.mPastSigningCertificates.length > 0;
    }

    public boolean hasAncestorOrSelf(@NonNull SigningDetails oldDetails) {
        if (this == UNKNOWN || oldDetails == UNKNOWN) {
            return false;
        }
        if (oldDetails.mSignatures.length > 1) {
            return this.signaturesMatchExactly(oldDetails);
        }
        return this.hasCertificate(oldDetails.mSignatures[0]);
    }

    public boolean hasAncestor(@NonNull SigningDetails oldDetails) {
        if (this == UNKNOWN || oldDetails == UNKNOWN) {
            return false;
        }
        if (this.hasPastSigningCertificates() && oldDetails.mSignatures.length == 1) {
            for (int i = 0; i < this.mPastSigningCertificates.length - 1; ++i) {
                if (!this.mPastSigningCertificates[i].equals(oldDetails.mSignatures[0])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasCommonSignerWithCapability(@NonNull SigningDetails otherDetails, @CertCapabilities int flags) {
        if (this == UNKNOWN || otherDetails == UNKNOWN) {
            return false;
        }
        if (this.mSignatures.length > 1 || otherDetails.mSignatures.length > 1) {
            return this.signaturesMatchExactly(otherDetails);
        }
        ArraySet<Signature> otherSignatures = new ArraySet<Signature>();
        if (otherDetails.hasPastSigningCertificates()) {
            otherSignatures.addAll(Arrays.asList(otherDetails.mPastSigningCertificates));
        } else {
            otherSignatures.addAll(Arrays.asList(otherDetails.mSignatures));
        }
        if (otherSignatures.contains(this.mSignatures[0])) {
            return true;
        }
        if (this.hasPastSigningCertificates()) {
            for (int i = 0; i < this.mPastSigningCertificates.length - 1; ++i) {
                if (!otherSignatures.contains(this.mPastSigningCertificates[i]) || (this.mPastSigningCertificates[i].getFlags() & flags) != flags) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkCapability(@NonNull SigningDetails oldDetails, @CertCapabilities int flags) {
        if (this == UNKNOWN || oldDetails == UNKNOWN) {
            return false;
        }
        if (oldDetails.mSignatures.length > 1) {
            return this.signaturesMatchExactly(oldDetails);
        }
        return this.hasCertificate(oldDetails.mSignatures[0], flags);
    }

    public boolean checkCapabilityRecover(@NonNull SigningDetails oldDetails, @CertCapabilities int flags) throws CertificateException {
        if (oldDetails == UNKNOWN || this == UNKNOWN) {
            return false;
        }
        if (this.hasPastSigningCertificates() && oldDetails.mSignatures.length == 1) {
            for (int i = 0; i < this.mPastSigningCertificates.length; ++i) {
                if (!Signature.areEffectiveMatch(oldDetails.mSignatures[0], this.mPastSigningCertificates[i]) || this.mPastSigningCertificates[i].getFlags() != flags) continue;
                return true;
            }
        } else {
            return Signature.areEffectiveMatch(oldDetails, this);
        }
        return false;
    }

    public boolean hasCertificate(@NonNull Signature signature) {
        return this.hasCertificateInternal(signature, 0);
    }

    public boolean hasCertificate(@NonNull Signature signature, @CertCapabilities int flags) {
        return this.hasCertificateInternal(signature, flags);
    }

    public boolean hasCertificate(byte[] certificate) {
        Signature signature = new Signature(certificate);
        return this.hasCertificate(signature);
    }

    private boolean hasCertificateInternal(@NonNull Signature signature, int flags) {
        if (this == UNKNOWN) {
            return false;
        }
        if (this.hasPastSigningCertificates()) {
            for (int i = 0; i < this.mPastSigningCertificates.length - 1; ++i) {
                if (!this.mPastSigningCertificates[i].equals(signature) || flags != 0 && (flags & this.mPastSigningCertificates[i].getFlags()) != flags) continue;
                return true;
            }
        }
        return this.mSignatures.length == 1 && this.mSignatures[0].equals(signature);
    }

    public boolean checkCapability(@Nullable String sha256String, @CertCapabilities int flags) {
        if (this == UNKNOWN || TextUtils.isEmpty(sha256String)) {
            return false;
        }
        byte[] sha256Bytes = HexEncoding.decode(sha256String, false);
        if (this.hasSha256Certificate(sha256Bytes, flags)) {
            return true;
        }
        String[] mSignaturesSha256Digests = PackageUtils.computeSignaturesSha256Digests(this.mSignatures);
        String mSignaturesSha256Digest = PackageUtils.computeSignaturesSha256Digest(mSignaturesSha256Digests);
        return mSignaturesSha256Digest.equals(sha256String);
    }

    public boolean hasSha256Certificate(byte[] sha256Certificate) {
        return this.hasSha256CertificateInternal(sha256Certificate, 0);
    }

    public boolean hasSha256Certificate(byte[] sha256Certificate, @CertCapabilities int flags) {
        return this.hasSha256CertificateInternal(sha256Certificate, flags);
    }

    private boolean hasSha256CertificateInternal(byte[] sha256Certificate, int flags) {
        if (this == UNKNOWN) {
            return false;
        }
        if (this.hasPastSigningCertificates()) {
            for (int i = 0; i < this.mPastSigningCertificates.length - 1; ++i) {
                byte[] digest = PackageUtils.computeSha256DigestBytes(this.mPastSigningCertificates[i].toByteArray());
                if (!Arrays.equals(sha256Certificate, digest) || flags != 0 && (flags & this.mPastSigningCertificates[i].getFlags()) != flags) continue;
                return true;
            }
        }
        if (this.mSignatures.length == 1) {
            byte[] digest = PackageUtils.computeSha256DigestBytes(this.mSignatures[0].toByteArray());
            return Arrays.equals(sha256Certificate, digest);
        }
        return false;
    }

    public boolean signaturesMatchExactly(@NonNull SigningDetails other) {
        return Signature.areExactMatch(this, other);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        boolean isUnknown = UNKNOWN == this;
        dest.writeBoolean(isUnknown);
        if (isUnknown) {
            return;
        }
        dest.writeTypedArray(this.mSignatures, flags);
        dest.writeInt(this.mSignatureSchemeVersion);
        dest.writeArraySet(this.mPublicKeys);
        dest.writeTypedArray(this.mPastSigningCertificates, flags);
    }

    protected SigningDetails(@NonNull Parcel in) {
        ClassLoader boot = Object.class.getClassLoader();
        this.mSignatures = in.createTypedArray(Signature.CREATOR);
        this.mSignatureSchemeVersion = in.readInt();
        this.mPublicKeys = in.readArraySet(boot);
        this.mPastSigningCertificates = in.createTypedArray(Signature.CREATOR);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SigningDetails)) {
            return false;
        }
        SigningDetails that = (SigningDetails)o;
        if (this.mSignatureSchemeVersion != that.mSignatureSchemeVersion) {
            return false;
        }
        if (!Signature.areExactMatch(this, that)) {
            return false;
        }
        if (this.mPublicKeys != null ? !this.mPublicKeys.equals(that.mPublicKeys) : that.mPublicKeys != null) {
            return false;
        }
        if (!Arrays.equals(this.mPastSigningCertificates, that.mPastSigningCertificates)) {
            return false;
        }
        if (this.mPastSigningCertificates != null) {
            for (int i = 0; i < this.mPastSigningCertificates.length; ++i) {
                if (this.mPastSigningCertificates[i].getFlags() == that.mPastSigningCertificates[i].getFlags()) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mSignatures);
        result = 31 * result + this.mSignatureSchemeVersion;
        result = 31 * result + (this.mPublicKeys != null ? this.mPublicKeys.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.mPastSigningCertificates);
        return result;
    }

    public static ArraySet<PublicKey> toSigningKeys(@NonNull Signature[] signatures) throws CertificateException {
        ArraySet<PublicKey> keys = new ArraySet<PublicKey>(signatures.length);
        for (int i = 0; i < signatures.length; ++i) {
            keys.add(signatures[i].getPublicKey());
        }
        return keys;
    }

    @Nullable
    public Signature[] getSignatures() {
        return this.mSignatures;
    }

    public int getSignatureSchemeVersion() {
        return this.mSignatureSchemeVersion;
    }

    @Nullable
    public ArraySet<PublicKey> getPublicKeys() {
        return this.mPublicKeys;
    }

    @Nullable
    public Signature[] getPastSigningCertificates() {
        return this.mPastSigningCertificates;
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SignatureSchemeVersion {
        public static final int UNKNOWN = 0;
        public static final int JAR = 1;
        public static final int SIGNING_BLOCK_V2 = 2;
        public static final int SIGNING_BLOCK_V3 = 3;
        public static final int SIGNING_BLOCK_V4 = 4;
    }

    public static @interface CapabilityMergeRule {
        public static final int MERGE_SELF_CAPABILITY = 0;
        public static final int MERGE_OTHER_CAPABILITY = 1;
        public static final int MERGE_RESTRICTED_CAPABILITY = 2;
    }

    public static class Builder {
        @NonNull
        private Signature[] mSignatures;
        private int mSignatureSchemeVersion = 0;
        @Nullable
        private Signature[] mPastSigningCertificates;

        public Builder setSignatures(@NonNull Signature[] signatures) {
            this.mSignatures = signatures;
            return this;
        }

        public Builder setSignatureSchemeVersion(int signatureSchemeVersion) {
            this.mSignatureSchemeVersion = signatureSchemeVersion;
            return this;
        }

        public Builder setPastSigningCertificates(@Nullable Signature[] pastSigningCertificates) {
            this.mPastSigningCertificates = pastSigningCertificates;
            return this;
        }

        private void checkInvariants() {
            if (this.mSignatures == null) {
                throw new IllegalStateException("SigningDetails requires the current signing certificates.");
            }
        }

        public SigningDetails build() throws CertificateException {
            this.checkInvariants();
            return new SigningDetails(this.mSignatures, this.mSignatureSchemeVersion, this.mPastSigningCertificates);
        }
    }

    public static @interface CertCapabilities {
        public static final int INSTALLED_DATA = 1;
        public static final int SHARED_USER_ID = 2;
        public static final int PERMISSION = 4;
        public static final int ROLLBACK = 8;
        public static final int AUTH = 16;
    }
}

