/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.dex;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.dex.IArtManager;
import android.content.pm.dex.ISnapshotRuntimeProfileCallback;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Slog;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class ArtManager {
    private static final String TAG = "ArtManager";
    public static final int SNAPSHOT_FAILED_PACKAGE_NOT_FOUND = 0;
    public static final int SNAPSHOT_FAILED_CODE_PATH_NOT_FOUND = 1;
    public static final int SNAPSHOT_FAILED_INTERNAL_ERROR = 2;
    public static final int PROFILE_APPS = 0;
    public static final int PROFILE_BOOT_IMAGE = 1;
    private final Context mContext;
    private final IArtManager mArtManager;

    public ArtManager(@NonNull Context context, @NonNull IArtManager manager) {
        this.mContext = context;
        this.mArtManager = manager;
    }

    @RequiresPermission(allOf={"android.permission.READ_RUNTIME_PROFILES", "android.permission.PACKAGE_USAGE_STATS"})
    public void snapshotRuntimeProfile(int profileType, @Nullable String packageName, @Nullable String codePath, @NonNull Executor executor, @NonNull SnapshotRuntimeProfileCallback callback) {
        Slog.d(TAG, "Requesting profile snapshot for " + packageName + ":" + codePath);
        SnapshotRuntimeProfileCallbackDelegate delegate = new SnapshotRuntimeProfileCallbackDelegate(callback, executor);
        try {
            this.mArtManager.snapshotRuntimeProfile(profileType, packageName, codePath, delegate, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @RequiresPermission(allOf={"android.permission.READ_RUNTIME_PROFILES", "android.permission.PACKAGE_USAGE_STATS"})
    public boolean isRuntimeProfilingEnabled(int profileType) {
        try {
            return this.mArtManager.isRuntimeProfilingEnabled(profileType, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static String getProfileName(String splitName) {
        return splitName == null ? "primary.prof" : splitName + ".split.prof";
    }

    public static String getCurrentProfilePath(String packageName, int userId, String splitName) {
        File profileDir = Environment.getDataProfilesDePackageDirectory(userId, packageName);
        return new File(profileDir, ArtManager.getProfileName(splitName)).getAbsolutePath();
    }

    public static String getReferenceProfilePath(String packageName, int userId, String splitName) {
        File profileDir = Environment.getDataRefProfilesDePackageDirectory(packageName);
        return new File(profileDir, ArtManager.getProfileName(splitName)).getAbsolutePath();
    }

    public static File getProfileSnapshotFileForName(String packageName, String profileName) {
        File profileDir = Environment.getDataRefProfilesDePackageDirectory(packageName);
        return new File(profileDir, profileName + ".snapshot");
    }

    private static class SnapshotRuntimeProfileCallbackDelegate
    extends ISnapshotRuntimeProfileCallback.Stub {
        private final SnapshotRuntimeProfileCallback mCallback;
        private final Executor mExecutor;

        private SnapshotRuntimeProfileCallbackDelegate(SnapshotRuntimeProfileCallback callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onSuccess(ParcelFileDescriptor profileReadFd) {
            this.mExecutor.execute(() -> this.mCallback.onSuccess(profileReadFd));
        }

        @Override
        public void onError(int errCode) {
            this.mExecutor.execute(() -> this.mCallback.onError(errCode));
        }
    }

    public static abstract class SnapshotRuntimeProfileCallback {
        public abstract void onSuccess(ParcelFileDescriptor var1);

        public abstract void onError(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileType {
    }
}

