/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.annotation.NonNull;
import android.content.res.TagCounter;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Pools;
import android.util.Slog;
import com.android.layoutlib.androidx.annotation.StyleableRes;

@RavenwoodKeepWholeClass
public class Element {
    private static final int DEFAULT_MAX_STRING_ATTR_LENGTH = 32768;
    private static final int MAX_POOL_SIZE = 128;
    private static final int MAX_ATTR_LEN_URL_COMPONENT = 256;
    private static final int MAX_ATTR_LEN_PERMISSION_GROUP = 256;
    private static final int MAX_ATTR_LEN_PACKAGE = 256;
    private static final int MAX_ATTR_LEN_MIMETYPE = 255;
    private static final int MAX_ATTR_LEN_NAME = 1024;
    private static final int MAX_ATTR_LEN_PATH = 4000;
    private static final int MAX_ATTR_LEN_VALUE = 32768;
    private static final int MAX_TOTAL_META_DATA_SIZE = 262144;
    private static final String BAD_COMPONENT_NAME_CHARS = ";,[](){}:?%^*|/\\";
    private static final String TAG = "PackageParsing";
    protected static final String TAG_ACTION = "action";
    protected static final String TAG_ACTIVITY = "activity";
    protected static final String TAG_ADOPT_PERMISSIONS = "adopt-permissions";
    protected static final String TAG_ACTIVITY_ALIAS = "activity-alias";
    protected static final String TAG_APPLICATION = "application";
    protected static final String TAG_ATTRIBUTION = "attribution";
    protected static final String TAG_CATEGORY = "category";
    protected static final String TAG_COMPATIBLE_SCREENS = "compatible-screens";
    protected static final String TAG_DATA = "data";
    protected static final String TAG_EAT_COMMENT = "eat-comment";
    protected static final String TAG_FEATURE_GROUP = "feature-group";
    protected static final String TAG_GRANT_URI_PERMISSION = "grant-uri-permission";
    protected static final String TAG_INSTRUMENTATION = "instrumentation";
    protected static final String TAG_INTENT = "intent";
    protected static final String TAG_INTENT_FILTER = "intent-filter";
    protected static final String TAG_KEY_SETS = "key-sets";
    protected static final String TAG_LAYOUT = "layout";
    protected static final String TAG_MANIFEST = "manifest";
    protected static final String TAG_META_DATA = "meta-data";
    protected static final String TAG_ORIGINAL_PACKAGE = "original-package";
    protected static final String TAG_OVERLAY = "overlay";
    protected static final String TAG_PACKAGE = "package";
    protected static final String TAG_PACKAGE_VERIFIER = "package-verifier";
    protected static final String TAG_PATH_PERMISSION = "path-permission";
    protected static final String TAG_PERMISSION = "permission";
    protected static final String TAG_PERMISSION_GROUP = "permission-group";
    protected static final String TAG_PERMISSION_TREE = "permission-tree";
    protected static final String TAG_PROFILEABLE = "profileable";
    protected static final String TAG_PROTECTED_BROADCAST = "protected-broadcast";
    protected static final String TAG_PROPERTY = "property";
    protected static final String TAG_PROVIDER = "provider";
    protected static final String TAG_QUERIES = "queries";
    protected static final String TAG_RECEIVER = "receiver";
    protected static final String TAG_RESTRICT_UPDATE = "restrict-update";
    protected static final String TAG_SCREEN = "screen";
    protected static final String TAG_SERVICE = "service";
    protected static final String TAG_SUPPORT_SCREENS = "supports-screens";
    protected static final String TAG_SUPPORTS_GL_TEXTURE = "supports-gl-texture";
    protected static final String TAG_SUPPORTS_INPUT = "supports-input";
    protected static final String TAG_SUPPORTS_SCREENS = "supports-screens";
    protected static final String TAG_URI_RELATIVE_FILTER_GROUP = "uri-relative-filter-group";
    protected static final String TAG_USES_CONFIGURATION = "uses-configuration";
    protected static final String TAG_USES_FEATURE = "uses-feature";
    protected static final String TAG_USES_GL_TEXTURE = "uses-gl-texture";
    protected static final String TAG_USES_LIBRARY = "uses-library";
    protected static final String TAG_USES_NATIVE_LIBRARY = "uses-native-library";
    protected static final String TAG_USES_PERMISSION = "uses-permission";
    protected static final String TAG_USES_PERMISSION_SDK_23 = "uses-permission-sdk-23";
    protected static final String TAG_USES_PERMISSION_SDK_M = "uses-permission-sdk-m";
    protected static final String TAG_USES_SDK = "uses-sdk";
    protected static final String TAG_USES_SPLIT = "uses-split";
    protected static final String TAG_ATTR_BACKUP_AGENT = "backupAgent";
    protected static final String TAG_ATTR_CATEGORY = "category";
    protected static final String TAG_ATTR_FRAGMENT = "fragment";
    protected static final String TAG_ATTR_FRAGMENT_ADVANCED_PATTERN = "fragmentAdvancedPattern";
    protected static final String TAG_ATTR_FRAGMENT_PATTERN = "fragmentPattern";
    protected static final String TAG_ATTR_FRAGMENT_PREFIX = "fragmentPrefix";
    protected static final String TAG_ATTR_FRAGMENT_SUFFIX = "fragmentSuffix";
    protected static final String TAG_ATTR_HOST = "host";
    protected static final String TAG_ATTR_MANAGE_SPACE_ACTIVITY = "manageSpaceActivity";
    protected static final String TAG_ATTR_MIMETYPE = "mimeType";
    protected static final String TAG_ATTR_MIMEGROUP = "mimeGroup";
    protected static final String TAG_ATTR_NAME = "name";
    protected static final String TAG_ATTR_PACKAGE = "package";
    protected static final String TAG_ATTR_PATH = "path";
    protected static final String TAG_ATTR_PATH_ADVANCED_PATTERN = "pathAdvancedPattern";
    protected static final String TAG_ATTR_PATH_PATTERN = "pathPattern";
    protected static final String TAG_ATTR_PATH_PREFIX = "pathPrefix";
    protected static final String TAG_ATTR_PATH_SUFFIX = "pathSuffix";
    protected static final String TAG_ATTR_PARENT_ACTIVITY_NAME = "parentActivityName";
    protected static final String TAG_ATTR_PERMISSION = "permission";
    protected static final String TAG_ATTR_PERMISSION_GROUP = "permissionGroup";
    protected static final String TAG_ATTR_PORT = "port";
    protected static final String TAG_ATTR_PROCESS = "process";
    protected static final String TAG_ATTR_QUERY = "query";
    protected static final String TAG_ATTR_QUERY_ADVANCED_PATTERN = "queryAdvancedPattern";
    protected static final String TAG_ATTR_QUERY_PATTERN = "queryPattern";
    protected static final String TAG_ATTR_QUERY_PREFIX = "queryPrefix";
    protected static final String TAG_ATTR_QUERY_SUFFIX = "querySuffix";
    protected static final String TAG_ATTR_READ_PERMISSION = "readPermission";
    protected static final String TAG_ATTR_REQUIRED_ACCOUNT_TYPE = "requiredAccountType";
    protected static final String TAG_ATTR_REQUIRED_SYSTEM_PROPERTY_NAME = "requiredSystemPropertyName";
    protected static final String TAG_ATTR_REQUIRED_SYSTEM_PROPERTY_VALUE = "requiredSystemPropertyValue";
    protected static final String TAG_ATTR_RESTRICTED_ACCOUNT_TYPE = "restrictedAccountType";
    protected static final String TAG_ATTR_SCHEME = "scheme";
    protected static final String TAG_ATTR_SHARED_USER_ID = "sharedUserId";
    protected static final String TAG_ATTR_TARGET_ACTIVITY = "targetActivity";
    protected static final String TAG_ATTR_TARGET_NAME = "targetName";
    protected static final String TAG_ATTR_TARGET_PACKAGE = "targetPackage";
    protected static final String TAG_ATTR_TARGET_PROCESSES = "targetProcesses";
    protected static final String TAG_ATTR_TASK_AFFINITY = "taskAffinity";
    protected static final String TAG_ATTR_VALUE = "value";
    protected static final String TAG_ATTR_VERSION_NAME = "versionName";
    protected static final String TAG_ATTR_WRITE_PERMISSION = "writePermission";
    protected static final String TAG_ATTR_ZYGOTE_PRELOAD_NAME = "zygotePreloadName";
    private final TagCounter[] mTagCounters = new TagCounter[35];
    String mTag;
    private static final ThreadLocal<Pools.SimplePool<Element>> sPool = ThreadLocal.withInitial(() -> new Pools.SimplePool(128));
    private long mChildTagMask = 0L;
    private int mTotalComponentMetadataSize = 0;

    @NonNull
    static Element obtain(@NonNull String tag) {
        Element element = sPool.get().acquire();
        if (element == null) {
            element = new Element();
        }
        element.init(tag);
        return element;
    }

    void recycle() {
        this.mTag = null;
        sPool.get().release(this);
    }

    private static int getCounterIdx(String tag) {
        switch (tag) {
            case "layout": {
                return 0;
            }
            case "meta-data": {
                return 1;
            }
            case "intent-filter": {
                return 2;
            }
            case "profileable": {
                return 3;
            }
            case "uses-native-library": {
                return 4;
            }
            case "receiver": {
                return 5;
            }
            case "service": {
                return 6;
            }
            case "activity-alias": {
                return 7;
            }
            case "uses-library": {
                return 8;
            }
            case "provider": {
                return 9;
            }
            case "activity": {
                return 10;
            }
            case "action": {
                return 11;
            }
            case "category": {
                return 12;
            }
            case "data": {
                return 13;
            }
            case "application": {
                return 14;
            }
            case "overlay": {
                return 15;
            }
            case "instrumentation": {
                return 16;
            }
            case "permission-group": {
                return 17;
            }
            case "permission-tree": {
                return 18;
            }
            case "supports-gl-texture": {
                return 19;
            }
            case "supports-screens": {
                return 20;
            }
            case "uses-configuration": {
                return 21;
            }
            case "uses-sdk": {
                return 22;
            }
            case "compatible-screens": {
                return 23;
            }
            case "queries": {
                return 24;
            }
            case "attribution": {
                return 25;
            }
            case "uses-feature": {
                return 26;
            }
            case "permission": {
                return 27;
            }
            case "uses-permission": 
            case "uses-permission-sdk-23": 
            case "uses-permission-sdk-m": {
                return 28;
            }
            case "grant-uri-permission": {
                return 29;
            }
            case "path-permission": {
                return 30;
            }
            case "package": {
                return 31;
            }
            case "intent": {
                return 32;
            }
            case "uri-relative-filter-group": {
                return 33;
            }
        }
        return 34;
    }

    static boolean shouldValidate(String tag) {
        switch (tag) {
            case "action": 
            case "activity": 
            case "activity-alias": 
            case "application": 
            case "attribution": 
            case "category": 
            case "compatible-screens": 
            case "data": 
            case "grant-uri-permission": 
            case "instrumentation": 
            case "intent": 
            case "intent-filter": 
            case "layout": 
            case "manifest": 
            case "meta-data": 
            case "overlay": 
            case "package": 
            case "path-permission": 
            case "permission": 
            case "permission-group": 
            case "permission-tree": 
            case "profileable": 
            case "property": 
            case "provider": 
            case "queries": 
            case "receiver": 
            case "screen": 
            case "service": 
            case "supports-gl-texture": 
            case "supports-screens": 
            case "uri-relative-filter-group": 
            case "uses-configuration": 
            case "uses-feature": 
            case "uses-library": 
            case "uses-native-library": 
            case "uses-permission": 
            case "uses-permission-sdk-23": 
            case "uses-permission-sdk-m": 
            case "uses-sdk": {
                return true;
            }
        }
        return false;
    }

    private void init(String tag) {
        this.mTag = tag;
        this.mChildTagMask = 0L;
        this.mTotalComponentMetadataSize = 0;
        switch (tag) {
            case "activity": {
                this.initializeCounter(TAG_LAYOUT, 1000);
                this.initializeCounter(TAG_META_DATA, 1000);
                this.initializeCounter(TAG_INTENT_FILTER, 20000);
                break;
            }
            case "activity-alias": 
            case "receiver": 
            case "service": {
                this.initializeCounter(TAG_META_DATA, 1000);
                this.initializeCounter(TAG_INTENT_FILTER, 20000);
                break;
            }
            case "application": {
                this.initializeCounter(TAG_PROFILEABLE, 100);
                this.initializeCounter(TAG_USES_NATIVE_LIBRARY, 100);
                this.initializeCounter(TAG_RECEIVER, 1000);
                this.initializeCounter(TAG_SERVICE, 1000);
                this.initializeCounter(TAG_META_DATA, 1000);
                this.initializeCounter(TAG_USES_LIBRARY, 1000);
                this.initializeCounter(TAG_ACTIVITY_ALIAS, 4000);
                this.initializeCounter(TAG_PROVIDER, 8000);
                this.initializeCounter(TAG_ACTIVITY, 30000);
                break;
            }
            case "compatible-screens": {
                this.initializeCounter(TAG_SCREEN, 4000);
                break;
            }
            case "intent": 
            case "intent-filter": {
                this.initializeCounter(TAG_URI_RELATIVE_FILTER_GROUP, 100);
                this.initializeCounter(TAG_ACTION, 20000);
                this.initializeCounter("category", 40000);
                this.initializeCounter(TAG_DATA, 40000);
                break;
            }
            case "manifest": {
                this.initializeCounter(TAG_APPLICATION, 100);
                this.initializeCounter(TAG_OVERLAY, 100);
                this.initializeCounter(TAG_INSTRUMENTATION, 100);
                this.initializeCounter(TAG_PERMISSION_GROUP, 100);
                this.initializeCounter(TAG_PERMISSION_TREE, 100);
                this.initializeCounter(TAG_SUPPORTS_GL_TEXTURE, 100);
                this.initializeCounter("supports-screens", 100);
                this.initializeCounter(TAG_USES_CONFIGURATION, 100);
                this.initializeCounter(TAG_USES_SDK, 100);
                this.initializeCounter(TAG_COMPATIBLE_SCREENS, 200);
                this.initializeCounter(TAG_QUERIES, 200);
                this.initializeCounter(TAG_ATTRIBUTION, 400);
                this.initializeCounter(TAG_USES_FEATURE, 400);
                this.initializeCounter("permission", 2000);
                this.initializeCounter(TAG_USES_PERMISSION, 20000);
                break;
            }
            case "provider": {
                this.initializeCounter(TAG_GRANT_URI_PERMISSION, 100);
                this.initializeCounter(TAG_PATH_PERMISSION, 100);
                this.initializeCounter(TAG_META_DATA, 1000);
                this.initializeCounter(TAG_INTENT_FILTER, 20000);
                break;
            }
            case "queries": {
                this.initializeCounter("package", 1000);
                this.initializeCounter(TAG_INTENT, 2000);
                this.initializeCounter(TAG_PROVIDER, 8000);
                break;
            }
            case "uri-relative-filter-group": {
                this.initializeCounter(TAG_DATA, 100);
            }
        }
    }

    private static int getAttrStrMaxLen(String attrName) {
        switch (attrName) {
            case "host": 
            case "port": 
            case "scheme": {
                return 256;
            }
            case "permissionGroup": {
                return 256;
            }
            case "sharedUserId": 
            case "package": 
            case "targetPackage": {
                return 256;
            }
            case "mimeType": {
                return 255;
            }
            case "backupAgent": 
            case "category": 
            case "manageSpaceActivity": 
            case "mimeGroup": 
            case "name": 
            case "parentActivityName": 
            case "permission": 
            case "process": 
            case "readPermission": 
            case "requiredAccountType": 
            case "requiredSystemPropertyName": 
            case "restrictedAccountType": 
            case "targetActivity": 
            case "targetName": 
            case "targetProcesses": 
            case "taskAffinity": 
            case "writePermission": 
            case "versionName": 
            case "zygotePreloadName": {
                return 1024;
            }
            case "fragment": 
            case "fragmentAdvancedPattern": 
            case "fragmentPattern": 
            case "fragmentPrefix": 
            case "fragmentSuffix": 
            case "path": 
            case "pathAdvancedPattern": 
            case "pathPattern": 
            case "pathPrefix": 
            case "pathSuffix": 
            case "query": 
            case "queryAdvancedPattern": 
            case "queryPattern": 
            case "queryPrefix": 
            case "querySuffix": {
                return 4000;
            }
            case "value": {
                return 32768;
            }
            case "requiredSystemPropertyValue": {
                return 91;
            }
        }
        return 32768;
    }

    private int getResStrMaxLen(@StyleableRes int index) {
        switch (this.mTag) {
            case "action": {
                return Element.getActionResStrMaxLen(index);
            }
            case "activity": {
                return Element.getActivityResStrMaxLen(index);
            }
            case "activity-alias": {
                return Element.getActivityAliasResStrMaxLen(index);
            }
            case "application": {
                return Element.getApplicationResStrMaxLen(index);
            }
            case "data": {
                return Element.getDataResStrMaxLen(index);
            }
            case "category": {
                return Element.getCategoryResStrMaxLen(index);
            }
            case "grant-uri-permission": {
                return Element.getGrantUriPermissionResStrMaxLen(index);
            }
            case "instrumentation": {
                return Element.getInstrumentationResStrMaxLen(index);
            }
            case "manifest": {
                return Element.getManifestResStrMaxLen(index);
            }
            case "meta-data": {
                return Element.getMetaDataResStrMaxLen(index);
            }
            case "overlay": {
                return Element.getOverlayResStrMaxLen(index);
            }
            case "path-permission": {
                return Element.getPathPermissionResStrMaxLen(index);
            }
            case "permission": {
                return Element.getPermissionResStrMaxLen(index);
            }
            case "permission-group": {
                return Element.getPermissionGroupResStrMaxLen(index);
            }
            case "permission-tree": {
                return Element.getPermissionTreeResStrMaxLen(index);
            }
            case "property": {
                return Element.getPropertyResStrMaxLen(index);
            }
            case "provider": {
                return Element.getProviderResStrMaxLen(index);
            }
            case "receiver": {
                return Element.getReceiverResStrMaxLen(index);
            }
            case "service": {
                return Element.getServiceResStrMaxLen(index);
            }
            case "uses-feature": {
                return Element.getUsesFeatureResStrMaxLen(index);
            }
            case "uses-library": {
                return Element.getUsesLibraryResStrMaxLen(index);
            }
            case "uses-native-library": {
                return Element.getUsesNativeLibraryResStrMaxLen(index);
            }
            case "uses-permission": 
            case "uses-permission-sdk-23": 
            case "uses-permission-sdk-m": {
                return Element.getUsesPermissionResStrMaxLen(index);
            }
        }
        return 32768;
    }

    private static int getActionResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getActivityResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 27: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getActivityAliasResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: 
            case 3: 
            case 7: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getApplicationResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 3: 
            case 4: 
            case 6: 
            case 11: 
            case 12: 
            case 16: 
            case 28: 
            case 29: 
            case 52: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getCategoryResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getDataResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 1: 
            case 2: 
            case 3: {
                return 256;
            }
            case 0: {
                return 255;
            }
            case 11: {
                return 1024;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                return 4000;
            }
        }
        return 32768;
    }

    private static int getGrantUriPermissionResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return 4000;
            }
        }
        return 32768;
    }

    private static int getInstrumentationResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 3: {
                return 256;
            }
            case 2: 
            case 9: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getManifestResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 256;
            }
            case 2: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getMetaDataResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
            case 1: {
                return 32768;
            }
        }
        return 32768;
    }

    private static int getOverlayResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 1: {
                return 256;
            }
            case 2: 
            case 3: 
            case 5: {
                return 1024;
            }
            case 6: {
                return 91;
            }
        }
        return 32768;
    }

    private static int getPathPermissionResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return 1024;
            }
            case 3: 
            case 4: 
            case 5: {
                return 4000;
            }
        }
        return 32768;
    }

    private static int getPermissionResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 4: {
                return 256;
            }
            case 2: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getPermissionGroupResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getPermissionTreeResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getPropertyResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
            case 1: {
                return 32768;
            }
        }
        return 32768;
    }

    private static int getProviderResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getReceiverResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: 
            case 3: 
            case 6: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getServiceResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 2: 
            case 3: 
            case 6: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getUsesFeatureResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getUsesLibraryResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getUsesNativeLibraryResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private static int getUsesPermissionResStrMaxLen(@StyleableRes int index) {
        switch (index) {
            case 0: {
                return 1024;
            }
        }
        return 32768;
    }

    private void initializeCounter(String tag, int max) {
        int idx = Element.getCounterIdx(tag);
        if (this.mTagCounters[idx] == null) {
            this.mTagCounters[idx] = new TagCounter();
        }
        this.mTagCounters[idx].reset(max);
        this.mChildTagMask |= (long)(1 << idx);
    }

    private boolean isComponentNameAttr(String name) {
        switch (this.mTag) {
            case "activity": {
                switch (name) {
                    case "name": 
                    case "parentActivityName": {
                        return true;
                    }
                }
                return false;
            }
            case "activity-alias": {
                switch (name) {
                    case "targetActivity": {
                        return true;
                    }
                }
                return false;
            }
            case "application": {
                switch (name) {
                    case "backupAgent": 
                    case "name": 
                    case "zygotePreloadName": {
                        return true;
                    }
                }
                return false;
            }
            case "instrumentation": 
            case "provider": 
            case "receiver": 
            case "service": {
                switch (name) {
                    case "name": {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean isComponentNameAttr(@StyleableRes int index) {
        switch (this.mTag) {
            case "activity": {
                return index == 3 || index == 27;
            }
            case "activity-alias": {
                return index == 7;
            }
            case "application": {
                return index == 16 || index == 3 || index == 52;
            }
            case "instrumentation": {
                return index == 2;
            }
            case "provider": {
                return index == 2;
            }
            case "receiver": {
                return index == 2;
            }
            case "service": {
                return index == 2;
            }
        }
        return false;
    }

    boolean hasChild(String tag) {
        return (this.mChildTagMask & (long)(1 << Element.getCounterIdx(tag))) != 0L;
    }

    void validateComponentName(CharSequence name) {
        boolean isStart = true;
        for (int i = 0; i < name.length(); ++i) {
            if (BAD_COMPONENT_NAME_CHARS.indexOf(name.charAt(i)) < 0) continue;
            Slog.e(TAG, name + " is not a valid Java class name");
            throw new SecurityException(name + " is not a valid Java class name");
        }
    }

    void validateStrAttr(String attrName, String attrValue) {
        if (attrValue != null && attrValue.length() > Element.getAttrStrMaxLen(attrName)) {
            throw new SecurityException("String length limit exceeded for attribute " + attrName + " in " + this.mTag);
        }
        if (this.isComponentNameAttr(attrName)) {
            this.validateComponentName(attrValue);
        }
    }

    void validateResStrAttr(@StyleableRes int index, CharSequence stringValue) {
        if (stringValue != null && stringValue.length() > this.getResStrMaxLen(index)) {
            throw new SecurityException("String length limit exceeded for attribute in " + this.mTag);
        }
        if (this.isComponentNameAttr(index)) {
            this.validateComponentName(stringValue);
        }
    }

    void validateComponentMetadata(String value) {
        this.mTotalComponentMetadataSize += value.length();
        if (this.mTotalComponentMetadataSize > 262144) {
            throw new SecurityException("Max total meta data size limit exceeded for " + this.mTag);
        }
    }

    void seen(@NonNull Element element) {
        TagCounter counter = this.mTagCounters[Element.getCounterIdx(element.mTag)];
        if (counter != null) {
            counter.increment();
            if (!counter.isValid()) {
                throw new SecurityException("The number of child " + element.mTag + " elements exceeded the max allowed in " + this.mTag);
            }
        }
    }
}

