/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class Credential
implements Parcelable {
    @NonNull
    public static final String TYPE_PASSWORD_CREDENTIAL = "android.credentials.TYPE_PASSWORD_CREDENTIAL";
    @NonNull
    private final String mType;
    @NonNull
    private final Bundle mData;
    @NonNull
    public static final Parcelable.Creator<Credential> CREATOR = new Parcelable.Creator<Credential>(){

        public Credential[] newArray(int size) {
            return new Credential[size];
        }

        @Override
        public Credential createFromParcel(@NonNull Parcel in) {
            return new Credential(in);
        }
    };

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public Bundle getData() {
        return this.mData;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mType);
        dest.writeBundle(this.mData);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "Credential {type=" + this.mType + ", data=" + this.mData + "}";
    }

    public Credential(@NonNull String type, @NonNull Bundle data) {
        this.mType = Preconditions.checkStringNotEmpty(type, "type must not be empty");
        this.mData = Objects.requireNonNull(data, "data must not be null");
    }

    private Credential(@NonNull Parcel in) {
        String type = in.readString8();
        Bundle data = in.readBundle();
        this.mType = type;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mData = data;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mData);
    }
}

