/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.content.ComponentName;
import android.credentials.ClearCredentialStateRequest;
import android.credentials.CreateCredentialRequest;
import android.credentials.CredentialProviderInfo;
import android.credentials.GetCredentialRequest;
import android.credentials.IClearCredentialStateCallback;
import android.credentials.ICreateCredentialCallback;
import android.credentials.IGetCandidateCredentialsCallback;
import android.credentials.IGetCredentialCallback;
import android.credentials.IPrepareGetCredentialCallback;
import android.credentials.ISetEnabledProvidersCallback;
import android.credentials.RegisterCredentialDescriptionRequest;
import android.credentials.UnregisterCredentialDescriptionRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ICredentialManager
extends IInterface {
    public static final String DESCRIPTOR = "android.credentials.ICredentialManager";

    public ICancellationSignal executeGetCredential(GetCredentialRequest var1, IGetCredentialCallback var2, String var3) throws RemoteException;

    public ICancellationSignal executePrepareGetCredential(GetCredentialRequest var1, IPrepareGetCredentialCallback var2, IGetCredentialCallback var3, String var4) throws RemoteException;

    public ICancellationSignal executeCreateCredential(CreateCredentialRequest var1, ICreateCredentialCallback var2, String var3) throws RemoteException;

    public ICancellationSignal getCandidateCredentials(GetCredentialRequest var1, IGetCandidateCredentialsCallback var2, IBinder var3, String var4) throws RemoteException;

    public ICancellationSignal clearCredentialState(ClearCredentialStateRequest var1, IClearCredentialStateCallback var2, String var3) throws RemoteException;

    public void setEnabledProviders(List<String> var1, List<String> var2, int var3, ISetEnabledProvidersCallback var4) throws RemoteException;

    public void registerCredentialDescription(RegisterCredentialDescriptionRequest var1, String var2) throws RemoteException;

    public void unregisterCredentialDescription(UnregisterCredentialDescriptionRequest var1, String var2) throws RemoteException;

    public boolean isEnabledCredentialProviderService(ComponentName var1, String var2) throws RemoteException;

    public List<CredentialProviderInfo> getCredentialProviderServices(int var1, int var2) throws RemoteException;

    public List<CredentialProviderInfo> getCredentialProviderServicesForTesting(int var1) throws RemoteException;

    public boolean isServiceEnabled() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICredentialManager {
        static final int TRANSACTION_executeGetCredential = 1;
        static final int TRANSACTION_executePrepareGetCredential = 2;
        static final int TRANSACTION_executeCreateCredential = 3;
        static final int TRANSACTION_getCandidateCredentials = 4;
        static final int TRANSACTION_clearCredentialState = 5;
        static final int TRANSACTION_setEnabledProviders = 6;
        static final int TRANSACTION_registerCredentialDescription = 7;
        static final int TRANSACTION_unregisterCredentialDescription = 8;
        static final int TRANSACTION_isEnabledCredentialProviderService = 9;
        static final int TRANSACTION_getCredentialProviderServices = 10;
        static final int TRANSACTION_getCredentialProviderServicesForTesting = 11;
        static final int TRANSACTION_isServiceEnabled = 12;

        public Stub() {
            this.attachInterface(this, ICredentialManager.DESCRIPTOR);
        }

        public static ICredentialManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICredentialManager.DESCRIPTOR);
            if (iin != null && iin instanceof ICredentialManager) {
                return (ICredentialManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "executeGetCredential";
                }
                case 2: {
                    return "executePrepareGetCredential";
                }
                case 3: {
                    return "executeCreateCredential";
                }
                case 4: {
                    return "getCandidateCredentials";
                }
                case 5: {
                    return "clearCredentialState";
                }
                case 6: {
                    return "setEnabledProviders";
                }
                case 7: {
                    return "registerCredentialDescription";
                }
                case 8: {
                    return "unregisterCredentialDescription";
                }
                case 9: {
                    return "isEnabledCredentialProviderService";
                }
                case 10: {
                    return "getCredentialProviderServices";
                }
                case 11: {
                    return "getCredentialProviderServicesForTesting";
                }
                case 12: {
                    return "isServiceEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICredentialManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    GetCredentialRequest _arg0 = data.readTypedObject(GetCredentialRequest.CREATOR);
                    IGetCredentialCallback _arg1 = IGetCredentialCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.executeGetCredential(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    GetCredentialRequest _arg0 = data.readTypedObject(GetCredentialRequest.CREATOR);
                    IPrepareGetCredentialCallback _arg1 = IPrepareGetCredentialCallback.Stub.asInterface(data.readStrongBinder());
                    IGetCredentialCallback _arg2 = IGetCredentialCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.executePrepareGetCredential(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    CreateCredentialRequest _arg0 = data.readTypedObject(CreateCredentialRequest.CREATOR);
                    ICreateCredentialCallback _arg1 = ICreateCredentialCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.executeCreateCredential(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    GetCredentialRequest _arg0 = data.readTypedObject(GetCredentialRequest.CREATOR);
                    IGetCandidateCredentialsCallback _arg1 = IGetCandidateCredentialsCallback.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg2 = data.readStrongBinder();
                    String _arg3 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.getCandidateCredentials(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    ClearCredentialStateRequest _arg0 = data.readTypedObject(ClearCredentialStateRequest.CREATOR);
                    IClearCredentialStateCallback _arg1 = IClearCredentialStateCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.clearCredentialState(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    int _arg2 = data.readInt();
                    ISetEnabledProvidersCallback _arg3 = ISetEnabledProvidersCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setEnabledProviders(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    RegisterCredentialDescriptionRequest _arg0 = data.readTypedObject(RegisterCredentialDescriptionRequest.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.registerCredentialDescription(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    UnregisterCredentialDescriptionRequest _arg0 = data.readTypedObject(UnregisterCredentialDescriptionRequest.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.unregisterCredentialDescription(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.isEnabledCredentialProviderService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<CredentialProviderInfo> _result = this.getCredentialProviderServices(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<CredentialProviderInfo> _result = this.getCredentialProviderServicesForTesting(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 12: {
                    boolean _result = this.isServiceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements ICredentialManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICredentialManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal executeGetCredential(GetCredentialRequest request, IGetCredentialCallback callback, String callingPackage) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal executePrepareGetCredential(GetCredentialRequest request, IPrepareGetCredentialCallback prepareGetCredentialCallback, IGetCredentialCallback getCredentialCallback, String callingPackage) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(prepareGetCredentialCallback);
                    _data.writeStrongInterface(getCredentialCallback);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal executeCreateCredential(CreateCredentialRequest request, ICreateCredentialCallback callback, String callingPackage) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal getCandidateCredentials(GetCredentialRequest request, IGetCandidateCredentialsCallback callback, IBinder clientCallback, String callingPackage) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeStrongBinder(clientCallback);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal clearCredentialState(ClearCredentialStateRequest request, IClearCredentialStateCallback callback, String callingPackage) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEnabledProviders(List<String> primaryProviders, List<String> providers, int userId, ISetEnabledProvidersCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeStringList(primaryProviders);
                    _data.writeStringList(providers);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCredentialDescription(RegisterCredentialDescriptionRequest request, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCredentialDescription(UnregisterCredentialDescriptionRequest request, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isEnabledCredentialProviderService(ComponentName componentName, String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CredentialProviderInfo> getCredentialProviderServices(int userId, int providerFilter) throws RemoteException {
                ArrayList<CredentialProviderInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(providerFilter);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(CredentialProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<CredentialProviderInfo> getCredentialProviderServicesForTesting(int providerFilter) throws RemoteException {
                ArrayList<CredentialProviderInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    _data.writeInt(providerFilter);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(CredentialProviderInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isServiceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ICredentialManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ICredentialManager {
        @Override
        public ICancellationSignal executeGetCredential(GetCredentialRequest request, IGetCredentialCallback callback, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal executePrepareGetCredential(GetCredentialRequest request, IPrepareGetCredentialCallback prepareGetCredentialCallback, IGetCredentialCallback getCredentialCallback, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal executeCreateCredential(CreateCredentialRequest request, ICreateCredentialCallback callback, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal getCandidateCredentials(GetCredentialRequest request, IGetCandidateCredentialsCallback callback, IBinder clientCallback, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal clearCredentialState(ClearCredentialStateRequest request, IClearCredentialStateCallback callback, String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public void setEnabledProviders(List<String> primaryProviders, List<String> providers, int userId, ISetEnabledProvidersCallback callback) throws RemoteException {
        }

        @Override
        public void registerCredentialDescription(RegisterCredentialDescriptionRequest request, String callingPackage) throws RemoteException {
        }

        @Override
        public void unregisterCredentialDescription(UnregisterCredentialDescriptionRequest request, String callingPackage) throws RemoteException {
        }

        @Override
        public boolean isEnabledCredentialProviderService(ComponentName componentName, String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public List<CredentialProviderInfo> getCredentialProviderServices(int userId, int providerFilter) throws RemoteException {
            return null;
        }

        @Override
        public List<CredentialProviderInfo> getCredentialProviderServicesForTesting(int providerFilter) throws RemoteException {
            return null;
        }

        @Override
        public boolean isServiceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

