/*
 * Decompiled with CFR 0.152.
 */
package android.credentials.selection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.credentials.selection.AuthenticationEntry;
import android.credentials.selection.Entry;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;

@SystemApi
@FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
public class GetCredentialProviderInfo {
    @NonNull
    private final String mProviderName;
    @NonNull
    private final List<Entry> mCredentialEntries;
    @NonNull
    private final List<Entry> mActionChips;
    @NonNull
    private final List<AuthenticationEntry> mAuthenticationEntries;
    @Nullable
    private final Entry mRemoteEntry;

    GetCredentialProviderInfo(@NonNull String providerName, @NonNull List<Entry> credentialEntries, @NonNull List<Entry> actionChips, @NonNull List<AuthenticationEntry> authenticationEntries, @Nullable Entry remoteEntry) {
        this.mProviderName = Preconditions.checkStringNotEmpty(providerName);
        this.mCredentialEntries = new ArrayList<Entry>(credentialEntries);
        this.mActionChips = new ArrayList<Entry>(actionChips);
        this.mAuthenticationEntries = new ArrayList<AuthenticationEntry>(authenticationEntries);
        this.mRemoteEntry = remoteEntry;
    }

    @NonNull
    public String getProviderName() {
        return this.mProviderName;
    }

    @NonNull
    public List<Entry> getCredentialEntries() {
        return this.mCredentialEntries;
    }

    @NonNull
    public List<Entry> getActionChips() {
        return this.mActionChips;
    }

    @NonNull
    public List<AuthenticationEntry> getAuthenticationEntries() {
        return this.mAuthenticationEntries;
    }

    @Nullable
    public Entry getRemoteEntry() {
        return this.mRemoteEntry;
    }

    @SystemApi
    @FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
    public static class Builder {
        @NonNull
        private String mProviderName;
        @NonNull
        private List<Entry> mCredentialEntries = new ArrayList<Entry>();
        @NonNull
        private List<Entry> mActionChips = new ArrayList<Entry>();
        @NonNull
        private List<AuthenticationEntry> mAuthenticationEntries = new ArrayList<AuthenticationEntry>();
        @Nullable
        private Entry mRemoteEntry = null;

        public Builder(@NonNull String providerName) {
            this.mProviderName = Preconditions.checkStringNotEmpty(providerName);
        }

        @NonNull
        public Builder setCredentialEntries(@NonNull List<Entry> credentialEntries) {
            this.mCredentialEntries = credentialEntries;
            return this;
        }

        @NonNull
        public Builder setActionChips(@NonNull List<Entry> actionChips) {
            this.mActionChips = actionChips;
            return this;
        }

        @NonNull
        public Builder setAuthenticationEntries(@NonNull List<AuthenticationEntry> authenticationEntry) {
            this.mAuthenticationEntries = authenticationEntry;
            return this;
        }

        @NonNull
        public Builder setRemoteEntry(@Nullable Entry remoteEntry) {
            this.mRemoteEntry = remoteEntry;
            return this;
        }

        @NonNull
        public GetCredentialProviderInfo build() {
            return new GetCredentialProviderInfo(this.mProviderName, this.mCredentialEntries, this.mActionChips, this.mAuthenticationEntries, this.mRemoteEntry);
        }
    }
}

