/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteSession;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.Reference;
import java.util.Objects;

public class SQLiteRawStatement
implements Closeable {
    private static final String TAG = "SQLiteRawStatement";
    private final SQLiteDatabase mDatabase;
    private final SQLiteSession mSession;
    private SQLiteConnection.PreparedStatement mPreparedStatement;
    private final long mStatement;
    private final String mSql;
    private Thread mThread = Thread.currentThread();
    public static final int SQLITE_DATA_TYPE_INTEGER = 1;
    public static final int SQLITE_DATA_TYPE_FLOAT = 2;
    public static final int SQLITE_DATA_TYPE_TEXT = 3;
    public static final int SQLITE_DATA_TYPE_BLOB = 4;
    public static final int SQLITE_DATA_TYPE_NULL = 5;
    private static final int SQLITE_BUSY = 5;
    private static final int SQLITE_LOCKED = 6;
    private static final int SQLITE_ROW = 100;
    private static final int SQLITE_DONE = 101;

    SQLiteRawStatement(@NonNull SQLiteDatabase db, @NonNull String sql) {
        this.mDatabase = db;
        this.mSession = this.mDatabase.getThreadSession();
        this.mSession.throwIfNoTransaction();
        this.mSql = sql;
        this.mPreparedStatement = this.mSession.acquirePersistentStatement(this.mSql, this);
        this.mStatement = this.mPreparedStatement.mStatementPtr;
    }

    private void throwIfInvalid() {
        if (this.mThread != Thread.currentThread()) {
            if (this.mThread == null) {
                throw new IllegalStateException("method called on a closed statement");
            }
            throw new IllegalStateException("method called on a foreign thread: " + this.mThread);
        }
    }

    private void throwIfInvalidBounds(int arrayLength, int offset, int length) {
        if (arrayLength < 0) {
            throw new IllegalArgumentException("invalid array length " + arrayLength);
        }
        if (offset < 0 || offset >= arrayLength) {
            throw new IllegalArgumentException("invalid offset " + offset + " for array length " + arrayLength);
        }
        if (length <= 0 || arrayLength - offset < length) {
            throw new IllegalArgumentException("invalid offset " + offset + " and length " + length + " for array length " + arrayLength);
        }
    }

    @Override
    public void close() {
        if (this.mThread != null) {
            this.throwIfInvalid();
            this.mSession.releasePersistentStatement(this.mPreparedStatement, this);
            this.mThread = null;
        }
    }

    public boolean isOpen() {
        return this.mThread != null;
    }

    public boolean step() {
        this.throwIfInvalid();
        try {
            int err = SQLiteRawStatement.nativeStep(this.mStatement, true);
            switch (err) {
                case 100: {
                    boolean bl = true;
                    return bl;
                }
                case 101: {
                    boolean bl = false;
                    return bl;
                }
                case 5: {
                    throw new SQLiteDatabaseLockedException("database " + this.mDatabase + " busy");
                }
                case 6: {
                    throw new SQLiteDatabaseLockedException("database " + this.mDatabase + " locked");
                }
            }
            throw new SQLiteException("unknown error " + err);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int stepNoThrow() {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeStep(this.mStatement, false);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void reset() {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeReset(this.mStatement, false);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void clearBindings() {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeClearBindings(this.mStatement);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getParameterCount() {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeBindParameterCount(this.mStatement);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getParameterIndex(@NonNull String name) {
        Objects.requireNonNull(name);
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeBindParameterIndex(this.mStatement, name);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Nullable
    public String getParameterName(int parameterIndex) {
        this.throwIfInvalid();
        try {
            String string2 = SQLiteRawStatement.nativeBindParameterName(this.mStatement, parameterIndex);
            return string2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void bindBlob(int parameterIndex, @NonNull byte[] value) {
        Objects.requireNonNull(value);
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindBlob(this.mStatement, parameterIndex, value, 0, value.length);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindBlob(int parameterIndex, @NonNull byte[] value, int offset, int length) {
        Objects.requireNonNull(value);
        this.throwIfInvalid();
        this.throwIfInvalidBounds(value.length, offset, length);
        try {
            SQLiteRawStatement.nativeBindBlob(this.mStatement, parameterIndex, value, offset, length);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindDouble(int parameterIndex, double value) {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindDouble(this.mStatement, parameterIndex, value);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void bindInt(int parameterIndex, int value) {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindInt(this.mStatement, parameterIndex, value);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindLong(int parameterIndex, long value) {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindLong(this.mStatement, parameterIndex, value);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void bindNull(int parameterIndex) {
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindNull(this.mStatement, parameterIndex);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public void bindText(int parameterIndex, @NonNull String value) {
        Objects.requireNonNull(value);
        this.throwIfInvalid();
        try {
            SQLiteRawStatement.nativeBindText(this.mStatement, parameterIndex, value);
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getResultColumnCount() {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeColumnCount(this.mStatement);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getColumnType(int columnIndex) {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeColumnType(this.mStatement, columnIndex);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @NonNull
    public String getColumnName(int columnIndex) {
        this.throwIfInvalid();
        try {
            String string2 = SQLiteRawStatement.nativeColumnName(this.mStatement, columnIndex);
            return string2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getColumnLength(int columnIndex) {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeColumnBytes(this.mStatement, columnIndex);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Nullable
    public byte[] getColumnBlob(int columnIndex) {
        this.throwIfInvalid();
        try {
            byte[] byArray = SQLiteRawStatement.nativeColumnBlob(this.mStatement, columnIndex);
            return byArray;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readColumnBlob(int columnIndex, @NonNull byte[] buffer, int offset, int length, int srcOffset) {
        Objects.requireNonNull(buffer);
        this.throwIfInvalid();
        this.throwIfInvalidBounds(buffer.length, offset, length);
        try {
            int n = SQLiteRawStatement.nativeColumnBuffer(this.mStatement, columnIndex, buffer, offset, length, srcOffset);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getColumnDouble(int columnIndex) {
        this.throwIfInvalid();
        try {
            double d = SQLiteRawStatement.nativeColumnDouble(this.mStatement, columnIndex);
            return d;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public int getColumnInt(int columnIndex) {
        this.throwIfInvalid();
        try {
            int n = SQLiteRawStatement.nativeColumnInt(this.mStatement, columnIndex);
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getColumnLong(int columnIndex) {
        this.throwIfInvalid();
        try {
            long l = SQLiteRawStatement.nativeColumnLong(this.mStatement, columnIndex);
            return l;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @NonNull
    public String getColumnText(int columnIndex) {
        this.throwIfInvalid();
        try {
            String string2 = SQLiteRawStatement.nativeColumnText(this.mStatement, columnIndex);
            return string2;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    public String toString() {
        if (this.isOpen()) {
            return "SQLiteRawStatement: " + this.mSql;
        }
        return "SQLiteRawStatement: (closed) " + this.mSql;
    }

    @FastNative
    private static int nativeBindParameterCount(long l) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeBindParameterCount(J)I", true, null);
    }

    @FastNative
    private static int nativeBindParameterIndex(long l, String string2) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeBindParameterIndex(JLjava/lang/String;)I", true, null);
    }

    @FastNative
    private static String nativeBindParameterName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteRawStatement#nativeBindParameterName(JI)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static int nativeColumnCount(long l) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeColumnCount(J)I", true, null);
    }

    private static int nativeStep(long l, boolean bl) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeStep(JZ)I", true, null);
    }

    private static void nativeReset(long l, boolean bl) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeReset(JZ)V", true, null);
    }

    @FastNative
    private static void nativeClearBindings(long l) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeClearBindings(J)V", true, null);
    }

    @FastNative
    private static void nativeBindBlob(long l, int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindBlob(JI[BII)V", true, null);
    }

    @FastNative
    private static void nativeBindDouble(long l, int n, double d) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindDouble(JID)V", true, null);
    }

    @FastNative
    private static void nativeBindInt(long l, int n, int n2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindInt(JII)V", true, null);
    }

    @FastNative
    private static void nativeBindLong(long l, int n, long l2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindLong(JIJ)V", true, null);
    }

    @FastNative
    private static void nativeBindNull(long l, int n) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindNull(JI)V", true, null);
    }

    @FastNative
    private static void nativeBindText(long l, int n, String string2) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteRawStatement#nativeBindText(JILjava/lang/String;)V", true, null);
    }

    @FastNative
    private static int nativeColumnType(long l, int n) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeColumnType(JI)I", true, null);
    }

    @FastNative
    private static String nativeColumnName(long l, int n) {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteRawStatement#nativeColumnName(JI)Ljava/lang/String;", true, null);
    }

    @FastNative
    private static int nativeColumnBytes(long l, int n) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeColumnBytes(JI)I", true, null);
    }

    @FastNative
    private static byte[] nativeColumnBlob(long l, int n) {
        return (byte[])OverrideMethod.invokeA("android.database.sqlite.SQLiteRawStatement#nativeColumnBlob(JI)[B", true, null);
    }

    @FastNative
    private static int nativeColumnBuffer(long l, int n, byte[] byArray, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeColumnBuffer(JI[BIII)I", true, null);
    }

    @FastNative
    private static double nativeColumnDouble(long l, int n) {
        return OverrideMethod.invokeD("android.database.sqlite.SQLiteRawStatement#nativeColumnDouble(JI)D", true, null);
    }

    @FastNative
    private static int nativeColumnInt(long l, int n) {
        return OverrideMethod.invokeI("android.database.sqlite.SQLiteRawStatement#nativeColumnInt(JI)I", true, null);
    }

    @FastNative
    private static long nativeColumnLong(long l, int n) {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteRawStatement#nativeColumnLong(JI)J", true, null);
    }

    @FastNative
    private static String nativeColumnText(long l, int n) {
        return (String)OverrideMethod.invokeA("android.database.sqlite.SQLiteRawStatement#nativeColumnText(JI)Ljava/lang/String;", true, null);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SQLiteDataType {
    }
}

