/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public enum BlendMode {
    CLEAR(0),
    SRC(1),
    DST(2),
    SRC_OVER(3),
    DST_OVER(4),
    SRC_IN(5),
    DST_IN(6),
    SRC_OUT(7),
    DST_OUT(8),
    SRC_ATOP(9),
    DST_ATOP(10),
    XOR(11),
    PLUS(12),
    MODULATE(13),
    SCREEN(14),
    OVERLAY(15),
    DARKEN(16),
    LIGHTEN(17),
    COLOR_DODGE(18),
    COLOR_BURN(19),
    HARD_LIGHT(20),
    SOFT_LIGHT(21),
    DIFFERENCE(22),
    EXCLUSION(23),
    MULTIPLY(24),
    HUE(25),
    SATURATION(26),
    COLOR(27),
    LUMINOSITY(28);

    private static final BlendMode[] BLEND_MODES;
    @NonNull
    private final PorterDuffXfermode mXfermode = new PorterDuffXfermode();

    @Nullable
    public static BlendMode fromValue(int value) {
        for (BlendMode mode : BLEND_MODES) {
            if (mode.mXfermode.porterDuffMode != value) continue;
            return mode;
        }
        return null;
    }

    public static int toValue(BlendMode mode) {
        return mode.getXfermode().porterDuffMode;
    }

    @Nullable
    public static PorterDuff.Mode blendModeToPorterDuffMode(@Nullable BlendMode mode) {
        if (mode != null) {
            switch (mode.ordinal()) {
                case 0: {
                    return PorterDuff.Mode.CLEAR;
                }
                case 1: {
                    return PorterDuff.Mode.SRC;
                }
                case 2: {
                    return PorterDuff.Mode.DST;
                }
                case 3: {
                    return PorterDuff.Mode.SRC_OVER;
                }
                case 4: {
                    return PorterDuff.Mode.DST_OVER;
                }
                case 5: {
                    return PorterDuff.Mode.SRC_IN;
                }
                case 6: {
                    return PorterDuff.Mode.DST_IN;
                }
                case 7: {
                    return PorterDuff.Mode.SRC_OUT;
                }
                case 8: {
                    return PorterDuff.Mode.DST_OUT;
                }
                case 9: {
                    return PorterDuff.Mode.SRC_ATOP;
                }
                case 10: {
                    return PorterDuff.Mode.DST_ATOP;
                }
                case 11: {
                    return PorterDuff.Mode.XOR;
                }
                case 16: {
                    return PorterDuff.Mode.DARKEN;
                }
                case 17: {
                    return PorterDuff.Mode.LIGHTEN;
                }
                case 13: {
                    return PorterDuff.Mode.MULTIPLY;
                }
                case 14: {
                    return PorterDuff.Mode.SCREEN;
                }
                case 12: {
                    return PorterDuff.Mode.ADD;
                }
                case 15: {
                    return PorterDuff.Mode.OVERLAY;
                }
            }
            return null;
        }
        return null;
    }

    private BlendMode(int mode) {
        this.mXfermode.porterDuffMode = mode;
    }

    @NonNull
    public PorterDuffXfermode getXfermode() {
        return this.mXfermode;
    }

    static {
        BLEND_MODES = BlendMode.values();
    }
}

