/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.ColorSpace;
import android.graphics.RecordingCanvas;
import android.graphics.RenderNode;
import android.hardware.HardwareBuffer;
import android.hardware.SyncFence;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class HardwareBufferRenderer
implements AutoCloseable {
    private static final ColorSpace DEFAULT_COLORSPACE = ColorSpace.get(ColorSpace.Named.SRGB);
    private final HardwareBuffer mHardwareBuffer;
    private final RenderRequest mRenderRequest;
    private final RenderNode mRootNode;
    private final Runnable mCleaner;
    private long mProxy;

    public HardwareBufferRenderer(@NonNull HardwareBuffer buffer) {
        RenderNode rootNode = RenderNode.adopt(HardwareBufferRenderer.nCreateRootRenderNode());
        rootNode.setClipToBounds(false);
        this.mProxy = HardwareBufferRenderer.nCreateHardwareBufferRenderer(buffer, rootNode.mNativeRenderNode);
        this.mCleaner = HardwareBufferRendererHolder.REGISTRY.registerNativeAllocation(this, this.mProxy);
        this.mRenderRequest = new RenderRequest();
        this.mRootNode = rootNode;
        this.mHardwareBuffer = buffer;
    }

    public void setContentRoot(@Nullable RenderNode content) {
        RecordingCanvas canvas = this.mRootNode.beginRecording();
        if (content != null) {
            canvas.drawRenderNode(content);
        }
        this.mRootNode.endRecording();
    }

    @NonNull
    public RenderRequest obtainRenderRequest() {
        this.mRenderRequest.reset();
        return this.mRenderRequest;
    }

    public boolean isClosed() {
        return this.mProxy == 0L;
    }

    @Override
    public void close() {
        HardwareBufferRenderer.nDestroyRootRenderNode(this.mRootNode.mNativeRenderNode);
        if (this.mProxy != 0L) {
            this.mCleaner.run();
            this.mProxy = 0L;
        }
    }

    public void setLightSourceGeometry(float lightX, float lightY, float lightZ, float lightRadius) {
        HardwareBufferRenderer.validateFinite(lightX, "lightX");
        HardwareBufferRenderer.validateFinite(lightY, "lightY");
        HardwareBufferRenderer.validatePositive(lightZ, "lightZ");
        HardwareBufferRenderer.validatePositive(lightRadius, "lightRadius");
        HardwareBufferRenderer.nSetLightGeometry(this.mProxy, lightX, lightY, lightZ, lightRadius);
    }

    public void setLightSourceAlpha(float ambientShadowAlpha, float spotShadowAlpha) {
        HardwareBufferRenderer.validateAlpha(ambientShadowAlpha, "ambientShadowAlpha");
        HardwareBufferRenderer.validateAlpha(spotShadowAlpha, "spotShadowAlpha");
        HardwareBufferRenderer.nSetLightAlpha(this.mProxy, ambientShadowAlpha, spotShadowAlpha);
    }

    static native int nRender(long var0, int var2, int var3, int var4, long var5, Consumer<RenderResult> var7);

    private static native long nCreateRootRenderNode();

    private static native void nDestroyRootRenderNode(long var0);

    private static native long nCreateHardwareBufferRenderer(HardwareBuffer var0, long var1);

    private static native void nSetLightGeometry(long var0, float var2, float var3, float var4, float var5);

    private static native void nSetLightAlpha(long var0, float var2, float var3);

    private static native long nGetFinalizer();

    private static void invokeRenderCallback(@NonNull Consumer<RenderResult> callback, int fd, int status) {
        callback.accept(new RenderResult(SyncFence.adopt(fd), status));
    }

    private static void validateAlpha(float alpha, String argumentName) {
        if (!(alpha >= 0.0f) || !(alpha <= 1.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a valid alpha, " + alpha + " is not in the range of 0.0f to 1.0f");
        }
    }

    private static void validateFinite(float f, String argumentName) {
        if (!Float.isFinite(f)) {
            throw new IllegalArgumentException(argumentName + " must be finite, given=" + f);
        }
    }

    private static void validatePositive(float f, String argumentName) {
        if (!Float.isFinite(f) || !(f >= 0.0f)) {
            throw new IllegalArgumentException(argumentName + " must be a finite positive, given=" + f);
        }
    }

    private static class HardwareBufferRendererHolder {
        public static final NativeAllocationRegistry REGISTRY = NativeAllocationRegistry.createMalloced(HardwareBufferRenderer.class.getClassLoader(), HardwareBufferRenderer.nGetFinalizer());

        private HardwareBufferRendererHolder() {
        }
    }

    public class RenderRequest {
        private ColorSpace mColorSpace = DEFAULT_COLORSPACE;
        private int mTransform = 0;

        private RenderRequest() {
        }

        public void draw(@NonNull Executor executor, @NonNull Consumer<RenderResult> renderCallback) {
            int renderHeight;
            int renderWidth;
            Consumer<RenderResult> wrapped = consumable -> executor.execute(() -> renderCallback.accept((RenderResult)consumable));
            if (!HardwareBufferRenderer.this.isClosed()) {
                if (this.mTransform == 4 || this.mTransform == 7) {
                    renderWidth = HardwareBufferRenderer.this.mHardwareBuffer.getHeight();
                    renderHeight = HardwareBufferRenderer.this.mHardwareBuffer.getWidth();
                } else {
                    renderWidth = HardwareBufferRenderer.this.mHardwareBuffer.getWidth();
                    renderHeight = HardwareBufferRenderer.this.mHardwareBuffer.getHeight();
                }
            } else {
                throw new IllegalStateException("Attempt to draw with a HardwareBufferRenderer instance that has already been closed");
            }
            HardwareBufferRenderer.nRender(HardwareBufferRenderer.this.mProxy, this.mTransform, renderWidth, renderHeight, this.mColorSpace.getNativeInstance(), wrapped);
        }

        private void reset() {
            this.mColorSpace = DEFAULT_COLORSPACE;
            this.mTransform = 0;
        }

        @NonNull
        public RenderRequest setColorSpace(@Nullable ColorSpace colorSpace) {
            this.mColorSpace = colorSpace == null ? DEFAULT_COLORSPACE : colorSpace;
            return this;
        }

        @NonNull
        public RenderRequest setBufferTransform(int bufferTransform) {
            boolean validTransform;
            boolean bl = validTransform = bufferTransform == 0 || bufferTransform == 4 || bufferTransform == 3 || bufferTransform == 7;
            if (!validTransform) {
                throw new IllegalArgumentException("Invalid transform provided, must be one ofthe SurfaceControl.BufferTransform values");
            }
            this.mTransform = bufferTransform;
            return this;
        }
    }

    public static class RenderResult {
        public static final int SUCCESS = 0;
        public static final int ERROR_UNKNOWN = 1;
        private final SyncFence mFence;
        private final int mResultStatus;

        private RenderResult(@NonNull SyncFence fence, int resultStatus) {
            this.mFence = fence;
            this.mResultStatus = resultStatus;
        }

        @NonNull
        public SyncFence getFence() {
            return this.mFence;
        }

        public int getStatus() {
            return this.mResultStatus;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RenderResultStatus {
        }
    }
}

